# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Gunicorn settings for the Debusine server."""

import os

from debusine.project.settings.pkg_paths import DEBUSINE_DATA_PATH

bind = f"unix:{DEBUSINE_DATA_PATH}/debusine.sock"
# Recommended by
# https://docs.gunicorn.org/en/latest/design.html#how-many-workers, but may
# need tuning for individual systems.
workers = os.cpu_count() * 2 + 1
worker_class = "uvicorn.workers.UvicornWorker"
