//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcontainerservice_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerservice/armcontainerservice/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ContainerServiceGetOSOptions.json
func ExampleManagedClustersClient_GetOSOptions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedClustersClient().GetOSOptions(ctx, "location1", &armcontainerservice.ManagedClustersClientGetOSOptionsOptions{ResourceType: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OSOptionProfile = armcontainerservice.OSOptionProfile{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.ContainerService/locations/osOptions"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.ContainerService/locations/location1/osOptions/default"),
	// 	Properties: &armcontainerservice.OSOptionPropertyList{
	// 		OSOptionPropertyList: []*armcontainerservice.OSOptionProperty{
	// 			{
	// 				EnableFipsImage: to.Ptr(false),
	// 				OSType: to.Ptr("Linux"),
	// 			},
	// 			{
	// 				EnableFipsImage: to.Ptr(false),
	// 				OSType: to.Ptr("Windows"),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/KubernetesVersions_List.json
func ExampleManagedClustersClient_ListKubernetesVersions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedClustersClient().ListKubernetesVersions(ctx, "location1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.KubernetesVersionListResult = armcontainerservice.KubernetesVersionListResult{
	// 	Values: []*armcontainerservice.KubernetesVersion{
	// 		{
	// 			Capabilities: &armcontainerservice.KubernetesVersionCapabilities{
	// 				SupportPlan: []*armcontainerservice.KubernetesSupportPlan{
	// 					to.Ptr(armcontainerservice.KubernetesSupportPlanKubernetesOfficial)},
	// 				},
	// 				PatchVersions: map[string]*armcontainerservice.KubernetesPatchVersion{
	// 					"1.23.12": &armcontainerservice.KubernetesPatchVersion{
	// 						Upgrades: []*string{
	// 							to.Ptr("1.23.15"),
	// 							to.Ptr("1.24.6"),
	// 							to.Ptr("1.24.9")},
	// 						},
	// 						"1.23.15": &armcontainerservice.KubernetesPatchVersion{
	// 							Upgrades: []*string{
	// 								to.Ptr("1.24.6"),
	// 								to.Ptr("1.24.9")},
	// 							},
	// 						},
	// 						Version: to.Ptr("1.23"),
	// 					},
	// 					{
	// 						Capabilities: &armcontainerservice.KubernetesVersionCapabilities{
	// 							SupportPlan: []*armcontainerservice.KubernetesSupportPlan{
	// 								to.Ptr(armcontainerservice.KubernetesSupportPlanKubernetesOfficial)},
	// 							},
	// 							PatchVersions: map[string]*armcontainerservice.KubernetesPatchVersion{
	// 								"1.24.6": &armcontainerservice.KubernetesPatchVersion{
	// 									Upgrades: []*string{
	// 										to.Ptr("1.24.9"),
	// 										to.Ptr("1.25.4"),
	// 										to.Ptr("1.25.5")},
	// 									},
	// 									"1.24.9": &armcontainerservice.KubernetesPatchVersion{
	// 										Upgrades: []*string{
	// 											to.Ptr("1.25.4"),
	// 											to.Ptr("1.25.5")},
	// 										},
	// 									},
	// 									Version: to.Ptr("1.24"),
	// 								},
	// 								{
	// 									Capabilities: &armcontainerservice.KubernetesVersionCapabilities{
	// 										SupportPlan: []*armcontainerservice.KubernetesSupportPlan{
	// 											to.Ptr(armcontainerservice.KubernetesSupportPlanKubernetesOfficial)},
	// 										},
	// 										PatchVersions: map[string]*armcontainerservice.KubernetesPatchVersion{
	// 											"1.25.4": &armcontainerservice.KubernetesPatchVersion{
	// 												Upgrades: []*string{
	// 													to.Ptr("1.25.5"),
	// 													to.Ptr("1.26.0")},
	// 												},
	// 												"1.25.5": &armcontainerservice.KubernetesPatchVersion{
	// 													Upgrades: []*string{
	// 														to.Ptr("1.26.0")},
	// 													},
	// 												},
	// 												Version: to.Ptr("1.25"),
	// 											},
	// 											{
	// 												Capabilities: &armcontainerservice.KubernetesVersionCapabilities{
	// 													SupportPlan: []*armcontainerservice.KubernetesSupportPlan{
	// 														to.Ptr(armcontainerservice.KubernetesSupportPlanKubernetesOfficial)},
	// 													},
	// 													PatchVersions: map[string]*armcontainerservice.KubernetesPatchVersion{
	// 														"1.26.0": &armcontainerservice.KubernetesPatchVersion{
	// 															Upgrades: []*string{
	// 															},
	// 														},
	// 													},
	// 													Version: to.Ptr("1.26"),
	// 											}},
	// 										}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersList.json
func ExampleManagedClustersClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedClustersClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagedClusterListResult = armcontainerservice.ManagedClusterListResult{
		// 	Value: []*armcontainerservice.ManagedCluster{
		// 		{
		// 			Name: to.Ptr("clustername1"),
		// 			Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.ContainerService/managedClusters/clustername1"),
		// 			Location: to.Ptr("location1"),
		// 			Tags: map[string]*string{
		// 				"archv2": to.Ptr(""),
		// 				"tier": to.Ptr("production"),
		// 			},
		// 			Properties: &armcontainerservice.ManagedClusterProperties{
		// 				AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
		// 					{
		// 						Count: to.Ptr[int32](3),
		// 						CurrentOrchestratorVersion: to.Ptr("1.9.6"),
		// 						MaxPods: to.Ptr[int32](110),
		// 						OrchestratorVersion: to.Ptr("1.9.6"),
		// 						OSType: to.Ptr(armcontainerservice.OSTypeLinux),
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 						VMSize: to.Ptr("Standard_DS1_v2"),
		// 						Name: to.Ptr("nodepool1"),
		// 				}},
		// 				DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
		// 				DNSPrefix: to.Ptr("dnsprefix1"),
		// 				EnableRBAC: to.Ptr(false),
		// 				Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
		// 				KubernetesVersion: to.Ptr("1.9.6"),
		// 				LinuxProfile: &armcontainerservice.LinuxProfile{
		// 					AdminUsername: to.Ptr("azureuser"),
		// 					SSH: &armcontainerservice.SSHConfiguration{
		// 						PublicKeys: []*armcontainerservice.SSHPublicKey{
		// 							{
		// 								KeyData: to.Ptr("keydata"),
		// 						}},
		// 					},
		// 				},
		// 				MaxAgentPools: to.Ptr[int32](1),
		// 				NetworkProfile: &armcontainerservice.NetworkProfile{
		// 					DNSServiceIP: to.Ptr("10.0.0.10"),
		// 					NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
		// 					PodCidr: to.Ptr("10.244.0.0/16"),
		// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
		// 				},
		// 				NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
		// 					ClientID: to.Ptr("clientid"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersListByResourceGroup.json
func ExampleManagedClustersClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedClustersClient().NewListByResourceGroupPager("rg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ManagedClusterListResult = armcontainerservice.ManagedClusterListResult{
		// 	Value: []*armcontainerservice.ManagedCluster{
		// 		{
		// 			Name: to.Ptr("clustername1"),
		// 			Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
		// 			Location: to.Ptr("location1"),
		// 			Tags: map[string]*string{
		// 				"archv2": to.Ptr(""),
		// 				"tier": to.Ptr("production"),
		// 			},
		// 			Properties: &armcontainerservice.ManagedClusterProperties{
		// 				AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
		// 					{
		// 						Count: to.Ptr[int32](3),
		// 						CurrentOrchestratorVersion: to.Ptr("1.9.6"),
		// 						MaxPods: to.Ptr[int32](110),
		// 						OrchestratorVersion: to.Ptr("1.9.6"),
		// 						OSType: to.Ptr(armcontainerservice.OSTypeLinux),
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 						VMSize: to.Ptr("Standard_DS1_v2"),
		// 						Name: to.Ptr("nodepool1"),
		// 				}},
		// 				DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
		// 				DNSPrefix: to.Ptr("dnsprefix1"),
		// 				EnableRBAC: to.Ptr(false),
		// 				Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
		// 				KubernetesVersion: to.Ptr("1.9.6"),
		// 				LinuxProfile: &armcontainerservice.LinuxProfile{
		// 					AdminUsername: to.Ptr("azureuser"),
		// 					SSH: &armcontainerservice.SSHConfiguration{
		// 						PublicKeys: []*armcontainerservice.SSHPublicKey{
		// 							{
		// 								KeyData: to.Ptr("keydata"),
		// 						}},
		// 					},
		// 				},
		// 				MaxAgentPools: to.Ptr[int32](1),
		// 				NetworkProfile: &armcontainerservice.NetworkProfile{
		// 					DNSServiceIP: to.Ptr("10.0.0.10"),
		// 					NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
		// 					PodCidr: to.Ptr("10.244.0.0/16"),
		// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
		// 				},
		// 				NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
		// 					ClientID: to.Ptr("clientid"),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersGetUpgradeProfile.json
func ExampleManagedClustersClient_GetUpgradeProfile() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedClustersClient().GetUpgradeProfile(ctx, "rg1", "clustername1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedClusterUpgradeProfile = armcontainerservice.ManagedClusterUpgradeProfile{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.ContainerService/managedClusters/upgradeprofiles"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1/upgradeprofiles/default"),
	// 	Properties: &armcontainerservice.ManagedClusterUpgradeProfileProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterPoolUpgradeProfile{
	// 			{
	// 				Name: to.Ptr("agent"),
	// 				KubernetesVersion: to.Ptr("1.7.7"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				Upgrades: []*armcontainerservice.ManagedClusterPoolUpgradeProfileUpgradesItem{
	// 					{
	// 						KubernetesVersion: to.Ptr("1.7.9"),
	// 					},
	// 					{
	// 						IsPreview: to.Ptr(true),
	// 						KubernetesVersion: to.Ptr("1.7.11"),
	// 				}},
	// 		}},
	// 		ControlPlaneProfile: &armcontainerservice.ManagedClusterPoolUpgradeProfile{
	// 			Name: to.Ptr("master"),
	// 			KubernetesVersion: to.Ptr("1.7.7"),
	// 			OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 			Upgrades: []*armcontainerservice.ManagedClusterPoolUpgradeProfileUpgradesItem{
	// 				{
	// 					IsPreview: to.Ptr(true),
	// 					KubernetesVersion: to.Ptr("1.7.9"),
	// 				},
	// 				{
	// 					KubernetesVersion: to.Ptr("1.7.11"),
	// 			}},
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersGetAccessProfile.json
func ExampleManagedClustersClient_GetAccessProfile() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedClustersClient().GetAccessProfile(ctx, "rg1", "clustername1", "clusterUser", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedClusterAccessProfile = armcontainerservice.ManagedClusterAccessProfile{
	// 	Name: to.Ptr("clusterUser"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters/AccessProfiles"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1/accessProfiles/clusterUser"),
	// 	Location: to.Ptr("location1"),
	// 	Properties: &armcontainerservice.AccessProfile{
	// 		KubeConfig: []byte("a3ViZUNvbmZpZzE="),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersListClusterCredentialResult.json
func ExampleManagedClustersClient_ListClusterAdminCredentials() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedClustersClient().ListClusterAdminCredentials(ctx, "rg1", "clustername1", &armcontainerservice.ManagedClustersClientListClusterAdminCredentialsOptions{ServerFqdn: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CredentialResults = armcontainerservice.CredentialResults{
	// 	Kubeconfigs: []*armcontainerservice.CredentialResult{
	// 		{
	// 			Name: to.Ptr("credentialName1"),
	// 			Value: []byte("Y3JlZGVudGlhbFZhbHVlMQ=="),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersGet.json
func ExampleManagedClustersClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedClustersClient().Get(ctx, "rg1", "clustername1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				AvailabilityZones: []*string{
	// 					to.Ptr("1"),
	// 					to.Ptr("2"),
	// 					to.Ptr("3")},
	// 					Count: to.Ptr[int32](3),
	// 					CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 					MaxPods: to.Ptr[int32](110),
	// 					NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 					OrchestratorVersion: to.Ptr("1.9.6"),
	// 					OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					UpgradeSettings: &armcontainerservice.AgentPoolUpgradeSettings{
	// 						MaxSurge: to.Ptr("33%"),
	// 					},
	// 					VMSize: to.Ptr("Standard_DS1_v2"),
	// 					Name: to.Ptr("nodepool1"),
	// 			}},
	// 			AzurePortalFQDN: to.Ptr("dnsprefix1-abcd1234.portal.hcp.eastus.azmk8s.io"),
	// 			DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 			DNSPrefix: to.Ptr("dnsprefix1"),
	// 			EnableRBAC: to.Ptr(false),
	// 			Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 			KubernetesVersion: to.Ptr("1.9.6"),
	// 			LinuxProfile: &armcontainerservice.LinuxProfile{
	// 				AdminUsername: to.Ptr("azureuser"),
	// 				SSH: &armcontainerservice.SSHConfiguration{
	// 					PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 						{
	// 							KeyData: to.Ptr("keydata"),
	// 					}},
	// 				},
	// 			},
	// 			MaxAgentPools: to.Ptr[int32](1),
	// 			NetworkProfile: &armcontainerservice.NetworkProfile{
	// 				DNSServiceIP: to.Ptr("10.0.0.10"),
	// 				IPFamilies: []*armcontainerservice.IPFamily{
	// 					to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 					LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 						AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 						EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 						}},
	// 						IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 						OutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileOutboundIPs{
	// 							PublicIPs: []*armcontainerservice.ResourceReference{
	// 								{
	// 									ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/customeroutboundip1"),
	// 								},
	// 								{
	// 									ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/customeroutboundip2"),
	// 							}},
	// 						},
	// 					},
	// 					LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
	// 					NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 					OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 					PodCidr: to.Ptr("10.244.0.0/16"),
	// 					PodCidrs: []*string{
	// 						to.Ptr("10.244.0.0/16")},
	// 						ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 						ServiceCidrs: []*string{
	// 							to.Ptr("10.0.0.0/16")},
	// 						},
	// 						NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 						ProvisioningState: to.Ptr("Succeeded"),
	// 						ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 							ClientID: to.Ptr("clientid"),
	// 						},
	// 						UpgradeSettings: &armcontainerservice.ClusterUpgradeSettings{
	// 							OverrideSettings: &armcontainerservice.UpgradeOverrideSettings{
	// 								ForceUpgrade: to.Ptr(true),
	// 								Until: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-01T13:00:00.000Z"); return t}()),
	// 							},
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersAssociate_CRG.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_associateManagedClusterWithCapacityReservationGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:                       to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					CapacityReservationGroupID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/capacityReservationGroups/crg1"),
					Count:                      to.Ptr[int32](3),
					EnableNodePublicIP:         to.Ptr(true),
					Mode:                       to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:                     to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:                     to.Ptr("Standard_DS2_v2"),
					Name:                       to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				CapacityReservationGroupID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/capacityReservationGroups/crg1"),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 					WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 						AdminUsername: to.Ptr("azureuser"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_MCSnapshot.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterUsingAManagedClusterSnapshot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableFIPS:         to.Ptr(true),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			CreationData: &armcontainerservice.CreationData{
				SourceResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ContainerService/managedclustersnapshots/snapshot1"),
			},
			DNSPrefix:         to.Ptr("dnsprefix1"),
			KubernetesVersion: to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				EnableFIPS: to.Ptr(true),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		CreationData: &armcontainerservice.CreationData{
	// 			SourceResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ContainerService/managedclustersnapshots/snapshot1"),
	// 		},
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_Snapshot.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterUsingAnAgentPoolSnapshot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:  to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count: to.Ptr[int32](3),
					CreationData: &armcontainerservice.CreationData{
						SourceResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1"),
					},
					EnableFIPS:         to.Ptr(true),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(false),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CreationData: &armcontainerservice.CreationData{
	// 					SourceResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1"),
	// 				},
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableFIPS: to.Ptr(true),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(false),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 					WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 						AdminUsername: to.Ptr("azureuser"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_EnableAIToolchainOperator.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithAiToolchainOperatorEnabled() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AiToolchainOperatorProfile: &armcontainerservice.ManagedClusterAIToolchainOperatorProfile{
				Enabled: to.Ptr(true),
			},
			DNSPrefix:         to.Ptr("dnsprefix1"),
			EnableRBAC:        to.Ptr(true),
			KubernetesVersion: to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU:   to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				NetworkDataplane:  to.Ptr(armcontainerservice.NetworkDataplaneCilium),
				NetworkPlugin:     to.Ptr(armcontainerservice.NetworkPluginAzure),
				NetworkPluginMode: to.Ptr(armcontainerservice.NetworkPluginModeOverlay),
				OutboundType:      to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AiToolchainOperatorProfile: &armcontainerservice.ManagedClusterAIToolchainOperatorProfile{
	// 			Enabled: to.Ptr(true),
	// 		},
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
	// 				NetworkDataplane: to.Ptr(armcontainerservice.NetworkDataplaneCilium),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginAzure),
	// 				NetworkPluginMode: to.Ptr(armcontainerservice.NetworkPluginModeOverlay),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_ManagedNATGateway.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithAksManagedNatGatewayAsOutboundType() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(false),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				NatGatewayProfile: &armcontainerservice.ManagedClusterNATGatewayProfile{
					ManagedOutboundIPProfile: &armcontainerservice.ManagedClusterManagedOutboundIPProfile{
						Count: to.Ptr[int32](2),
					},
				},
				OutboundType: to.Ptr(armcontainerservice.OutboundTypeManagedNATGateway),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableNodePublicIP: to.Ptr(false),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 			NatGatewayProfile: &armcontainerservice.ManagedClusterNATGatewayProfile{
	// 				EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 					{
	// 						ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 					},
	// 					{
	// 						ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 				}},
	// 				IdleTimeoutInMinutes: to.Ptr[int32](4),
	// 				ManagedOutboundIPProfile: &armcontainerservice.ManagedClusterManagedOutboundIPProfile{
	// 					Count: to.Ptr[int32](2),
	// 				},
	// 			},
	// 			NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 			OutboundType: to.Ptr(armcontainerservice.OutboundTypeManagedNATGateway),
	// 			PodCidr: to.Ptr("10.244.0.0/16"),
	// 			ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 		},
	// 		NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 			ClientID: to.Ptr("clientid"),
	// 		},
	// 		WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_AzureKeyvaultSecretsProvider.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithAzureKeyVaultSecretsProviderAddon() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{
				"azureKeyvaultSecretsProvider": {
					Config: map[string]*string{
						"enableSecretRotation": to.Ptr("true"),
						"rotationPollInterval": to.Ptr("2m"),
					},
					Enabled: to.Ptr(true),
				},
			},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{
	// 			"azureKeyvaultSecretsProvider": &armcontainerservice.ManagedClusterAddonProfile{
	// 				Config: map[string]*string{
	// 					"enableSecretRotation": to.Ptr("true"),
	// 					"rotationPollInterval": to.Ptr("2m"),
	// 				},
	// 				Enabled: to.Ptr(true),
	// 			},
	// 		},
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				EnableEncryptionAtHost: to.Ptr(true),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 				AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 				EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 					{
	// 						ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 					},
	// 					{
	// 						ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 				}},
	// 				IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 				ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 					Count: to.Ptr[int32](2),
	// 				},
	// 			},
	// 			LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 			NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 			OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 			PodCidr: to.Ptr("10.244.0.0/16"),
	// 			ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 		},
	// 		NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 			ClientID: to.Ptr("clientid"),
	// 		},
	// 		WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_EnableCustomCATrust.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithCustomCaTrustCertificatesPopulatedAndCustomCaTrustEnabled() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:                to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:               to.Ptr[int32](3),
					EnableCustomCATrust: to.Ptr(true),
					EnableNodePublicIP:  to.Ptr(true),
					Mode:                to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:              to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:              to.Ptr("Standard_DS2_v2"),
					Name:                to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			SecurityProfile: &armcontainerservice.ManagedClusterSecurityProfile{
				CustomCATrustCertificates: [][]byte{
					[]byte("ZHVtbXlFeGFtcGxlVGVzdFZhbHVlRm9yQ2VydGlmaWNhdGVUb0JlQWRkZWQ=")},
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableCustomCATrust: to.Ptr(true),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					SecurityProfile: &armcontainerservice.ManagedClusterSecurityProfile{
	// 						CustomCATrustCertificates: [][]byte{
	// 							[]byte("ZHVtbXlFeGFtcGxlVGVzdFZhbHVlRm9yQ2VydGlmaWNhdGVUb0JlQWRkZWQ=")},
	// 						},
	// 						ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 							ClientID: to.Ptr("clientid"),
	// 						},
	// 						WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 							AdminUsername: to.Ptr("azureuser"),
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_DedicatedHostGroup.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithDedicatedHostGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					HostGroupID:        to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1"),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(false),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				HostGroupID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1"),
	// 				MaxPods: to.Ptr[int32](110),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(false),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 					WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 						AdminUsername: to.Ptr("azureuser"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_EnableEncryptionAtHost.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithEncryptionAtHostEnabled() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:                   to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:                  to.Ptr[int32](3),
					EnableEncryptionAtHost: to.Ptr(true),
					EnableNodePublicIP:     to.Ptr(true),
					Mode:                   to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:                 to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:                 to.Ptr("Standard_DS2_v2"),
					Name:                   to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableEncryptionAtHost: to.Ptr(true),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 					WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 						AdminUsername: to.Ptr("azureuser"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_EnabledFIPS.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithFipsEnabledOs() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableFIPS:         to.Ptr(true),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(false),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableFIPS: to.Ptr(true),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(false),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 					WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 						AdminUsername: to.Ptr("azureuser"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_GPUMIG.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithGpumig() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					GpuInstanceProfile: to.Ptr(armcontainerservice.GPUInstanceProfileMIG3G),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_ND96asr_v4"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			HTTPProxyConfig: &armcontainerservice.ManagedClusterHTTPProxyConfig{
				HTTPProxy:  to.Ptr("http://myproxy.server.com:8080"),
				HTTPSProxy: to.Ptr("https://myproxy.server.com:8080"),
				NoProxy: []*string{
					to.Ptr("localhost"),
					to.Ptr("127.0.0.1")},
				TrustedCa: to.Ptr("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
			},
			KubernetesVersion: to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				GpuInstanceProfile: to.Ptr(armcontainerservice.GPUInstanceProfileMIG3G),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_ND96asr_v4"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		HTTPProxyConfig: &armcontainerservice.ManagedClusterHTTPProxyConfig{
	// 			HTTPProxy: to.Ptr("http://myproxy.server.com:8080"),
	// 			HTTPSProxy: to.Ptr("https://myproxy.server.com:8080"),
	// 			NoProxy: []*string{
	// 				to.Ptr("localhost"),
	// 				to.Ptr("127.0.0.1")},
	// 				TrustedCa: to.Ptr("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
	// 			},
	// 			KubernetesVersion: to.Ptr("1.9.6"),
	// 			LinuxProfile: &armcontainerservice.LinuxProfile{
	// 				AdminUsername: to.Ptr("azureuser"),
	// 				SSH: &armcontainerservice.SSHConfiguration{
	// 					PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 						{
	// 							KeyData: to.Ptr("keydata"),
	// 					}},
	// 				},
	// 			},
	// 			MaxAgentPools: to.Ptr[int32](1),
	// 			NetworkProfile: &armcontainerservice.NetworkProfile{
	// 				DNSServiceIP: to.Ptr("10.0.0.10"),
	// 				IPFamilies: []*armcontainerservice.IPFamily{
	// 					to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 					LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 						AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 						EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 						}},
	// 						IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 						ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 							Count: to.Ptr[int32](2),
	// 						},
	// 					},
	// 					LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 					NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 					OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 					PodCidr: to.Ptr("10.244.0.0/16"),
	// 					PodCidrs: []*string{
	// 						to.Ptr("10.244.0.0/16")},
	// 						ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 						ServiceCidrs: []*string{
	// 							to.Ptr("10.0.0.0/16")},
	// 						},
	// 						NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 						ProvisioningState: to.Ptr("Succeeded"),
	// 						ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 							ClientID: to.Ptr("clientid"),
	// 						},
	// 						WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 							AdminUsername: to.Ptr("azureuser"),
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_HTTPProxy.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithHttpProxyConfigured() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			HTTPProxyConfig: &armcontainerservice.ManagedClusterHTTPProxyConfig{
				HTTPProxy:  to.Ptr("http://myproxy.server.com:8080"),
				HTTPSProxy: to.Ptr("https://myproxy.server.com:8080"),
				NoProxy: []*string{
					to.Ptr("localhost"),
					to.Ptr("127.0.0.1")},
				TrustedCa: to.Ptr("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
			},
			KubernetesVersion: to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		HTTPProxyConfig: &armcontainerservice.ManagedClusterHTTPProxyConfig{
	// 			HTTPProxy: to.Ptr("http://myproxy.server.com:8080"),
	// 			HTTPSProxy: to.Ptr("https://myproxy.server.com:8080"),
	// 			NoProxy: []*string{
	// 				to.Ptr("localhost"),
	// 				to.Ptr("127.0.0.1")},
	// 				TrustedCa: to.Ptr("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
	// 			},
	// 			KubernetesVersion: to.Ptr("1.9.6"),
	// 			LinuxProfile: &armcontainerservice.LinuxProfile{
	// 				AdminUsername: to.Ptr("azureuser"),
	// 				SSH: &armcontainerservice.SSHConfiguration{
	// 					PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 						{
	// 							KeyData: to.Ptr("keydata"),
	// 					}},
	// 				},
	// 			},
	// 			MaxAgentPools: to.Ptr[int32](1),
	// 			NetworkProfile: &armcontainerservice.NetworkProfile{
	// 				DNSServiceIP: to.Ptr("10.0.0.10"),
	// 				IPFamilies: []*armcontainerservice.IPFamily{
	// 					to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 					LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 						AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 						EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 						}},
	// 						IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 						ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 							Count: to.Ptr[int32](2),
	// 						},
	// 					},
	// 					LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 					NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 					OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 					PodCidr: to.Ptr("10.244.0.0/16"),
	// 					PodCidrs: []*string{
	// 						to.Ptr("10.244.0.0/16")},
	// 						ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 						ServiceCidrs: []*string{
	// 							to.Ptr("10.0.0.0/16")},
	// 						},
	// 						NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 						ProvisioningState: to.Ptr("Succeeded"),
	// 						ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 							ClientID: to.Ptr("clientid"),
	// 						},
	// 						WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 							AdminUsername: to.Ptr("azureuser"),
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_Premium.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithLongTermSupport() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:                   to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:                  to.Ptr[int32](3),
					EnableEncryptionAtHost: to.Ptr(true),
					EnableNodePublicIP:     to.Ptr(true),
					Mode:                   to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:                 to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:                 to.Ptr("Standard_DS2_v2"),
					Name:                   to.Ptr("nodepool1"),
				}},
			APIServerAccessProfile: &armcontainerservice.ManagedClusterAPIServerAccessProfile{
				DisableRunCommand: to.Ptr(true),
			},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			SupportPlan: to.Ptr(armcontainerservice.KubernetesSupportPlanAKSLongTermSupport),
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUNameBase),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierPremium),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableEncryptionAtHost: to.Ptr(true),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		APIServerAccessProfile: &armcontainerservice.ManagedClusterAPIServerAccessProfile{
	// 			DisableRunCommand: to.Ptr(true),
	// 		},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-ee788a1f.hcp.location1.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					PrivateFQDN: to.Ptr("dnsprefix1-aae7e0f0.5cef6058-b6b5-414d-8cb1-4bd14eb0b15c.privatelink.location1.azmk8s.io"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 					SupportPlan: to.Ptr(armcontainerservice.KubernetesSupportPlanAKSLongTermSupport),
	// 					WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 						AdminUsername: to.Ptr("azureuser"),
	// 					},
	// 				},
	// 				SKU: &armcontainerservice.ManagedClusterSKU{
	// 					Name: to.Ptr(armcontainerservice.ManagedClusterSKUNameBase),
	// 					Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierPremium),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_NodeAutoProvisioning.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithNodeAutoProvisioning() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU:   to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				NetworkDataplane:  to.Ptr(armcontainerservice.NetworkDataplaneCilium),
				NetworkPlugin:     to.Ptr(armcontainerservice.NetworkPluginAzure),
				NetworkPluginMode: to.Ptr(armcontainerservice.NetworkPluginModeOverlay),
				OutboundType:      to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
	// 				NetworkDataplane: to.Ptr(armcontainerservice.NetworkDataplaneCilium),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginAzure),
	// 				NetworkPluginMode: to.Ptr(armcontainerservice.NetworkPluginModeOverlay),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_NodePublicIPPrefix.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithNodePublicIpPrefix() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:                 to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:                to.Ptr[int32](3),
					EnableNodePublicIP:   to.Ptr(true),
					Mode:                 to.Ptr(armcontainerservice.AgentPoolModeSystem),
					NodePublicIPPrefixID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Network/publicIPPrefixes/public-ip-prefix"),
					OSType:               to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:               to.Ptr("Standard_DS2_v2"),
					Name:                 to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				NodePublicIPPrefixID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Network/publicIPPrefixes/public-ip-prefix"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 					WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 						AdminUsername: to.Ptr("azureuser"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_OSSKU.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithOssku() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSSKU:              to.Ptr(armcontainerservice.OSSKUAzureLinux),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			HTTPProxyConfig: &armcontainerservice.ManagedClusterHTTPProxyConfig{
				HTTPProxy:  to.Ptr("http://myproxy.server.com:8080"),
				HTTPSProxy: to.Ptr("https://myproxy.server.com:8080"),
				NoProxy: []*string{
					to.Ptr("localhost"),
					to.Ptr("127.0.0.1")},
				TrustedCa: to.Ptr("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
			},
			KubernetesVersion: to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSSKU: to.Ptr(armcontainerservice.OSSKUAzureLinux),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		HTTPProxyConfig: &armcontainerservice.ManagedClusterHTTPProxyConfig{
	// 			HTTPProxy: to.Ptr("http://myproxy.server.com:8080"),
	// 			HTTPSProxy: to.Ptr("https://myproxy.server.com:8080"),
	// 			NoProxy: []*string{
	// 				to.Ptr("localhost"),
	// 				to.Ptr("127.0.0.1")},
	// 				TrustedCa: to.Ptr("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
	// 			},
	// 			KubernetesVersion: to.Ptr("1.9.6"),
	// 			LinuxProfile: &armcontainerservice.LinuxProfile{
	// 				AdminUsername: to.Ptr("azureuser"),
	// 				SSH: &armcontainerservice.SSHConfiguration{
	// 					PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 						{
	// 							KeyData: to.Ptr("keydata"),
	// 					}},
	// 				},
	// 			},
	// 			MaxAgentPools: to.Ptr[int32](1),
	// 			NetworkProfile: &armcontainerservice.NetworkProfile{
	// 				DNSServiceIP: to.Ptr("10.0.0.10"),
	// 				IPFamilies: []*armcontainerservice.IPFamily{
	// 					to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 					LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 						AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 						EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 						}},
	// 						IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 						ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 							Count: to.Ptr[int32](2),
	// 						},
	// 					},
	// 					LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 					NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 					OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 					PodCidr: to.Ptr("10.244.0.0/16"),
	// 					PodCidrs: []*string{
	// 						to.Ptr("10.244.0.0/16")},
	// 						ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 						ServiceCidrs: []*string{
	// 							to.Ptr("10.0.0.0/16")},
	// 						},
	// 						NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 						ProvisioningState: to.Ptr("Succeeded"),
	// 						ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 							ClientID: to.Ptr("clientid"),
	// 						},
	// 						WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 							AdminUsername: to.Ptr("azureuser"),
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_PPG.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithPpg() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:                      to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:                     to.Ptr[int32](3),
					EnableNodePublicIP:        to.Ptr(true),
					Mode:                      to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:                    to.Ptr(armcontainerservice.OSTypeLinux),
					ProximityPlacementGroupID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1"),
					VMSize:                    to.Ptr("Standard_DS2_v2"),
					Name:                      to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				ProximityPlacementGroupID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 					WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 						AdminUsername: to.Ptr("azureuser"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_PodIdentity.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithPodIdentityEnabled() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			PodIdentityProfile: &armcontainerservice.ManagedClusterPodIdentityProfile{
				AllowNetworkPluginKubenet: to.Ptr(true),
				Enabled:                   to.Ptr(true),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					PodIdentityProfile: &armcontainerservice.ManagedClusterPodIdentityProfile{
	// 						AllowNetworkPluginKubenet: to.Ptr(true),
	// 						Enabled: to.Ptr(true),
	// 					},
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 					WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 						AdminUsername: to.Ptr("azureuser"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_DisableRunCommand.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithRunCommandDisabled() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:                   to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:                  to.Ptr[int32](3),
					EnableEncryptionAtHost: to.Ptr(true),
					EnableNodePublicIP:     to.Ptr(true),
					Mode:                   to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:                 to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:                 to.Ptr("Standard_DS2_v2"),
					Name:                   to.Ptr("nodepool1"),
				}},
			APIServerAccessProfile: &armcontainerservice.ManagedClusterAPIServerAccessProfile{
				DisableRunCommand: to.Ptr(true),
			},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableEncryptionAtHost: to.Ptr(true),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		APIServerAccessProfile: &armcontainerservice.ManagedClusterAPIServerAccessProfile{
	// 			DisableRunCommand: to.Ptr(true),
	// 		},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-ee788a1f.hcp.location1.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					PrivateFQDN: to.Ptr("dnsprefix1-aae7e0f0.5cef6058-b6b5-414d-8cb1-4bd14eb0b15c.privatelink.location1.azmk8s.io"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 					SupportPlan: to.Ptr(armcontainerservice.KubernetesSupportPlanKubernetesOfficial),
	// 					WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 						AdminUsername: to.Ptr("azureuser"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_SecurityProfile.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithSecurityProfileConfigured() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			DNSPrefix:         to.Ptr("dnsprefix1"),
			KubernetesVersion: to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			SecurityProfile: &armcontainerservice.ManagedClusterSecurityProfile{
				Defender: &armcontainerservice.ManagedClusterSecurityProfileDefender{
					LogAnalyticsWorkspaceResourceID: to.Ptr("/subscriptions/SUB_ID/resourcegroups/RG_NAME/providers/microsoft.operationalinsights/workspaces/WORKSPACE_NAME"),
					SecurityMonitoring: &armcontainerservice.ManagedClusterSecurityProfileDefenderSecurityMonitoring{
						Enabled: to.Ptr(true),
					},
				},
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					SecurityProfile: &armcontainerservice.ManagedClusterSecurityProfile{
	// 						Defender: &armcontainerservice.ManagedClusterSecurityProfileDefender{
	// 							LogAnalyticsWorkspaceResourceID: to.Ptr("/subscriptions/SUB_ID/resourcegroups/RG_NAME/providers/microsoft.operationalinsights/workspaces/WORKSPACE_NAME"),
	// 							SecurityMonitoring: &armcontainerservice.ManagedClusterSecurityProfileDefenderSecurityMonitoring{
	// 								Enabled: to.Ptr(true),
	// 							},
	// 						},
	// 					},
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 					WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 						AdminUsername: to.Ptr("azureuser"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_EnableUltraSSD.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithUltraSsdEnabled() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					EnableUltraSSD:     to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				EnableUltraSSD: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 					WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 						AdminUsername: to.Ptr("azureuser"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_VirtualMachines.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithVirtualMachinesPoolType() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:       to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachines),
					Count:      to.Ptr[int32](3),
					EnableFIPS: to.Ptr(true),
					Mode:       to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:     to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:     to.Ptr("Standard_DS2_v2"),
					Name:       to.Ptr("nodepool1"),
				}},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(false),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachines),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableFIPS: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(false),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_IngressProfile_WebAppRouting.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithWebAppRoutingIngressProfileConfigured() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			DNSPrefix: to.Ptr("dnsprefix1"),
			IngressProfile: &armcontainerservice.ManagedClusterIngressProfile{
				WebAppRouting: &armcontainerservice.ManagedClusterIngressProfileWebAppRouting{
					DNSZoneResourceIDs: []*string{
						to.Ptr("/subscriptions/SUB_ID/resourceGroups/RG_NAME/providers/Microsoft.Network/dnszones/DNS_ZONE_NAME")},
					Enabled: to.Ptr(true),
				},
			},
			KubernetesVersion: to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		IngressProfile: &armcontainerservice.ManagedClusterIngressProfile{
	// 			WebAppRouting: &armcontainerservice.ManagedClusterIngressProfileWebAppRouting{
	// 				DNSZoneResourceIDs: []*string{
	// 					to.Ptr("/subscriptions/SUB_ID/resourceGroups/RG_NAME/providers/Microsoft.Network/dnszones/DNS_ZONE_NAME")},
	// 					Enabled: to.Ptr(true),
	// 				},
	// 			},
	// 			KubernetesVersion: to.Ptr("1.9.6"),
	// 			LinuxProfile: &armcontainerservice.LinuxProfile{
	// 				AdminUsername: to.Ptr("azureuser"),
	// 				SSH: &armcontainerservice.SSHConfiguration{
	// 					PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 						{
	// 							KeyData: to.Ptr("keydata"),
	// 					}},
	// 				},
	// 			},
	// 			MaxAgentPools: to.Ptr[int32](1),
	// 			NetworkProfile: &armcontainerservice.NetworkProfile{
	// 				DNSServiceIP: to.Ptr("10.0.0.10"),
	// 				IPFamilies: []*armcontainerservice.IPFamily{
	// 					to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 					LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 						AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 						EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 						}},
	// 						IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 						ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 							Count: to.Ptr[int32](2),
	// 						},
	// 					},
	// 					LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 					NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 					OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 					PodCidr: to.Ptr("10.244.0.0/16"),
	// 					PodCidrs: []*string{
	// 						to.Ptr("10.244.0.0/16")},
	// 						ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 						ServiceCidrs: []*string{
	// 							to.Ptr("10.0.0.0/16")},
	// 						},
	// 						NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 						ProvisioningState: to.Ptr("Succeeded"),
	// 						ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 							ClientID: to.Ptr("clientid"),
	// 						},
	// 						WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 							AdminUsername: to.Ptr("azureuser"),
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_UserAssignedNATGateway.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedClusterWithUserAssignedNatGatewayAsOutboundType() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(false),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeUserAssignedNATGateway),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableNodePublicIP: to.Ptr(false),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 			NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 			OutboundType: to.Ptr(armcontainerservice.OutboundTypeUserAssignedNATGateway),
	// 			PodCidr: to.Ptr("10.244.0.0/16"),
	// 			ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 		},
	// 		NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 			ClientID: to.Ptr("clientid"),
	// 		},
	// 		WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_PrivateClusterPublicFQDN.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedPrivateClusterWithPublicFqdnSpecified() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:                   to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:                  to.Ptr[int32](3),
					EnableEncryptionAtHost: to.Ptr(true),
					EnableNodePublicIP:     to.Ptr(true),
					Mode:                   to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:                 to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:                 to.Ptr("Standard_DS2_v2"),
					Name:                   to.Ptr("nodepool1"),
				}},
			APIServerAccessProfile: &armcontainerservice.ManagedClusterAPIServerAccessProfile{
				EnablePrivateCluster:           to.Ptr(true),
				EnablePrivateClusterPublicFQDN: to.Ptr(true),
			},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableEncryptionAtHost: to.Ptr(true),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		APIServerAccessProfile: &armcontainerservice.ManagedClusterAPIServerAccessProfile{
	// 			EnablePrivateCluster: to.Ptr(true),
	// 			EnablePrivateClusterPublicFQDN: to.Ptr(true),
	// 			PrivateDNSZone: to.Ptr("system"),
	// 		},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-ee788a1f.hcp.location1.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					PrivateFQDN: to.Ptr("dnsprefix1-aae7e0f0.5cef6058-b6b5-414d-8cb1-4bd14eb0b15c.privatelink.location1.azmk8s.io"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 					WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 						AdminUsername: to.Ptr("azureuser"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_PrivateClusterFQDNSubdomain.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createManagedPrivateClusterWithFqdnSubdomainSpecified() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:                   to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:                  to.Ptr[int32](3),
					EnableEncryptionAtHost: to.Ptr(true),
					EnableNodePublicIP:     to.Ptr(true),
					Mode:                   to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:                 to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:                 to.Ptr("Standard_DS2_v2"),
					Name:                   to.Ptr("nodepool1"),
				}},
			APIServerAccessProfile: &armcontainerservice.ManagedClusterAPIServerAccessProfile{
				EnablePrivateCluster: to.Ptr(true),
				PrivateDNSZone:       to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Network/privateDnsZones/privatelink.location1.azmk8s.io"),
			},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			FqdnSubdomain:           to.Ptr("domain1"),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				EnableEncryptionAtHost: to.Ptr(true),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		APIServerAccessProfile: &armcontainerservice.ManagedClusterAPIServerAccessProfile{
	// 			EnablePrivateCluster: to.Ptr(true),
	// 			PrivateDNSZone: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.Network/privateDnsZones/privatelink.location1.azmk8s.io"),
	// 		},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		FqdnSubdomain: to.Ptr("domain1"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			IPFamilies: []*armcontainerservice.IPFamily{
	// 				to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 					AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 					EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 						},
	// 						{
	// 							ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 					}},
	// 					IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 						Count: to.Ptr[int32](2),
	// 					},
	// 				},
	// 				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 				NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 				OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 				PodCidr: to.Ptr("10.244.0.0/16"),
	// 				PodCidrs: []*string{
	// 					to.Ptr("10.244.0.0/16")},
	// 					ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 					ServiceCidrs: []*string{
	// 						to.Ptr("10.0.0.0/16")},
	// 					},
	// 					NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 					PrivateFQDN: to.Ptr("domain1.privatelink.location1.azmk8s.io"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 						ClientID: to.Ptr("clientid"),
	// 					},
	// 					WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 						AdminUsername: to.Ptr("azureuser"),
	// 					},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_UpdateWithEnableAzureRBAC.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createUpdateAadManagedClusterWithEnableAzureRbac() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AADProfile: &armcontainerservice.ManagedClusterAADProfile{
				EnableAzureRBAC: to.Ptr(true),
				Managed:         to.Ptr(true),
			},
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					AvailabilityZones: []*string{
						to.Ptr("1"),
						to.Ptr("2"),
						to.Ptr("3")},
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS1_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AADProfile: &armcontainerservice.ManagedClusterAADProfile{
	// 			EnableAzureRBAC: to.Ptr(true),
	// 			Managed: to.Ptr(true),
	// 			TenantID: to.Ptr("tenantID"),
	// 		},
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				AvailabilityZones: []*string{
	// 					to.Ptr("1"),
	// 					to.Ptr("2"),
	// 					to.Ptr("3")},
	// 					Count: to.Ptr[int32](3),
	// 					CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 					EnableNodePublicIP: to.Ptr(true),
	// 					MaxPods: to.Ptr[int32](110),
	// 					Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 					NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 					OrchestratorVersion: to.Ptr("1.9.6"),
	// 					OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					VMSize: to.Ptr("Standard_DS1_v2"),
	// 					Name: to.Ptr("nodepool1"),
	// 			}},
	// 			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 				ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 				ScanInterval: to.Ptr("20s"),
	// 			},
	// 			DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 			DNSPrefix: to.Ptr("dnsprefix1"),
	// 			EnablePodSecurityPolicy: to.Ptr(true),
	// 			EnableRBAC: to.Ptr(true),
	// 			Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 			KubernetesVersion: to.Ptr("1.9.6"),
	// 			LinuxProfile: &armcontainerservice.LinuxProfile{
	// 				AdminUsername: to.Ptr("azureuser"),
	// 				SSH: &armcontainerservice.SSHConfiguration{
	// 					PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 						{
	// 							KeyData: to.Ptr("keydata"),
	// 					}},
	// 				},
	// 			},
	// 			MaxAgentPools: to.Ptr[int32](1),
	// 			NetworkProfile: &armcontainerservice.NetworkProfile{
	// 				DNSServiceIP: to.Ptr("10.0.0.10"),
	// 				IPFamilies: []*armcontainerservice.IPFamily{
	// 					to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 					LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 						AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 						EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 						}},
	// 						IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 						ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 							Count: to.Ptr[int32](2),
	// 						},
	// 					},
	// 					LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 					NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 					OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 					PodCidr: to.Ptr("10.244.0.0/16"),
	// 					PodCidrs: []*string{
	// 						to.Ptr("10.244.0.0/16")},
	// 						ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 						ServiceCidrs: []*string{
	// 							to.Ptr("10.0.0.0/16")},
	// 						},
	// 						NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 						ProvisioningState: to.Ptr("Succeeded"),
	// 						ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 							ClientID: to.Ptr("clientid"),
	// 						},
	// 						WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 							AdminUsername: to.Ptr("azureuser"),
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_Update.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createUpdateManagedCluster() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Identity: &armcontainerservice.ManagedClusterIdentity{
			Type: to.Ptr(armcontainerservice.ResourceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armcontainerservice.ManagedServiceIdentityUserAssignedIdentitiesValue{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgName1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1": {},
			},
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					AvailabilityZones: []*string{
						to.Ptr("1"),
						to.Ptr("2"),
						to.Ptr("3")},
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					ScaleDownMode:      to.Ptr(armcontainerservice.ScaleDownModeDeallocate),
					VMSize:             to.Ptr("Standard_DS1_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				BalanceSimilarNodeGroups: to.Ptr("true"),
				Expander:                 to.Ptr(armcontainerservice.ExpanderPriority),
				MaxNodeProvisionTime:     to.Ptr("15m"),
				NewPodScaleUpDelay:       to.Ptr("1m"),
				ScaleDownDelayAfterAdd:   to.Ptr("15m"),
				ScanInterval:             to.Ptr("20s"),
				SkipNodesWithSystemPods:  to.Ptr("false"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			UpgradeSettings: &armcontainerservice.ClusterUpgradeSettings{
				OverrideSettings: &armcontainerservice.UpgradeOverrideSettings{
					ForceUpgrade: to.Ptr(true),
					Until:        to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-01T13:00:00.000Z"); return t }()),
				},
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Identity: &armcontainerservice.ManagedClusterIdentity{
	// 		Type: to.Ptr(armcontainerservice.ResourceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armcontainerservice.ManagedServiceIdentityUserAssignedIdentitiesValue{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgName1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1": &armcontainerservice.ManagedServiceIdentityUserAssignedIdentitiesValue{
	// 				ClientID: to.Ptr("clientId1"),
	// 				PrincipalID: to.Ptr("principalId1"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				AvailabilityZones: []*string{
	// 					to.Ptr("1"),
	// 					to.Ptr("2"),
	// 					to.Ptr("3")},
	// 					Count: to.Ptr[int32](3),
	// 					CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 					EnableNodePublicIP: to.Ptr(true),
	// 					MaxPods: to.Ptr[int32](110),
	// 					Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 					NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 					OrchestratorVersion: to.Ptr("1.9.6"),
	// 					OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ScaleDownMode: to.Ptr(armcontainerservice.ScaleDownModeDeallocate),
	// 					VMSize: to.Ptr("Standard_DS1_v2"),
	// 					Name: to.Ptr("nodepool1"),
	// 			}},
	// 			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 				BalanceSimilarNodeGroups: to.Ptr("true"),
	// 				Expander: to.Ptr(armcontainerservice.ExpanderPriority),
	// 				MaxNodeProvisionTime: to.Ptr("15m"),
	// 				NewPodScaleUpDelay: to.Ptr("1m"),
	// 				ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 				ScanInterval: to.Ptr("20s"),
	// 				SkipNodesWithSystemPods: to.Ptr("false"),
	// 			},
	// 			DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 			DNSPrefix: to.Ptr("dnsprefix1"),
	// 			EnablePodSecurityPolicy: to.Ptr(true),
	// 			EnableRBAC: to.Ptr(true),
	// 			Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 			KubernetesVersion: to.Ptr("1.9.6"),
	// 			LinuxProfile: &armcontainerservice.LinuxProfile{
	// 				AdminUsername: to.Ptr("azureuser"),
	// 				SSH: &armcontainerservice.SSHConfiguration{
	// 					PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 						{
	// 							KeyData: to.Ptr("keydata"),
	// 					}},
	// 				},
	// 			},
	// 			MaxAgentPools: to.Ptr[int32](1),
	// 			NetworkProfile: &armcontainerservice.NetworkProfile{
	// 				DNSServiceIP: to.Ptr("10.0.0.10"),
	// 				IPFamilies: []*armcontainerservice.IPFamily{
	// 					to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 					LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 						AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 						EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 						}},
	// 						IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 						ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 							Count: to.Ptr[int32](2),
	// 						},
	// 					},
	// 					LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 					NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 					OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 					PodCidr: to.Ptr("10.244.0.0/16"),
	// 					PodCidrs: []*string{
	// 						to.Ptr("10.244.0.0/16")},
	// 						ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 						ServiceCidrs: []*string{
	// 							to.Ptr("10.0.0.0/16")},
	// 						},
	// 						NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 						ProvisioningState: to.Ptr("Succeeded"),
	// 						ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 							ClientID: to.Ptr("clientid"),
	// 						},
	// 						UpgradeSettings: &armcontainerservice.ClusterUpgradeSettings{
	// 							OverrideSettings: &armcontainerservice.UpgradeOverrideSettings{
	// 								ForceUpgrade: to.Ptr(false),
	// 								Until: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-11-01T13:00:00.000Z"); return t}()),
	// 							},
	// 						},
	// 						WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 							AdminUsername: to.Ptr("azureuser"),
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_AzureServiceMesh.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createUpdateManagedClusterWithAzureServiceMesh() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{
				"azureKeyvaultSecretsProvider": {
					Config: map[string]*string{
						"enableSecretRotation": to.Ptr("true"),
						"rotationPollInterval": to.Ptr("2m"),
					},
					Enabled: to.Ptr(true),
				},
			},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type:               to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS2_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServiceMeshProfile: &armcontainerservice.ServiceMeshProfile{
				Istio: &armcontainerservice.IstioServiceMesh{
					CertificateAuthority: &armcontainerservice.IstioCertificateAuthority{
						Plugin: &armcontainerservice.IstioPluginCertificateAuthority{
							CertChainObjectName: to.Ptr("cert-chain"),
							CertObjectName:      to.Ptr("ca-cert"),
							KeyObjectName:       to.Ptr("ca-key"),
							KeyVaultID:          to.Ptr("/subscriptions/854c9ddb-fe9e-4aea-8d58-99ed88282881/resourceGroups/ddama-test/providers/Microsoft.KeyVault/vaults/my-akv"),
							RootCertObjectName:  to.Ptr("root-cert"),
						},
					},
					Components: &armcontainerservice.IstioComponents{
						EgressGateways: []*armcontainerservice.IstioEgressGateway{
							{
								Enabled: to.Ptr(true),
								NodeSelector: map[string]*string{
									"istio": to.Ptr("egress"),
								},
							}},
						IngressGateways: []*armcontainerservice.IstioIngressGateway{
							{
								Enabled: to.Ptr(true),
								Mode:    to.Ptr(armcontainerservice.IstioIngressGatewayModeInternal),
							}},
					},
				},
				Mode: to.Ptr(armcontainerservice.ServiceMeshModeIstio),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{
	// 			"azureKeyvaultSecretsProvider": &armcontainerservice.ManagedClusterAddonProfile{
	// 				Config: map[string]*string{
	// 					"enableSecretRotation": to.Ptr("true"),
	// 					"rotationPollInterval": to.Ptr("2m"),
	// 				},
	// 				Enabled: to.Ptr(true),
	// 			},
	// 		},
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				Count: to.Ptr[int32](3),
	// 				EnableEncryptionAtHost: to.Ptr(true),
	// 				EnableNodePublicIP: to.Ptr(true),
	// 				MaxPods: to.Ptr[int32](110),
	// 				Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 				NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS2_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 			ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 			ScanInterval: to.Ptr("20s"),
	// 		},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnablePodSecurityPolicy: to.Ptr(true),
	// 		EnableRBAC: to.Ptr(true),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		MaxAgentPools: to.Ptr[int32](1),
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 				AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 				EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 					{
	// 						ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 					},
	// 					{
	// 						ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 				}},
	// 				IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 				ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 					Count: to.Ptr[int32](2),
	// 				},
	// 			},
	// 			LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 			NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 			OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 			PodCidr: to.Ptr("10.244.0.0/16"),
	// 			ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 		},
	// 		NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ServiceMeshProfile: &armcontainerservice.ServiceMeshProfile{
	// 			Istio: &armcontainerservice.IstioServiceMesh{
	// 				CertificateAuthority: &armcontainerservice.IstioCertificateAuthority{
	// 					Plugin: &armcontainerservice.IstioPluginCertificateAuthority{
	// 						CertChainObjectName: to.Ptr("cert-chain"),
	// 						CertObjectName: to.Ptr("ca-cert"),
	// 						KeyObjectName: to.Ptr("ca-key"),
	// 						KeyVaultID: to.Ptr("/subscriptions/854c9ddb-fe9e-4aea-8d58-99ed88282881/resourceGroups/ddama-test/providers/Microsoft.KeyVault/vaults/my-akv"),
	// 						RootCertObjectName: to.Ptr("root-cert"),
	// 					},
	// 				},
	// 				Components: &armcontainerservice.IstioComponents{
	// 					EgressGateways: []*armcontainerservice.IstioEgressGateway{
	// 						{
	// 							Enabled: to.Ptr(true),
	// 							NodeSelector: map[string]*string{
	// 								"istio": to.Ptr("egress"),
	// 							},
	// 					}},
	// 					IngressGateways: []*armcontainerservice.IstioIngressGateway{
	// 						{
	// 							Enabled: to.Ptr(true),
	// 							Mode: to.Ptr(armcontainerservice.IstioIngressGatewayModeInternal),
	// 					}},
	// 				},
	// 				Revisions: []*string{
	// 					to.Ptr("asm-1-17")},
	// 				},
	// 				Mode: to.Ptr(armcontainerservice.ServiceMeshModeIstio),
	// 			},
	// 			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 				ClientID: to.Ptr("clientid"),
	// 			},
	// 			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 				AdminUsername: to.Ptr("azureuser"),
	// 			},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_UpdateWithAHUB.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createUpdateManagedClusterWithEnableAhub() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Identity: &armcontainerservice.ManagedClusterIdentity{
			Type: to.Ptr(armcontainerservice.ResourceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armcontainerservice.ManagedServiceIdentityUserAssignedIdentitiesValue{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgName1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1": {},
			},
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					AvailabilityZones: []*string{
						to.Ptr("1"),
						to.Ptr("2"),
						to.Ptr("3")},
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS1_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
				LicenseType:   to.Ptr(armcontainerservice.LicenseTypeWindowsServer),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Identity: &armcontainerservice.ManagedClusterIdentity{
	// 		Type: to.Ptr(armcontainerservice.ResourceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armcontainerservice.ManagedServiceIdentityUserAssignedIdentitiesValue{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgName1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1": &armcontainerservice.ManagedServiceIdentityUserAssignedIdentitiesValue{
	// 				ClientID: to.Ptr("clientId1"),
	// 				PrincipalID: to.Ptr("principalId1"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				AvailabilityZones: []*string{
	// 					to.Ptr("1"),
	// 					to.Ptr("2"),
	// 					to.Ptr("3")},
	// 					Count: to.Ptr[int32](3),
	// 					CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 					EnableNodePublicIP: to.Ptr(true),
	// 					MaxPods: to.Ptr[int32](110),
	// 					Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 					NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 					OrchestratorVersion: to.Ptr("1.9.6"),
	// 					OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					VMSize: to.Ptr("Standard_DS1_v2"),
	// 					Name: to.Ptr("nodepool1"),
	// 			}},
	// 			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 				ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 				ScanInterval: to.Ptr("20s"),
	// 			},
	// 			DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 			DNSPrefix: to.Ptr("dnsprefix1"),
	// 			EnablePodSecurityPolicy: to.Ptr(true),
	// 			EnableRBAC: to.Ptr(true),
	// 			Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 			KubernetesVersion: to.Ptr("1.9.6"),
	// 			LinuxProfile: &armcontainerservice.LinuxProfile{
	// 				AdminUsername: to.Ptr("azureuser"),
	// 				SSH: &armcontainerservice.SSHConfiguration{
	// 					PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 						{
	// 							KeyData: to.Ptr("keydata"),
	// 					}},
	// 				},
	// 			},
	// 			MaxAgentPools: to.Ptr[int32](1),
	// 			NetworkProfile: &armcontainerservice.NetworkProfile{
	// 				DNSServiceIP: to.Ptr("10.0.0.10"),
	// 				IPFamilies: []*armcontainerservice.IPFamily{
	// 					to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 					LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 						AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 						EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 						}},
	// 						IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 						ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 							Count: to.Ptr[int32](2),
	// 						},
	// 					},
	// 					LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 					NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 					OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 					PodCidr: to.Ptr("10.244.0.0/16"),
	// 					PodCidrs: []*string{
	// 						to.Ptr("10.244.0.0/16")},
	// 						ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 						ServiceCidrs: []*string{
	// 							to.Ptr("10.0.0.0/16")},
	// 						},
	// 						NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 						ProvisioningState: to.Ptr("Succeeded"),
	// 						ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 							ClientID: to.Ptr("clientid"),
	// 						},
	// 						WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 							AdminUsername: to.Ptr("azureuser"),
	// 							LicenseType: to.Ptr(armcontainerservice.LicenseTypeWindowsServer),
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_UpdateWithEnableNamespaceResources.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createUpdateManagedClusterWithEnableNamespaceResources() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					AvailabilityZones: []*string{
						to.Ptr("1"),
						to.Ptr("2"),
						to.Ptr("3")},
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS1_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:      to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:                to.Ptr("dnsprefix1"),
			EnableNamespaceResources: to.Ptr(true),
			EnablePodSecurityPolicy:  to.Ptr(true),
			EnableRBAC:               to.Ptr(true),
			KubernetesVersion:        to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				AvailabilityZones: []*string{
	// 					to.Ptr("1"),
	// 					to.Ptr("2"),
	// 					to.Ptr("3")},
	// 					Count: to.Ptr[int32](3),
	// 					CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 					EnableNodePublicIP: to.Ptr(true),
	// 					MaxPods: to.Ptr[int32](110),
	// 					Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 					NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 					OrchestratorVersion: to.Ptr("1.9.6"),
	// 					OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					VMSize: to.Ptr("Standard_DS1_v2"),
	// 					Name: to.Ptr("nodepool1"),
	// 			}},
	// 			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 				ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 				ScanInterval: to.Ptr("20s"),
	// 			},
	// 			DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 			DNSPrefix: to.Ptr("dnsprefix1"),
	// 			EnableNamespaceResources: to.Ptr(true),
	// 			EnablePodSecurityPolicy: to.Ptr(true),
	// 			EnableRBAC: to.Ptr(true),
	// 			Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 			KubernetesVersion: to.Ptr("1.9.6"),
	// 			LinuxProfile: &armcontainerservice.LinuxProfile{
	// 				AdminUsername: to.Ptr("azureuser"),
	// 				SSH: &armcontainerservice.SSHConfiguration{
	// 					PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 						{
	// 							KeyData: to.Ptr("keydata"),
	// 					}},
	// 				},
	// 			},
	// 			MaxAgentPools: to.Ptr[int32](1),
	// 			NetworkProfile: &armcontainerservice.NetworkProfile{
	// 				DNSServiceIP: to.Ptr("10.0.0.10"),
	// 				IPFamilies: []*armcontainerservice.IPFamily{
	// 					to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 					LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 						AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 						EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 						}},
	// 						IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 						ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 							Count: to.Ptr[int32](2),
	// 						},
	// 					},
	// 					LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 					NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 					OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 					PodCidr: to.Ptr("10.244.0.0/16"),
	// 					PodCidrs: []*string{
	// 						to.Ptr("10.244.0.0/16")},
	// 						ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 						ServiceCidrs: []*string{
	// 							to.Ptr("10.0.0.0/16")},
	// 						},
	// 						NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 						ProvisioningState: to.Ptr("Succeeded"),
	// 						ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 							ClientID: to.Ptr("clientid"),
	// 						},
	// 						WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 							AdminUsername: to.Ptr("azureuser"),
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_UpdateWindowsGmsa.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createUpdateManagedClusterWithWindowsGMsaEnabled() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Identity: &armcontainerservice.ManagedClusterIdentity{
			Type: to.Ptr(armcontainerservice.ResourceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armcontainerservice.ManagedServiceIdentityUserAssignedIdentitiesValue{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgName1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1": {},
			},
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					AvailabilityZones: []*string{
						to.Ptr("1"),
						to.Ptr("2"),
						to.Ptr("3")},
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					VMSize:             to.Ptr("Standard_DS1_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				ScaleDownDelayAfterAdd: to.Ptr("15m"),
				ScanInterval:           to.Ptr("20s"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
				GmsaProfile: &armcontainerservice.WindowsGmsaProfile{
					Enabled: to.Ptr(true),
				},
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Identity: &armcontainerservice.ManagedClusterIdentity{
	// 		Type: to.Ptr(armcontainerservice.ResourceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armcontainerservice.ManagedServiceIdentityUserAssignedIdentitiesValue{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgName1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1": &armcontainerservice.ManagedServiceIdentityUserAssignedIdentitiesValue{
	// 				ClientID: to.Ptr("clientId1"),
	// 				PrincipalID: to.Ptr("principalId1"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				AvailabilityZones: []*string{
	// 					to.Ptr("1"),
	// 					to.Ptr("2"),
	// 					to.Ptr("3")},
	// 					Count: to.Ptr[int32](3),
	// 					CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 					EnableNodePublicIP: to.Ptr(true),
	// 					MaxPods: to.Ptr[int32](110),
	// 					Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 					NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 					OrchestratorVersion: to.Ptr("1.9.6"),
	// 					OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					VMSize: to.Ptr("Standard_DS1_v2"),
	// 					Name: to.Ptr("nodepool1"),
	// 			}},
	// 			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 				ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 				ScanInterval: to.Ptr("20s"),
	// 			},
	// 			DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 			DNSPrefix: to.Ptr("dnsprefix1"),
	// 			EnablePodSecurityPolicy: to.Ptr(true),
	// 			EnableRBAC: to.Ptr(true),
	// 			Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 			KubernetesVersion: to.Ptr("1.9.6"),
	// 			LinuxProfile: &armcontainerservice.LinuxProfile{
	// 				AdminUsername: to.Ptr("azureuser"),
	// 				SSH: &armcontainerservice.SSHConfiguration{
	// 					PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 						{
	// 							KeyData: to.Ptr("keydata"),
	// 					}},
	// 				},
	// 			},
	// 			MaxAgentPools: to.Ptr[int32](1),
	// 			NetworkProfile: &armcontainerservice.NetworkProfile{
	// 				DNSServiceIP: to.Ptr("10.0.0.10"),
	// 				IPFamilies: []*armcontainerservice.IPFamily{
	// 					to.Ptr(armcontainerservice.IPFamilyIPv4)},
	// 					LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 						AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 						EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 						}},
	// 						IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 						ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 							Count: to.Ptr[int32](2),
	// 						},
	// 					},
	// 					LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 					NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 					OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 					PodCidr: to.Ptr("10.244.0.0/16"),
	// 					PodCidrs: []*string{
	// 						to.Ptr("10.244.0.0/16")},
	// 						ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 						ServiceCidrs: []*string{
	// 							to.Ptr("10.0.0.0/16")},
	// 						},
	// 						NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 						ProvisioningState: to.Ptr("Succeeded"),
	// 						ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 							ClientID: to.Ptr("clientid"),
	// 						},
	// 						WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 							AdminUsername: to.Ptr("azureuser"),
	// 							GmsaProfile: &armcontainerservice.WindowsGmsaProfile{
	// 								Enabled: to.Ptr(true),
	// 							},
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersCreate_DualStackNetworking.json
func ExampleManagedClustersClient_BeginCreateOrUpdate_createUpdateManagedClusterWithDualStackNetworking() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginCreateOrUpdate(ctx, "rg1", "clustername1", armcontainerservice.ManagedCluster{
		Location: to.Ptr("location1"),
		Tags: map[string]*string{
			"archv2": to.Ptr(""),
			"tier":   to.Ptr("production"),
		},
		Identity: &armcontainerservice.ManagedClusterIdentity{
			Type: to.Ptr(armcontainerservice.ResourceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armcontainerservice.ManagedServiceIdentityUserAssignedIdentitiesValue{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgName1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1": {},
			},
		},
		Properties: &armcontainerservice.ManagedClusterProperties{
			AddonProfiles: map[string]*armcontainerservice.ManagedClusterAddonProfile{},
			AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
				{
					Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
					AvailabilityZones: []*string{
						to.Ptr("1"),
						to.Ptr("2"),
						to.Ptr("3")},
					Count:              to.Ptr[int32](3),
					EnableNodePublicIP: to.Ptr(true),
					Mode:               to.Ptr(armcontainerservice.AgentPoolModeSystem),
					OSType:             to.Ptr(armcontainerservice.OSTypeLinux),
					ScaleDownMode:      to.Ptr(armcontainerservice.ScaleDownModeDeallocate),
					VMSize:             to.Ptr("Standard_DS1_v2"),
					Name:               to.Ptr("nodepool1"),
				}},
			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
				BalanceSimilarNodeGroups: to.Ptr("true"),
				Expander:                 to.Ptr(armcontainerservice.ExpanderPriority),
				MaxNodeProvisionTime:     to.Ptr("15m"),
				NewPodScaleUpDelay:       to.Ptr("1m"),
				ScaleDownDelayAfterAdd:   to.Ptr("15m"),
				ScanInterval:             to.Ptr("20s"),
				SkipNodesWithSystemPods:  to.Ptr("false"),
			},
			DiskEncryptionSetID:     to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
			DNSPrefix:               to.Ptr("dnsprefix1"),
			EnablePodSecurityPolicy: to.Ptr(true),
			EnableRBAC:              to.Ptr(true),
			KubernetesVersion:       to.Ptr(""),
			LinuxProfile: &armcontainerservice.LinuxProfile{
				AdminUsername: to.Ptr("azureuser"),
				SSH: &armcontainerservice.SSHConfiguration{
					PublicKeys: []*armcontainerservice.SSHPublicKey{
						{
							KeyData: to.Ptr("keydata"),
						}},
				},
			},
			NetworkProfile: &armcontainerservice.NetworkProfile{
				IPFamilies: []*armcontainerservice.IPFamily{
					to.Ptr(armcontainerservice.IPFamilyIPv4),
					to.Ptr(armcontainerservice.IPFamilyIPv6)},
				LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
					ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
						Count: to.Ptr[int32](2),
					},
				},
				LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUStandard),
				OutboundType:    to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
			},
			ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
				ClientID: to.Ptr("clientid"),
				Secret:   to.Ptr("secret"),
			},
			WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
				AdminPassword: to.Ptr("replacePassword1234$"),
				AdminUsername: to.Ptr("azureuser"),
			},
		},
		SKU: &armcontainerservice.ManagedClusterSKU{
			Name: to.Ptr(armcontainerservice.ManagedClusterSKUName("Basic")),
			Tier: to.Ptr(armcontainerservice.ManagedClusterSKUTierFree),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv2": to.Ptr(""),
	// 		"tier": to.Ptr("production"),
	// 	},
	// 	Identity: &armcontainerservice.ManagedClusterIdentity{
	// 		Type: to.Ptr(armcontainerservice.ResourceIdentityTypeUserAssigned),
	// 		UserAssignedIdentities: map[string]*armcontainerservice.ManagedServiceIdentityUserAssignedIdentitiesValue{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rgName1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1": &armcontainerservice.ManagedServiceIdentityUserAssignedIdentitiesValue{
	// 				ClientID: to.Ptr("clientId1"),
	// 				PrincipalID: to.Ptr("principalId1"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Type: to.Ptr(armcontainerservice.AgentPoolTypeVirtualMachineScaleSets),
	// 				AvailabilityZones: []*string{
	// 					to.Ptr("1"),
	// 					to.Ptr("2"),
	// 					to.Ptr("3")},
	// 					Count: to.Ptr[int32](3),
	// 					CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 					EnableNodePublicIP: to.Ptr(true),
	// 					MaxPods: to.Ptr[int32](110),
	// 					Mode: to.Ptr(armcontainerservice.AgentPoolModeSystem),
	// 					NodeImageVersion: to.Ptr("AKSUbuntu:1604:2020.03.11"),
	// 					OrchestratorVersion: to.Ptr("1.9.6"),
	// 					OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 					ScaleDownMode: to.Ptr(armcontainerservice.ScaleDownModeDeallocate),
	// 					VMSize: to.Ptr("Standard_DS1_v2"),
	// 					Name: to.Ptr("nodepool1"),
	// 			}},
	// 			AutoScalerProfile: &armcontainerservice.ManagedClusterPropertiesAutoScalerProfile{
	// 				BalanceSimilarNodeGroups: to.Ptr("true"),
	// 				Expander: to.Ptr(armcontainerservice.ExpanderPriority),
	// 				MaxNodeProvisionTime: to.Ptr("15m"),
	// 				NewPodScaleUpDelay: to.Ptr("1m"),
	// 				ScaleDownDelayAfterAdd: to.Ptr("15m"),
	// 				ScanInterval: to.Ptr("20s"),
	// 				SkipNodesWithSystemPods: to.Ptr("false"),
	// 			},
	// 			DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 			DNSPrefix: to.Ptr("dnsprefix1"),
	// 			EnablePodSecurityPolicy: to.Ptr(true),
	// 			EnableRBAC: to.Ptr(true),
	// 			Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 			KubernetesVersion: to.Ptr("1.9.6"),
	// 			LinuxProfile: &armcontainerservice.LinuxProfile{
	// 				AdminUsername: to.Ptr("azureuser"),
	// 				SSH: &armcontainerservice.SSHConfiguration{
	// 					PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 						{
	// 							KeyData: to.Ptr("keydata"),
	// 					}},
	// 				},
	// 			},
	// 			MaxAgentPools: to.Ptr[int32](1),
	// 			NetworkProfile: &armcontainerservice.NetworkProfile{
	// 				DNSServiceIP: to.Ptr("10.0.0.10"),
	// 				IPFamilies: []*armcontainerservice.IPFamily{
	// 					to.Ptr(armcontainerservice.IPFamilyIPv4),
	// 					to.Ptr(armcontainerservice.IPFamilyIPv6)},
	// 					LoadBalancerProfile: &armcontainerservice.ManagedClusterLoadBalancerProfile{
	// 						AllocatedOutboundPorts: to.Ptr[int32](2000),
	// 						EffectiveOutboundIPs: []*armcontainerservice.ResourceReference{
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip1"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip2"),
	// 							},
	// 							{
	// 								ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/MC_rg1/providers/Microsoft.Network/publicIPAddresses/mgdoutboundip3-ipv6"),
	// 						}},
	// 						IdleTimeoutInMinutes: to.Ptr[int32](10),
	// 						ManagedOutboundIPs: &armcontainerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPs{
	// 							Count: to.Ptr[int32](2),
	// 							CountIPv6: to.Ptr[int32](1),
	// 						},
	// 					},
	// 					LoadBalancerSKU: to.Ptr(armcontainerservice.LoadBalancerSKUBasic),
	// 					NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 					OutboundType: to.Ptr(armcontainerservice.OutboundTypeLoadBalancer),
	// 					PodCidr: to.Ptr("10.244.0.0/16"),
	// 					PodCidrs: []*string{
	// 						to.Ptr("10.244.0.0/16"),
	// 						to.Ptr("fd11:1234::/64")},
	// 						ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 						ServiceCidrs: []*string{
	// 							to.Ptr("10.0.0.0/16"),
	// 							to.Ptr("fd00:1234::/108")},
	// 						},
	// 						NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 						ProvisioningState: to.Ptr("Succeeded"),
	// 						ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 							ClientID: to.Ptr("clientid"),
	// 						},
	// 						WindowsProfile: &armcontainerservice.ManagedClusterWindowsProfile{
	// 							AdminUsername: to.Ptr("azureuser"),
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersUpdateTags.json
func ExampleManagedClustersClient_BeginUpdateTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginUpdateTags(ctx, "rg1", "clustername1", armcontainerservice.TagsObject{
		Tags: map[string]*string{
			"archv3": to.Ptr(""),
			"tier":   to.Ptr("testing"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ManagedCluster = armcontainerservice.ManagedCluster{
	// 	Name: to.Ptr("clustername1"),
	// 	Type: to.Ptr("Microsoft.ContainerService/ManagedClusters"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1"),
	// 	Location: to.Ptr("location1"),
	// 	Tags: map[string]*string{
	// 		"archv3": to.Ptr(""),
	// 		"tier": to.Ptr("testing"),
	// 	},
	// 	Properties: &armcontainerservice.ManagedClusterProperties{
	// 		AgentPoolProfiles: []*armcontainerservice.ManagedClusterAgentPoolProfile{
	// 			{
	// 				Count: to.Ptr[int32](3),
	// 				CurrentOrchestratorVersion: to.Ptr("1.9.6"),
	// 				MaxPods: to.Ptr[int32](110),
	// 				OrchestratorVersion: to.Ptr("1.9.6"),
	// 				OSType: to.Ptr(armcontainerservice.OSTypeLinux),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 				VMSize: to.Ptr("Standard_DS1_v2"),
	// 				Name: to.Ptr("nodepool1"),
	// 		}},
	// 		DiskEncryptionSetID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
	// 		DNSPrefix: to.Ptr("dnsprefix1"),
	// 		EnableRBAC: to.Ptr(false),
	// 		Fqdn: to.Ptr("dnsprefix1-abcd1234.hcp.eastus.azmk8s.io"),
	// 		KubernetesVersion: to.Ptr("1.9.6"),
	// 		LinuxProfile: &armcontainerservice.LinuxProfile{
	// 			AdminUsername: to.Ptr("azureuser"),
	// 			SSH: &armcontainerservice.SSHConfiguration{
	// 				PublicKeys: []*armcontainerservice.SSHPublicKey{
	// 					{
	// 						KeyData: to.Ptr("keydata"),
	// 				}},
	// 			},
	// 		},
	// 		NetworkProfile: &armcontainerservice.NetworkProfile{
	// 			DNSServiceIP: to.Ptr("10.0.0.10"),
	// 			NetworkPlugin: to.Ptr(armcontainerservice.NetworkPluginKubenet),
	// 			PodCidr: to.Ptr("10.244.0.0/16"),
	// 			ServiceCidr: to.Ptr("10.0.0.0/16"),
	// 		},
	// 		NodeResourceGroup: to.Ptr("MC_rg1_clustername1_location1"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ServicePrincipalProfile: &armcontainerservice.ManagedClusterServicePrincipalProfile{
	// 			ClientID: to.Ptr("clientid"),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersDelete.json
func ExampleManagedClustersClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginDelete(ctx, "rg1", "clustername1", &armcontainerservice.ManagedClustersClientBeginDeleteOptions{IgnorePodDisruptionBudget: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersResetServicePrincipalProfile.json
func ExampleManagedClustersClient_BeginResetServicePrincipalProfile() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginResetServicePrincipalProfile(ctx, "rg1", "clustername1", armcontainerservice.ManagedClusterServicePrincipalProfile{
		ClientID: to.Ptr("clientid"),
		Secret:   to.Ptr("secret"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersResetAADProfile.json
func ExampleManagedClustersClient_BeginResetAADProfile() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginResetAADProfile(ctx, "rg1", "clustername1", armcontainerservice.ManagedClusterAADProfile{
		ClientAppID:     to.Ptr("clientappid"),
		ServerAppID:     to.Ptr("serverappid"),
		ServerAppSecret: to.Ptr("serverappsecret"),
		TenantID:        to.Ptr("tenantid"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersAbortOperation.json
func ExampleManagedClustersClient_BeginAbortLatestOperation() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginAbortLatestOperation(ctx, "rg1", "clustername1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersRotateClusterCertificates.json
func ExampleManagedClustersClient_BeginRotateClusterCertificates() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginRotateClusterCertificates(ctx, "rg1", "clustername1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersRotateServiceAccountSigningKeys.json
func ExampleManagedClustersClient_BeginRotateServiceAccountSigningKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginRotateServiceAccountSigningKeys(ctx, "rg1", "clustername1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersStop.json
func ExampleManagedClustersClient_BeginStop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginStop(ctx, "rg1", "clustername1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersStart.json
func ExampleManagedClustersClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginStart(ctx, "rg1", "clustername1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/RunCommandRequest.json
func ExampleManagedClustersClient_BeginRunCommand() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewManagedClustersClient().BeginRunCommand(ctx, "rg1", "clustername1", armcontainerservice.RunCommandRequest{
		ClusterToken: to.Ptr(""),
		Command:      to.Ptr("kubectl apply -f ns.yaml"),
		Context:      to.Ptr(""),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RunCommandResult = armcontainerservice.RunCommandResult{
	// 	ID: to.Ptr("def7b3ea71bd4f7e9d226ddbc0f00ad9"),
	// 	Properties: &armcontainerservice.CommandResultProperties{
	// 		ExitCode: to.Ptr[int32](0),
	// 		FinishedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-17T00:28:33.000Z"); return t}()),
	// 		Logs: to.Ptr("namespace dummy created"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		StartedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-17T00:28:20.000Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/RunCommandResultFailed.json
func ExampleManagedClustersClient_GetCommandResult_commandFailedResult() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedClustersClient().GetCommandResult(ctx, "rg1", "clustername1", "def7b3ea71bd4f7e9d226ddbc0f00ad9", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RunCommandResult = armcontainerservice.RunCommandResult{
	// 	ID: to.Ptr("def7b3ea71bd4f7e9d226ddbc0f00ad9"),
	// 	Properties: &armcontainerservice.CommandResultProperties{
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		Reason: to.Ptr("ImagePullBackoff"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/RunCommandResultSucceed.json
func ExampleManagedClustersClient_GetCommandResult_commandSucceedResult() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedClustersClient().GetCommandResult(ctx, "rg1", "clustername1", "def7b3ea71bd4f7e9d226ddbc0f00ad9", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RunCommandResult = armcontainerservice.RunCommandResult{
	// 	ID: to.Ptr("def7b3ea71bd4f7e9d226ddbc0f00ad9"),
	// 	Properties: &armcontainerservice.CommandResultProperties{
	// 		ExitCode: to.Ptr[int32](0),
	// 		FinishedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-17T00:28:33.000Z"); return t}()),
	// 		Logs: to.Ptr("namespace dummy created"),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		StartedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-02-17T00:28:20.000Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/OutboundNetworkDependenciesEndpointsList.json
func ExampleManagedClustersClient_NewListOutboundNetworkDependenciesEndpointsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedClustersClient().NewListOutboundNetworkDependenciesEndpointsPager("rg1", "clustername1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OutboundEnvironmentEndpointCollection = armcontainerservice.OutboundEnvironmentEndpointCollection{
		// 	Value: []*armcontainerservice.OutboundEnvironmentEndpoint{
		// 		{
		// 			Category: to.Ptr("azure-resource-management"),
		// 			Endpoints: []*armcontainerservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("management.azure.com"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 							Protocol: to.Ptr("Https"),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("login.microsoftonline.com"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 							Protocol: to.Ptr("Https"),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("images"),
		// 			Endpoints: []*armcontainerservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("mcr.microsoft.com"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 							Protocol: to.Ptr("Https"),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("*.data.mcr.microsoft.com"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Description: to.Ptr("mcr cdn"),
		// 							Port: to.Ptr[int32](443),
		// 							Protocol: to.Ptr("Https"),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("artifacts"),
		// 			Endpoints: []*armcontainerservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("packages.microsoft.com"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 							Protocol: to.Ptr("Https"),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("acs-mirror.azureedge.net"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 							Protocol: to.Ptr("Https"),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("time-sync"),
		// 			Endpoints: []*armcontainerservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("ntp.ubuntu.com"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](123),
		// 							Protocol: to.Ptr("UDP"),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("ubuntu-optional"),
		// 			Endpoints: []*armcontainerservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("security.ubuntu.com"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](80),
		// 							Protocol: to.Ptr("Http"),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("azure.archive.ubuntu.com"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](80),
		// 							Protocol: to.Ptr("Http"),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("changelogs.ubuntu.com"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](80),
		// 							Protocol: to.Ptr("Http"),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("gpu"),
		// 			Endpoints: []*armcontainerservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("nvidia.github.io"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 							Protocol: to.Ptr("Https"),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("us.download.nvidia.com"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 							Protocol: to.Ptr("Https"),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("apt.dockerproject.org"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 							Protocol: to.Ptr("Https"),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("windows"),
		// 			Endpoints: []*armcontainerservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("onegetcdn.azureedge.net"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 							Protocol: to.Ptr("Https"),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("go.microsoft.com"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 							Protocol: to.Ptr("Https"),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("*.mp.microsoft.com"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](80),
		// 							Protocol: to.Ptr("Http"),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("www.msftconnecttest.com"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](80),
		// 							Protocol: to.Ptr("Http"),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("ctldl.windowsupdate.com"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](80),
		// 							Protocol: to.Ptr("Http"),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("apiserver"),
		// 			Endpoints: []*armcontainerservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("*.azmk8s.io"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 							Protocol: to.Ptr("Https"),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("tunnel-classic"),
		// 			Endpoints: []*armcontainerservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("*.azmk8s.io"),
		// 					EndpointDetails: []*armcontainerservice.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](9000),
		// 							Protocol: to.Ptr("TCP"),
		// 					}},
		// 			}},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/GetGuardrailsVersions.json
func ExampleManagedClustersClient_GetGuardrailsVersions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedClustersClient().GetGuardrailsVersions(ctx, "location1", "v1.0.0", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.GuardrailsAvailableVersion = armcontainerservice.GuardrailsAvailableVersion{
	// 	Name: to.Ptr("v1.0.0"),
	// 	Type: to.Ptr("Microsoft.ContainerService/locations/guardrailsVersions"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.ContainerService/locations/location1/guardrailsVersions/v1.0.0"),
	// 	Properties: &armcontainerservice.GuardrailsAvailableVersionsProperties{
	// 		IsDefaultVersion: to.Ptr(true),
	// 		Support: to.Ptr(armcontainerservice.GuardrailsSupportPreview),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ListGuardrailsVersions.json
func ExampleManagedClustersClient_NewListGuardrailsVersionsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedClustersClient().NewListGuardrailsVersionsPager("location1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.GuardrailsAvailableVersionsList = armcontainerservice.GuardrailsAvailableVersionsList{
		// 	Value: []*armcontainerservice.GuardrailsAvailableVersion{
		// 		{
		// 			Name: to.Ptr("v1.0.0"),
		// 			Type: to.Ptr("Microsoft.ContainerService/locations/guardrailsVersions"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.ContainerService/locations/location1/guardrailsVersions/v1.0.0"),
		// 			Properties: &armcontainerservice.GuardrailsAvailableVersionsProperties{
		// 				IsDefaultVersion: to.Ptr(true),
		// 				Support: to.Ptr(armcontainerservice.GuardrailsSupportPreview),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersList_MeshRevisionProfiles.json
func ExampleManagedClustersClient_NewListMeshRevisionProfilesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedClustersClient().NewListMeshRevisionProfilesPager("location1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MeshRevisionProfileList = armcontainerservice.MeshRevisionProfileList{
		// 	Value: []*armcontainerservice.MeshRevisionProfile{
		// 		{
		// 			Name: to.Ptr("istio"),
		// 			Type: to.Ptr("Microsoft.ContainerService/locations/meshRevisionProfiles"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.ContainerService/locations/location1/meshRevisionProfiles/istio"),
		// 			Properties: &armcontainerservice.MeshRevisionProfileProperties{
		// 				MeshRevisions: []*armcontainerservice.MeshRevision{
		// 					{
		// 						CompatibleWith: []*armcontainerservice.CompatibleVersions{
		// 							{
		// 								Name: to.Ptr("kubernetes"),
		// 								Versions: []*string{
		// 									to.Ptr("1.23"),
		// 									to.Ptr("1.24"),
		// 									to.Ptr("1.25"),
		// 									to.Ptr("1.26")},
		// 							}},
		// 							Revision: to.Ptr("asm-1-17"),
		// 							Upgrades: []*string{
		// 								to.Ptr("1-18")},
		// 							},
		// 							{
		// 								CompatibleWith: []*armcontainerservice.CompatibleVersions{
		// 									{
		// 										Name: to.Ptr("kubernetes"),
		// 										Versions: []*string{
		// 											to.Ptr("1.24"),
		// 											to.Ptr("1.25"),
		// 											to.Ptr("1.26"),
		// 											to.Ptr("1.27")},
		// 									}},
		// 									Revision: to.Ptr("asm-1-18"),
		// 									Upgrades: []*string{
		// 									},
		// 							}},
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersGet_MeshRevisionProfile.json
func ExampleManagedClustersClient_GetMeshRevisionProfile() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedClustersClient().GetMeshRevisionProfile(ctx, "location1", "istio", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MeshRevisionProfile = armcontainerservice.MeshRevisionProfile{
	// 	Name: to.Ptr("istio"),
	// 	Type: to.Ptr("Microsoft.ContainerService/locations/meshRevisionProfiles"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.ContainerService/locations/location1/meshRevisionProfiles/istio"),
	// 	Properties: &armcontainerservice.MeshRevisionProfileProperties{
	// 		MeshRevisions: []*armcontainerservice.MeshRevision{
	// 			{
	// 				CompatibleWith: []*armcontainerservice.CompatibleVersions{
	// 					{
	// 						Name: to.Ptr("kubernetes"),
	// 						Versions: []*string{
	// 							to.Ptr("1.23"),
	// 							to.Ptr("1.24"),
	// 							to.Ptr("1.25"),
	// 							to.Ptr("1.26")},
	// 					}},
	// 					Revision: to.Ptr("asm-1-17"),
	// 					Upgrades: []*string{
	// 						to.Ptr("1-18")},
	// 					},
	// 					{
	// 						CompatibleWith: []*armcontainerservice.CompatibleVersions{
	// 							{
	// 								Name: to.Ptr("kubernetes"),
	// 								Versions: []*string{
	// 									to.Ptr("1.24"),
	// 									to.Ptr("1.25"),
	// 									to.Ptr("1.26"),
	// 									to.Ptr("1.27")},
	// 							}},
	// 							Revision: to.Ptr("asm-1-18"),
	// 							Upgrades: []*string{
	// 							},
	// 					}},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersList_MeshUpgradeProfiles.json
func ExampleManagedClustersClient_NewListMeshUpgradeProfilesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewManagedClustersClient().NewListMeshUpgradeProfilesPager("rg1", "clustername1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MeshUpgradeProfileList = armcontainerservice.MeshUpgradeProfileList{
		// 	Value: []*armcontainerservice.MeshUpgradeProfile{
		// 		{
		// 			Name: to.Ptr("istio"),
		// 			Type: to.Ptr("Microsoft.ContainerService/managedClusters/meshUpgradeProfiles"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1/meshUpgradeProfiles/istio"),
		// 			Properties: &armcontainerservice.MeshUpgradeProfileProperties{
		// 				CompatibleWith: []*armcontainerservice.CompatibleVersions{
		// 					{
		// 						Name: to.Ptr("kubernetes"),
		// 						Versions: []*string{
		// 							to.Ptr("1.23"),
		// 							to.Ptr("1.24"),
		// 							to.Ptr("1.25"),
		// 							to.Ptr("1.26")},
		// 					}},
		// 					Revision: to.Ptr("asm-1-17"),
		// 					Upgrades: []*string{
		// 						to.Ptr("1-18")},
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b8c74fd80b415fa1ebb6fa787d454694c39e0fd5/specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2023-10-02-preview/examples/ManagedClustersGet_MeshUpgradeProfile.json
func ExampleManagedClustersClient_GetMeshUpgradeProfile() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedClustersClient().GetMeshUpgradeProfile(ctx, "rg1", "clustername1", "istio", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MeshUpgradeProfile = armcontainerservice.MeshUpgradeProfile{
	// 	Name: to.Ptr("istio"),
	// 	Type: to.Ptr("Microsoft.ContainerService/managedClusters/meshUpgradeProfiles"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/clustername1/meshUpgradeProfiles/istio"),
	// 	Properties: &armcontainerservice.MeshUpgradeProfileProperties{
	// 		CompatibleWith: []*armcontainerservice.CompatibleVersions{
	// 			{
	// 				Name: to.Ptr("kubernetes"),
	// 				Versions: []*string{
	// 					to.Ptr("1.23"),
	// 					to.Ptr("1.24"),
	// 					to.Ptr("1.25"),
	// 					to.Ptr("1.26")},
	// 			}},
	// 			Revision: to.Ptr("asm-1-17"),
	// 			Upgrades: []*string{
	// 				to.Ptr("1-18")},
	// 			},
	// 		}
}
