// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/retail/v2alpha/project.proto

package retailpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The setting to control log generation.
type LoggingConfig_LoggingLevel int32

const (
	// Default value. Defaults to `LOG_FOR_WARNINGS_AND_ABOVE` if unset.
	LoggingConfig_LOGGING_LEVEL_UNSPECIFIED LoggingConfig_LoggingLevel = 0
	// No log will be generated and sent to Cloud Logging.
	LoggingConfig_LOGGING_DISABLED LoggingConfig_LoggingLevel = 1
	// Log for operations resulted in fatal error.
	LoggingConfig_LOG_ERRORS_AND_ABOVE LoggingConfig_LoggingLevel = 2
	// In addition to `LOG_ERRORS_AND_ABOVE`, also log for operations that have
	// soft errors, quality suggestions.
	LoggingConfig_LOG_WARNINGS_AND_ABOVE LoggingConfig_LoggingLevel = 3
	// Log all operations, including successful ones.
	LoggingConfig_LOG_ALL LoggingConfig_LoggingLevel = 4
)

// Enum value maps for LoggingConfig_LoggingLevel.
var (
	LoggingConfig_LoggingLevel_name = map[int32]string{
		0: "LOGGING_LEVEL_UNSPECIFIED",
		1: "LOGGING_DISABLED",
		2: "LOG_ERRORS_AND_ABOVE",
		3: "LOG_WARNINGS_AND_ABOVE",
		4: "LOG_ALL",
	}
	LoggingConfig_LoggingLevel_value = map[string]int32{
		"LOGGING_LEVEL_UNSPECIFIED": 0,
		"LOGGING_DISABLED":          1,
		"LOG_ERRORS_AND_ABOVE":      2,
		"LOG_WARNINGS_AND_ABOVE":    3,
		"LOG_ALL":                   4,
	}
)

func (x LoggingConfig_LoggingLevel) Enum() *LoggingConfig_LoggingLevel {
	p := new(LoggingConfig_LoggingLevel)
	*p = x
	return p
}

func (x LoggingConfig_LoggingLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoggingConfig_LoggingLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2alpha_project_proto_enumTypes[0].Descriptor()
}

func (LoggingConfig_LoggingLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2alpha_project_proto_enumTypes[0]
}

func (x LoggingConfig_LoggingLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoggingConfig_LoggingLevel.Descriptor instead.
func (LoggingConfig_LoggingLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_project_proto_rawDescGZIP(), []int{0, 0}
}

// The enrollment status enum for alert policy.
type AlertConfig_AlertPolicy_EnrollStatus int32

const (
	// Default value. Used for customers who have not responded to the
	// alert policy.
	AlertConfig_AlertPolicy_ENROLL_STATUS_UNSPECIFIED AlertConfig_AlertPolicy_EnrollStatus = 0
	// Customer is enrolled in this policy.
	AlertConfig_AlertPolicy_ENROLLED AlertConfig_AlertPolicy_EnrollStatus = 1
	// Customer declined this policy.
	AlertConfig_AlertPolicy_DECLINED AlertConfig_AlertPolicy_EnrollStatus = 2
)

// Enum value maps for AlertConfig_AlertPolicy_EnrollStatus.
var (
	AlertConfig_AlertPolicy_EnrollStatus_name = map[int32]string{
		0: "ENROLL_STATUS_UNSPECIFIED",
		1: "ENROLLED",
		2: "DECLINED",
	}
	AlertConfig_AlertPolicy_EnrollStatus_value = map[string]int32{
		"ENROLL_STATUS_UNSPECIFIED": 0,
		"ENROLLED":                  1,
		"DECLINED":                  2,
	}
)

func (x AlertConfig_AlertPolicy_EnrollStatus) Enum() *AlertConfig_AlertPolicy_EnrollStatus {
	p := new(AlertConfig_AlertPolicy_EnrollStatus)
	*p = x
	return p
}

func (x AlertConfig_AlertPolicy_EnrollStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AlertConfig_AlertPolicy_EnrollStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2alpha_project_proto_enumTypes[1].Descriptor()
}

func (AlertConfig_AlertPolicy_EnrollStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2alpha_project_proto_enumTypes[1]
}

func (x AlertConfig_AlertPolicy_EnrollStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AlertConfig_AlertPolicy_EnrollStatus.Descriptor instead.
func (AlertConfig_AlertPolicy_EnrollStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_project_proto_rawDescGZIP(), []int{2, 0, 0}
}

// Project level logging config to control what level of log will be generated
// and written to Cloud Logging.
type LoggingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The name of the LoggingConfig singleton resource.
	// Format: projects/*/loggingConfig
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The log generation rule that applies by default to all services
	// supporting log generation. It can be overridden by
	// [ServiceLogGenerationRule][google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule]
	// for service level control.
	DefaultLogGenerationRule *LoggingConfig_LogGenerationRule `protobuf:"bytes,2,opt,name=default_log_generation_rule,json=defaultLogGenerationRule,proto3" json:"default_log_generation_rule,omitempty"`
	// Controls logging configurations more granularly for each supported
	// service.
	//
	// This overrides the
	// [default_log_generation_rule][google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule]
	// for the services specified. For those not mentioned, they will fallback to
	// the default log generation rule.
	ServiceLogGenerationRules []*LoggingConfig_ServiceLogGenerationRule `protobuf:"bytes,4,rep,name=service_log_generation_rules,json=serviceLogGenerationRules,proto3" json:"service_log_generation_rules,omitempty"`
}

func (x *LoggingConfig) Reset() {
	*x = LoggingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2alpha_project_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingConfig) ProtoMessage() {}

func (x *LoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_project_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingConfig.ProtoReflect.Descriptor instead.
func (*LoggingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_project_proto_rawDescGZIP(), []int{0}
}

func (x *LoggingConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LoggingConfig) GetDefaultLogGenerationRule() *LoggingConfig_LogGenerationRule {
	if x != nil {
		return x.DefaultLogGenerationRule
	}
	return nil
}

func (x *LoggingConfig) GetServiceLogGenerationRules() []*LoggingConfig_ServiceLogGenerationRule {
	if x != nil {
		return x.ServiceLogGenerationRules
	}
	return nil
}

// Metadata that describes a Cloud Retail Project.
type Project struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Full resource name of the retail project, such as
	// `projects/{project_id_or_number}/retailProject`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Retail API solutions that the project has enrolled.
	EnrolledSolutions []SolutionType `protobuf:"varint,2,rep,packed,name=enrolled_solutions,json=enrolledSolutions,proto3,enum=google.cloud.retail.v2alpha.SolutionType" json:"enrolled_solutions,omitempty"`
}

func (x *Project) Reset() {
	*x = Project{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2alpha_project_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Project) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Project) ProtoMessage() {}

func (x *Project) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_project_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Project.ProtoReflect.Descriptor instead.
func (*Project) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_project_proto_rawDescGZIP(), []int{1}
}

func (x *Project) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Project) GetEnrolledSolutions() []SolutionType {
	if x != nil {
		return x.EnrolledSolutions
	}
	return nil
}

// Project level alert config.
type AlertConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The name of the AlertConfig singleton resource.
	// Format: projects/*/alertConfig
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Alert policies for a customer.
	// They must be unique by [AlertPolicy.alert_group]
	AlertPolicies []*AlertConfig_AlertPolicy `protobuf:"bytes,2,rep,name=alert_policies,json=alertPolicies,proto3" json:"alert_policies,omitempty"`
}

func (x *AlertConfig) Reset() {
	*x = AlertConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2alpha_project_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlertConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlertConfig) ProtoMessage() {}

func (x *AlertConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_project_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlertConfig.ProtoReflect.Descriptor instead.
func (*AlertConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_project_proto_rawDescGZIP(), []int{2}
}

func (x *AlertConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AlertConfig) GetAlertPolicies() []*AlertConfig_AlertPolicy {
	if x != nil {
		return x.AlertPolicies
	}
	return nil
}

// The logging configurations for services supporting log generation.
type LoggingConfig_LogGenerationRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The logging level.
	//
	// By default it is set to `LOG_WARNINGS_AND_ABOVE`.
	LoggingLevel LoggingConfig_LoggingLevel `protobuf:"varint,1,opt,name=logging_level,json=loggingLevel,proto3,enum=google.cloud.retail.v2alpha.LoggingConfig_LoggingLevel" json:"logging_level,omitempty"`
	// The log sample rate for INFO level log entries. You can use this to
	// reduce the number of entries generated for INFO level logs.
	//
	// DO NOT set this field if the
	// [logging_level][google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.logging_level]
	// is not
	// [LoggingLevel.LOG_ALL][google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel.LOG_ALL].
	// Otherwise, an INVALID_ARGUMENT error is returned.
	//
	// Sample rate for INFO logs defaults to 1 when unset (generate and send all
	// INFO logs to Cloud Logging). Its value must be greater than 0 and less
	// than or equal to 1.
	InfoLogSampleRate *float32 `protobuf:"fixed32,2,opt,name=info_log_sample_rate,json=infoLogSampleRate,proto3,oneof" json:"info_log_sample_rate,omitempty"`
}

func (x *LoggingConfig_LogGenerationRule) Reset() {
	*x = LoggingConfig_LogGenerationRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2alpha_project_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggingConfig_LogGenerationRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingConfig_LogGenerationRule) ProtoMessage() {}

func (x *LoggingConfig_LogGenerationRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_project_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingConfig_LogGenerationRule.ProtoReflect.Descriptor instead.
func (*LoggingConfig_LogGenerationRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_project_proto_rawDescGZIP(), []int{0, 0}
}

func (x *LoggingConfig_LogGenerationRule) GetLoggingLevel() LoggingConfig_LoggingLevel {
	if x != nil {
		return x.LoggingLevel
	}
	return LoggingConfig_LOGGING_LEVEL_UNSPECIFIED
}

func (x *LoggingConfig_LogGenerationRule) GetInfoLogSampleRate() float32 {
	if x != nil && x.InfoLogSampleRate != nil {
		return *x.InfoLogSampleRate
	}
	return 0
}

// The granular logging configurations for supported services.
type LoggingConfig_ServiceLogGenerationRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Supported service names:
	// "CatalogService",
	// "CompletionService",
	// "ControlService",
	// "MerchantCenterStreaming",
	// "ModelService",
	// "PredictionService",
	// "ProductService",
	// "ServingConfigService",
	// "UserEventService",
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The log generation rule that applies to this service.
	LogGenerationRule *LoggingConfig_LogGenerationRule `protobuf:"bytes,3,opt,name=log_generation_rule,json=logGenerationRule,proto3" json:"log_generation_rule,omitempty"`
}

func (x *LoggingConfig_ServiceLogGenerationRule) Reset() {
	*x = LoggingConfig_ServiceLogGenerationRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2alpha_project_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggingConfig_ServiceLogGenerationRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingConfig_ServiceLogGenerationRule) ProtoMessage() {}

func (x *LoggingConfig_ServiceLogGenerationRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_project_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingConfig_ServiceLogGenerationRule.ProtoReflect.Descriptor instead.
func (*LoggingConfig_ServiceLogGenerationRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_project_proto_rawDescGZIP(), []int{0, 1}
}

func (x *LoggingConfig_ServiceLogGenerationRule) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *LoggingConfig_ServiceLogGenerationRule) GetLogGenerationRule() *LoggingConfig_LogGenerationRule {
	if x != nil {
		return x.LogGenerationRule
	}
	return nil
}

// Alert policy for a customer.
type AlertConfig_AlertPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The feature that provides alerting capability. Supported value is
	// only `search-data-quality` for now.
	AlertGroup string `protobuf:"bytes,1,opt,name=alert_group,json=alertGroup,proto3" json:"alert_group,omitempty"`
	// The enrollment status of a customer.
	EnrollStatus AlertConfig_AlertPolicy_EnrollStatus `protobuf:"varint,2,opt,name=enroll_status,json=enrollStatus,proto3,enum=google.cloud.retail.v2alpha.AlertConfig_AlertPolicy_EnrollStatus" json:"enroll_status,omitempty"`
	// Recipients for the alert policy.
	// One alert policy should not exceed 20 recipients.
	Recipients []*AlertConfig_AlertPolicy_Recipient `protobuf:"bytes,3,rep,name=recipients,proto3" json:"recipients,omitempty"`
}

func (x *AlertConfig_AlertPolicy) Reset() {
	*x = AlertConfig_AlertPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2alpha_project_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlertConfig_AlertPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlertConfig_AlertPolicy) ProtoMessage() {}

func (x *AlertConfig_AlertPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_project_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlertConfig_AlertPolicy.ProtoReflect.Descriptor instead.
func (*AlertConfig_AlertPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_project_proto_rawDescGZIP(), []int{2, 0}
}

func (x *AlertConfig_AlertPolicy) GetAlertGroup() string {
	if x != nil {
		return x.AlertGroup
	}
	return ""
}

func (x *AlertConfig_AlertPolicy) GetEnrollStatus() AlertConfig_AlertPolicy_EnrollStatus {
	if x != nil {
		return x.EnrollStatus
	}
	return AlertConfig_AlertPolicy_ENROLL_STATUS_UNSPECIFIED
}

func (x *AlertConfig_AlertPolicy) GetRecipients() []*AlertConfig_AlertPolicy_Recipient {
	if x != nil {
		return x.Recipients
	}
	return nil
}

// Recipient contact information.
type AlertConfig_AlertPolicy_Recipient struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Email address of the recipient.
	EmailAddress string `protobuf:"bytes,1,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
}

func (x *AlertConfig_AlertPolicy_Recipient) Reset() {
	*x = AlertConfig_AlertPolicy_Recipient{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_retail_v2alpha_project_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlertConfig_AlertPolicy_Recipient) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlertConfig_AlertPolicy_Recipient) ProtoMessage() {}

func (x *AlertConfig_AlertPolicy_Recipient) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2alpha_project_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlertConfig_AlertPolicy_Recipient.ProtoReflect.Descriptor instead.
func (*AlertConfig_AlertPolicy_Recipient) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2alpha_project_proto_rawDescGZIP(), []int{2, 0, 0}
}

func (x *AlertConfig_AlertPolicy_Recipient) GetEmailAddress() string {
	if x != nil {
		return x.EmailAddress
	}
	return ""
}

var File_google_cloud_retail_v2alpha_project_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2alpha_project_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfa,
	0x06, 0x0a, 0x0d, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06,
	0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x7b, 0x0a, 0x1b,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f,
	0x67, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x18, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x6f, 0x67, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x84, 0x01, 0x0a, 0x1c, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x4c, 0x6f, 0x67, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x19, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x6f,
	0x67, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73,
	0x1a, 0xc0, 0x01, 0x0a, 0x11, 0x4c, 0x6f, 0x67, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x5c, 0x0a, 0x0d, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0c, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x34, 0x0a, 0x14, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x6c, 0x6f, 0x67,
	0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x02, 0x48, 0x00, 0x52, 0x11, 0x69, 0x6e, 0x66, 0x6f, 0x4c, 0x6f, 0x67, 0x53, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x52, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x1a, 0xb0, 0x01, 0x0a, 0x18, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c,
	0x6f, 0x67, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65,
	0x12, 0x26, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x6c, 0x0a, 0x13, 0x6c, 0x6f, 0x67, 0x5f,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x4c, 0x6f, 0x67, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x75, 0x6c, 0x65, 0x52, 0x11, 0x6c, 0x6f, 0x67, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x22, 0x86, 0x01, 0x0a, 0x0c, 0x4c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1d, 0x0a, 0x19, 0x4c, 0x4f, 0x47, 0x47, 0x49,
	0x4e, 0x47, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x4c, 0x4f, 0x47, 0x47, 0x49, 0x4e,
	0x47, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14,
	0x4c, 0x4f, 0x47, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41,
	0x42, 0x4f, 0x56, 0x45, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16, 0x4c, 0x4f, 0x47, 0x5f, 0x57, 0x41,
	0x52, 0x4e, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x42, 0x4f, 0x56, 0x45,
	0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x4c, 0x4f, 0x47, 0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x04, 0x3a,
	0x4a, 0xea, 0x41, 0x47, 0x0a, 0x23, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x20, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xcd, 0x01, 0x0a, 0x07,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x5d, 0x0a, 0x12, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x65, 0x6e,
	0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a,
	0x4a, 0xea, 0x41, 0x47, 0x0a, 0x23, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x20, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xc4, 0x04, 0x0a, 0x0b,
	0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41,
	0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x0e, 0x61, 0x6c, 0x65, 0x72, 0x74,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6c,
	0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0d, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x1a, 0xf3, 0x02, 0x0a, 0x0b, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x6c, 0x65, 0x72, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x66, 0x0a, 0x0d, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x0c, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x5e, 0x0a,
	0x0a, 0x72, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x6c, 0x65, 0x72,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65, 0x6e,
	0x74, 0x52, 0x0a, 0x72, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x30, 0x0a,
	0x09, 0x52, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22,
	0x49, 0x0a, 0x0c, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x1d, 0x0a, 0x19, 0x45, 0x4e, 0x52, 0x4f, 0x4c, 0x4c, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x45, 0x4e, 0x52, 0x4f, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x44, 0x45, 0x43, 0x4c, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x02, 0x3a, 0x46, 0xea, 0x41, 0x43, 0x0a,
	0x21, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x1e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0xd0, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x0c, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0xa2,
	0x02, 0x06, 0x52, 0x45, 0x54, 0x41, 0x49, 0x4c, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x56,
	0x32, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5c, 0x56, 0x32, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0xea, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x3a, 0x3a, 0x56, 0x32,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2alpha_project_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2alpha_project_proto_rawDescData = file_google_cloud_retail_v2alpha_project_proto_rawDesc
)

func file_google_cloud_retail_v2alpha_project_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2alpha_project_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2alpha_project_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2alpha_project_proto_rawDescData)
	})
	return file_google_cloud_retail_v2alpha_project_proto_rawDescData
}

var file_google_cloud_retail_v2alpha_project_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_retail_v2alpha_project_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_retail_v2alpha_project_proto_goTypes = []interface{}{
	(LoggingConfig_LoggingLevel)(0),                // 0: google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel
	(AlertConfig_AlertPolicy_EnrollStatus)(0),      // 1: google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus
	(*LoggingConfig)(nil),                          // 2: google.cloud.retail.v2alpha.LoggingConfig
	(*Project)(nil),                                // 3: google.cloud.retail.v2alpha.Project
	(*AlertConfig)(nil),                            // 4: google.cloud.retail.v2alpha.AlertConfig
	(*LoggingConfig_LogGenerationRule)(nil),        // 5: google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
	(*LoggingConfig_ServiceLogGenerationRule)(nil), // 6: google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
	(*AlertConfig_AlertPolicy)(nil),                // 7: google.cloud.retail.v2alpha.AlertConfig.AlertPolicy
	(*AlertConfig_AlertPolicy_Recipient)(nil),      // 8: google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient
	(SolutionType)(0),                              // 9: google.cloud.retail.v2alpha.SolutionType
}
var file_google_cloud_retail_v2alpha_project_proto_depIdxs = []int32{
	5, // 0: google.cloud.retail.v2alpha.LoggingConfig.default_log_generation_rule:type_name -> google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
	6, // 1: google.cloud.retail.v2alpha.LoggingConfig.service_log_generation_rules:type_name -> google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule
	9, // 2: google.cloud.retail.v2alpha.Project.enrolled_solutions:type_name -> google.cloud.retail.v2alpha.SolutionType
	7, // 3: google.cloud.retail.v2alpha.AlertConfig.alert_policies:type_name -> google.cloud.retail.v2alpha.AlertConfig.AlertPolicy
	0, // 4: google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule.logging_level:type_name -> google.cloud.retail.v2alpha.LoggingConfig.LoggingLevel
	5, // 5: google.cloud.retail.v2alpha.LoggingConfig.ServiceLogGenerationRule.log_generation_rule:type_name -> google.cloud.retail.v2alpha.LoggingConfig.LogGenerationRule
	1, // 6: google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.enroll_status:type_name -> google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.EnrollStatus
	8, // 7: google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.recipients:type_name -> google.cloud.retail.v2alpha.AlertConfig.AlertPolicy.Recipient
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2alpha_project_proto_init() }
func file_google_cloud_retail_v2alpha_project_proto_init() {
	if File_google_cloud_retail_v2alpha_project_proto != nil {
		return
	}
	file_google_cloud_retail_v2alpha_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_retail_v2alpha_project_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoggingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2alpha_project_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Project); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2alpha_project_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AlertConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2alpha_project_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoggingConfig_LogGenerationRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2alpha_project_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoggingConfig_ServiceLogGenerationRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2alpha_project_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AlertConfig_AlertPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_retail_v2alpha_project_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AlertConfig_AlertPolicy_Recipient); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_retail_v2alpha_project_proto_msgTypes[3].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2alpha_project_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_retail_v2alpha_project_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2alpha_project_proto_depIdxs,
		EnumInfos:         file_google_cloud_retail_v2alpha_project_proto_enumTypes,
		MessageInfos:      file_google_cloud_retail_v2alpha_project_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2alpha_project_proto = out.File
	file_google_cloud_retail_v2alpha_project_proto_rawDesc = nil
	file_google_cloud_retail_v2alpha_project_proto_goTypes = nil
	file_google_cloud_retail_v2alpha_project_proto_depIdxs = nil
}
