// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/translate/v3/adaptive_mt.proto

package translatepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An Adaptive MT Dataset.
type AdaptiveMtDataset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the dataset, in form of
	// `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the dataset to show in the interface. The name can be
	// up to 32 characters long and can consist only of ASCII Latin letters A-Z
	// and a-z, underscores (_), and ASCII digits 0-9.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The BCP-47 language code of the source language.
	SourceLanguageCode string `protobuf:"bytes,3,opt,name=source_language_code,json=sourceLanguageCode,proto3" json:"source_language_code,omitempty"`
	// The BCP-47 language code of the target language.
	TargetLanguageCode string `protobuf:"bytes,4,opt,name=target_language_code,json=targetLanguageCode,proto3" json:"target_language_code,omitempty"`
	// The number of examples in the dataset.
	ExampleCount int32 `protobuf:"varint,5,opt,name=example_count,json=exampleCount,proto3" json:"example_count,omitempty"`
	// Output only. Timestamp when this dataset was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this dataset was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *AdaptiveMtDataset) Reset() {
	*x = AdaptiveMtDataset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdaptiveMtDataset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdaptiveMtDataset) ProtoMessage() {}

func (x *AdaptiveMtDataset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdaptiveMtDataset.ProtoReflect.Descriptor instead.
func (*AdaptiveMtDataset) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{0}
}

func (x *AdaptiveMtDataset) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AdaptiveMtDataset) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AdaptiveMtDataset) GetSourceLanguageCode() string {
	if x != nil {
		return x.SourceLanguageCode
	}
	return ""
}

func (x *AdaptiveMtDataset) GetTargetLanguageCode() string {
	if x != nil {
		return x.TargetLanguageCode
	}
	return ""
}

func (x *AdaptiveMtDataset) GetExampleCount() int32 {
	if x != nil {
		return x.ExampleCount
	}
	return 0
}

func (x *AdaptiveMtDataset) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AdaptiveMtDataset) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

//  Request message for creating an AdaptiveMtDataset.
type CreateAdaptiveMtDatasetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the parent project. In form of
	// `projects/{project-number-or-id}/locations/{location-id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The AdaptiveMtDataset to be created.
	AdaptiveMtDataset *AdaptiveMtDataset `protobuf:"bytes,2,opt,name=adaptive_mt_dataset,json=adaptiveMtDataset,proto3" json:"adaptive_mt_dataset,omitempty"`
}

func (x *CreateAdaptiveMtDatasetRequest) Reset() {
	*x = CreateAdaptiveMtDatasetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAdaptiveMtDatasetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAdaptiveMtDatasetRequest) ProtoMessage() {}

func (x *CreateAdaptiveMtDatasetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAdaptiveMtDatasetRequest.ProtoReflect.Descriptor instead.
func (*CreateAdaptiveMtDatasetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{1}
}

func (x *CreateAdaptiveMtDatasetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAdaptiveMtDatasetRequest) GetAdaptiveMtDataset() *AdaptiveMtDataset {
	if x != nil {
		return x.AdaptiveMtDataset
	}
	return nil
}

// Request message for deleting an AdaptiveMtDataset.
type DeleteAdaptiveMtDatasetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the dataset. In the form of
	// `projects/{project-number-or-id}/locations/{location-id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAdaptiveMtDatasetRequest) Reset() {
	*x = DeleteAdaptiveMtDatasetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAdaptiveMtDatasetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAdaptiveMtDatasetRequest) ProtoMessage() {}

func (x *DeleteAdaptiveMtDatasetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAdaptiveMtDatasetRequest.ProtoReflect.Descriptor instead.
func (*DeleteAdaptiveMtDatasetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{2}
}

func (x *DeleteAdaptiveMtDatasetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for getting an Adaptive MT dataset.
type GetAdaptiveMtDatasetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the dataset. In the form of
	// `projects/{project-number-or-id}/locations/{location-id}/adaptiveMtDatasets/{adaptive-mt-dataset-id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAdaptiveMtDatasetRequest) Reset() {
	*x = GetAdaptiveMtDatasetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAdaptiveMtDatasetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAdaptiveMtDatasetRequest) ProtoMessage() {}

func (x *GetAdaptiveMtDatasetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAdaptiveMtDatasetRequest.ProtoReflect.Descriptor instead.
func (*GetAdaptiveMtDatasetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{3}
}

func (x *GetAdaptiveMtDatasetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for listing all Adaptive MT datasets that the requestor has
// access to.
type ListAdaptiveMtDatasetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the project from which to list the Adaptive
	// MT datasets. `projects/{project-number-or-id}/locations/{location-id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. The server may return fewer results than
	// requested. If unspecified, the server picks an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	// Typically, this is the value of
	// ListAdaptiveMtDatasetsResponse.next_page_token returned from the
	// previous call to `ListAdaptiveMtDatasets` method. The first page is
	// returned if `page_token`is empty or missing.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. An expression for filtering the results of the request.
	// Filter is not supported yet.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListAdaptiveMtDatasetsRequest) Reset() {
	*x = ListAdaptiveMtDatasetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAdaptiveMtDatasetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAdaptiveMtDatasetsRequest) ProtoMessage() {}

func (x *ListAdaptiveMtDatasetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAdaptiveMtDatasetsRequest.ProtoReflect.Descriptor instead.
func (*ListAdaptiveMtDatasetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{4}
}

func (x *ListAdaptiveMtDatasetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAdaptiveMtDatasetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAdaptiveMtDatasetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAdaptiveMtDatasetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// A list of AdaptiveMtDatasets.
type ListAdaptiveMtDatasetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. A list of Adaptive MT datasets.
	AdaptiveMtDatasets []*AdaptiveMtDataset `protobuf:"bytes,1,rep,name=adaptive_mt_datasets,json=adaptiveMtDatasets,proto3" json:"adaptive_mt_datasets,omitempty"`
	// Optional. A token to retrieve a page of results. Pass this value in the
	// [ListAdaptiveMtDatasetsRequest.page_token] field in the subsequent call to
	// `ListAdaptiveMtDatasets` method to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAdaptiveMtDatasetsResponse) Reset() {
	*x = ListAdaptiveMtDatasetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAdaptiveMtDatasetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAdaptiveMtDatasetsResponse) ProtoMessage() {}

func (x *ListAdaptiveMtDatasetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAdaptiveMtDatasetsResponse.ProtoReflect.Descriptor instead.
func (*ListAdaptiveMtDatasetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{5}
}

func (x *ListAdaptiveMtDatasetsResponse) GetAdaptiveMtDatasets() []*AdaptiveMtDataset {
	if x != nil {
		return x.AdaptiveMtDatasets
	}
	return nil
}

func (x *ListAdaptiveMtDatasetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for sending an AdaptiveMt translation query.
type AdaptiveMtTranslateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Location to make a regional call.
	//
	// Format: `projects/{project-number-or-id}/locations/{location-id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The resource name for the dataset to use for adaptive MT.
	// `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
	Dataset string `protobuf:"bytes,2,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The content of the input in string format.
	// For now only one sentence per request is supported.
	Content []string `protobuf:"bytes,3,rep,name=content,proto3" json:"content,omitempty"`
}

func (x *AdaptiveMtTranslateRequest) Reset() {
	*x = AdaptiveMtTranslateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdaptiveMtTranslateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdaptiveMtTranslateRequest) ProtoMessage() {}

func (x *AdaptiveMtTranslateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdaptiveMtTranslateRequest.ProtoReflect.Descriptor instead.
func (*AdaptiveMtTranslateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{6}
}

func (x *AdaptiveMtTranslateRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *AdaptiveMtTranslateRequest) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *AdaptiveMtTranslateRequest) GetContent() []string {
	if x != nil {
		return x.Content
	}
	return nil
}

// An AdaptiveMt translation.
type AdaptiveMtTranslation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The translated text.
	TranslatedText string `protobuf:"bytes,1,opt,name=translated_text,json=translatedText,proto3" json:"translated_text,omitempty"`
}

func (x *AdaptiveMtTranslation) Reset() {
	*x = AdaptiveMtTranslation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdaptiveMtTranslation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdaptiveMtTranslation) ProtoMessage() {}

func (x *AdaptiveMtTranslation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdaptiveMtTranslation.ProtoReflect.Descriptor instead.
func (*AdaptiveMtTranslation) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{7}
}

func (x *AdaptiveMtTranslation) GetTranslatedText() string {
	if x != nil {
		return x.TranslatedText
	}
	return ""
}

// An AdaptiveMtTranslate response.
type AdaptiveMtTranslateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The translation.
	Translations []*AdaptiveMtTranslation `protobuf:"bytes,1,rep,name=translations,proto3" json:"translations,omitempty"`
	// Output only. The translation's language code.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *AdaptiveMtTranslateResponse) Reset() {
	*x = AdaptiveMtTranslateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdaptiveMtTranslateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdaptiveMtTranslateResponse) ProtoMessage() {}

func (x *AdaptiveMtTranslateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdaptiveMtTranslateResponse.ProtoReflect.Descriptor instead.
func (*AdaptiveMtTranslateResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{8}
}

func (x *AdaptiveMtTranslateResponse) GetTranslations() []*AdaptiveMtTranslation {
	if x != nil {
		return x.Translations
	}
	return nil
}

func (x *AdaptiveMtTranslateResponse) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// An AdaptiveMtFile.
type AdaptiveMtFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the file, in form of
	// `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The file's display name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The number of entries that the file contains.
	EntryCount int32 `protobuf:"varint,3,opt,name=entry_count,json=entryCount,proto3" json:"entry_count,omitempty"`
	// Output only. Timestamp when this file was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this file was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *AdaptiveMtFile) Reset() {
	*x = AdaptiveMtFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdaptiveMtFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdaptiveMtFile) ProtoMessage() {}

func (x *AdaptiveMtFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdaptiveMtFile.ProtoReflect.Descriptor instead.
func (*AdaptiveMtFile) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{9}
}

func (x *AdaptiveMtFile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AdaptiveMtFile) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AdaptiveMtFile) GetEntryCount() int32 {
	if x != nil {
		return x.EntryCount
	}
	return 0
}

func (x *AdaptiveMtFile) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AdaptiveMtFile) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// The request for getting an AdaptiveMtFile.
type GetAdaptiveMtFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the file, in form of
	// `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAdaptiveMtFileRequest) Reset() {
	*x = GetAdaptiveMtFileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAdaptiveMtFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAdaptiveMtFileRequest) ProtoMessage() {}

func (x *GetAdaptiveMtFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAdaptiveMtFileRequest.ProtoReflect.Descriptor instead.
func (*GetAdaptiveMtFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{10}
}

func (x *GetAdaptiveMtFileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for deleting an AdaptiveMt file.
type DeleteAdaptiveMtFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the file to delete, in form of
	// `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAdaptiveMtFileRequest) Reset() {
	*x = DeleteAdaptiveMtFileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAdaptiveMtFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAdaptiveMtFileRequest) ProtoMessage() {}

func (x *DeleteAdaptiveMtFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAdaptiveMtFileRequest.ProtoReflect.Descriptor instead.
func (*DeleteAdaptiveMtFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteAdaptiveMtFileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for importing an AdaptiveMt file along with its sentences.
type ImportAdaptiveMtFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the file, in form of
	// `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The source for the document.
	//
	// Types that are assignable to Source:
	//
	//	*ImportAdaptiveMtFileRequest_FileInputSource
	//	*ImportAdaptiveMtFileRequest_GcsInputSource
	Source isImportAdaptiveMtFileRequest_Source `protobuf_oneof:"source"`
}

func (x *ImportAdaptiveMtFileRequest) Reset() {
	*x = ImportAdaptiveMtFileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAdaptiveMtFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAdaptiveMtFileRequest) ProtoMessage() {}

func (x *ImportAdaptiveMtFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAdaptiveMtFileRequest.ProtoReflect.Descriptor instead.
func (*ImportAdaptiveMtFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{12}
}

func (x *ImportAdaptiveMtFileRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *ImportAdaptiveMtFileRequest) GetSource() isImportAdaptiveMtFileRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportAdaptiveMtFileRequest) GetFileInputSource() *FileInputSource {
	if x, ok := x.GetSource().(*ImportAdaptiveMtFileRequest_FileInputSource); ok {
		return x.FileInputSource
	}
	return nil
}

func (x *ImportAdaptiveMtFileRequest) GetGcsInputSource() *GcsInputSource {
	if x, ok := x.GetSource().(*ImportAdaptiveMtFileRequest_GcsInputSource); ok {
		return x.GcsInputSource
	}
	return nil
}

type isImportAdaptiveMtFileRequest_Source interface {
	isImportAdaptiveMtFileRequest_Source()
}

type ImportAdaptiveMtFileRequest_FileInputSource struct {
	// Inline file source.
	FileInputSource *FileInputSource `protobuf:"bytes,2,opt,name=file_input_source,json=fileInputSource,proto3,oneof"`
}

type ImportAdaptiveMtFileRequest_GcsInputSource struct {
	// Google Cloud Storage file source.
	GcsInputSource *GcsInputSource `protobuf:"bytes,3,opt,name=gcs_input_source,json=gcsInputSource,proto3,oneof"`
}

func (*ImportAdaptiveMtFileRequest_FileInputSource) isImportAdaptiveMtFileRequest_Source() {}

func (*ImportAdaptiveMtFileRequest_GcsInputSource) isImportAdaptiveMtFileRequest_Source() {}

// The response for importing an AdaptiveMtFile
type ImportAdaptiveMtFileResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The Adaptive MT file that was imported.
	AdaptiveMtFile *AdaptiveMtFile `protobuf:"bytes,1,opt,name=adaptive_mt_file,json=adaptiveMtFile,proto3" json:"adaptive_mt_file,omitempty"`
}

func (x *ImportAdaptiveMtFileResponse) Reset() {
	*x = ImportAdaptiveMtFileResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAdaptiveMtFileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAdaptiveMtFileResponse) ProtoMessage() {}

func (x *ImportAdaptiveMtFileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAdaptiveMtFileResponse.ProtoReflect.Descriptor instead.
func (*ImportAdaptiveMtFileResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{13}
}

func (x *ImportAdaptiveMtFileResponse) GetAdaptiveMtFile() *AdaptiveMtFile {
	if x != nil {
		return x.AdaptiveMtFile
	}
	return nil
}

// The request to list all AdaptiveMt files under a given dataset.
type ListAdaptiveMtFilesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the project from which to list the Adaptive
	// MT files.
	// `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	// Typically, this is the value of
	// ListAdaptiveMtFilesResponse.next_page_token returned from the
	// previous call to `ListAdaptiveMtFiles` method. The first page is
	// returned if `page_token`is empty or missing.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAdaptiveMtFilesRequest) Reset() {
	*x = ListAdaptiveMtFilesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAdaptiveMtFilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAdaptiveMtFilesRequest) ProtoMessage() {}

func (x *ListAdaptiveMtFilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAdaptiveMtFilesRequest.ProtoReflect.Descriptor instead.
func (*ListAdaptiveMtFilesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{14}
}

func (x *ListAdaptiveMtFilesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAdaptiveMtFilesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAdaptiveMtFilesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for listing all AdaptiveMt files under a given dataset.
type ListAdaptiveMtFilesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The Adaptive MT files.
	AdaptiveMtFiles []*AdaptiveMtFile `protobuf:"bytes,1,rep,name=adaptive_mt_files,json=adaptiveMtFiles,proto3" json:"adaptive_mt_files,omitempty"`
	// Optional. A token to retrieve a page of results. Pass this value in the
	// ListAdaptiveMtFilesRequest.page_token field in the subsequent call to
	// `ListAdaptiveMtFiles` method to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAdaptiveMtFilesResponse) Reset() {
	*x = ListAdaptiveMtFilesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAdaptiveMtFilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAdaptiveMtFilesResponse) ProtoMessage() {}

func (x *ListAdaptiveMtFilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAdaptiveMtFilesResponse.ProtoReflect.Descriptor instead.
func (*ListAdaptiveMtFilesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{15}
}

func (x *ListAdaptiveMtFilesResponse) GetAdaptiveMtFiles() []*AdaptiveMtFile {
	if x != nil {
		return x.AdaptiveMtFiles
	}
	return nil
}

func (x *ListAdaptiveMtFilesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// An AdaptiveMt sentence entry.
type AdaptiveMtSentence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the file, in form of
	// `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}/adaptiveMtSentences/{sentence}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The source sentence.
	SourceSentence string `protobuf:"bytes,2,opt,name=source_sentence,json=sourceSentence,proto3" json:"source_sentence,omitempty"`
	// Required. The target sentence.
	TargetSentence string `protobuf:"bytes,3,opt,name=target_sentence,json=targetSentence,proto3" json:"target_sentence,omitempty"`
	// Output only. Timestamp when this sentence was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this sentence was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *AdaptiveMtSentence) Reset() {
	*x = AdaptiveMtSentence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdaptiveMtSentence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdaptiveMtSentence) ProtoMessage() {}

func (x *AdaptiveMtSentence) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdaptiveMtSentence.ProtoReflect.Descriptor instead.
func (*AdaptiveMtSentence) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{16}
}

func (x *AdaptiveMtSentence) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AdaptiveMtSentence) GetSourceSentence() string {
	if x != nil {
		return x.SourceSentence
	}
	return ""
}

func (x *AdaptiveMtSentence) GetTargetSentence() string {
	if x != nil {
		return x.TargetSentence
	}
	return ""
}

func (x *AdaptiveMtSentence) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AdaptiveMtSentence) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// The request for listing Adaptive MT sentences from a Dataset/File.
type ListAdaptiveMtSentencesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the project from which to list the Adaptive
	// MT files. The following format lists all sentences under a file.
	// `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}/adaptiveMtFiles/{file}`
	// The following format lists all sentences within a dataset.
	// `projects/{project}/locations/{location}/adaptiveMtDatasets/{dataset}`
	Parent   string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	PageSize int32  `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	// Typically, this is the value of
	// ListAdaptiveMtSentencesRequest.next_page_token returned from the
	// previous call to `ListTranslationMemories` method. The first page is
	// returned if `page_token` is empty or missing.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAdaptiveMtSentencesRequest) Reset() {
	*x = ListAdaptiveMtSentencesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAdaptiveMtSentencesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAdaptiveMtSentencesRequest) ProtoMessage() {}

func (x *ListAdaptiveMtSentencesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAdaptiveMtSentencesRequest.ProtoReflect.Descriptor instead.
func (*ListAdaptiveMtSentencesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{17}
}

func (x *ListAdaptiveMtSentencesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAdaptiveMtSentencesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAdaptiveMtSentencesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// List AdaptiveMt sentences response.
type ListAdaptiveMtSentencesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of AdaptiveMtSentences.
	AdaptiveMtSentences []*AdaptiveMtSentence `protobuf:"bytes,1,rep,name=adaptive_mt_sentences,json=adaptiveMtSentences,proto3" json:"adaptive_mt_sentences,omitempty"`
	// Optional.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAdaptiveMtSentencesResponse) Reset() {
	*x = ListAdaptiveMtSentencesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAdaptiveMtSentencesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAdaptiveMtSentencesResponse) ProtoMessage() {}

func (x *ListAdaptiveMtSentencesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAdaptiveMtSentencesResponse.ProtoReflect.Descriptor instead.
func (*ListAdaptiveMtSentencesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP(), []int{18}
}

func (x *ListAdaptiveMtSentencesResponse) GetAdaptiveMtSentences() []*AdaptiveMtSentence {
	if x != nil {
		return x.AdaptiveMtSentences
	}
	return nil
}

func (x *ListAdaptiveMtSentencesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_cloud_translate_v3_adaptive_mt_proto protoreflect.FileDescriptor

var file_google_cloud_translate_v3_adaptive_mt_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x61, 0x64, 0x61, 0x70,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2f, 0x76,
	0x33, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x82, 0x04, 0x0a, 0x11, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x30, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x75, 0xea,
	0x41, 0x72, 0x0a, 0x2a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x61,
	0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x44,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65,
	0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x7d, 0x22, 0xc8, 0x01, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x63, 0x0a, 0x13, 0x61, 0x64,
	0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x61, 0x64,
	0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x22,
	0x68, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76,
	0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x65, 0x0a, 0x1b, 0x47, 0x65, 0x74,
	0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76,
	0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xc5, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76,
	0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xb4, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x65, 0x0a, 0x14, 0x61,
	0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65,
	0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12,
	0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xcc, 0x01, 0x0a, 0x1a, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x4c, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12,
	0x1d, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x45,
	0x0a, 0x15, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65,
	0x64, 0x54, 0x65, 0x78, 0x74, 0x22, 0xa4, 0x01, 0x0a, 0x1b, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69,
	0x76, 0x65, 0x4d, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69,
	0x76, 0x65, 0x4d, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xaa, 0x03, 0x0a,
	0x0e, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x12,
	0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x8a, 0x01, 0xea,
	0x41, 0x86, 0x01, 0x0a, 0x27, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64,
	0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x5b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x7d, 0x2f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x2f, 0x7b, 0x66, 0x69, 0x6c, 0x65, 0x7d, 0x22, 0x5f, 0x0a, 0x18, 0x47, 0x65, 0x74,
	0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74,
	0x46, 0x69, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x62, 0x0a, 0x1b, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69,
	0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a,
	0x27, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69,
	0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa8,
	0x02, 0x0a, 0x1b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76,
	0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x11, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x33, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x57, 0x0a, 0x10, 0x67, 0x63, 0x73, 0x5f, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x47,
	0x63, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52,
	0x0e, 0x67, 0x63, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x7a, 0x0a, 0x1c, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x10, 0x61, 0x64, 0x61,
	0x70, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x33, 0x2e, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d,
	0x74, 0x46, 0x69, 0x6c, 0x65, 0x22, 0xae, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64,
	0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa8, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5c, 0x0a, 0x11, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x6d, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e,
	0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xed, 0x03, 0x0a, 0x12, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74,
	0x53, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76,
	0x65, 0x4d, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x2c, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x3a, 0xad, 0x01, 0xea, 0x41, 0xa9, 0x01, 0x0a, 0x2b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x53, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x7a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61,
	0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x2f, 0x61, 0x64, 0x61, 0x70,
	0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x66, 0x69, 0x6c,
	0x65, 0x7d, 0x2f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x53, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65,
	0x7d, 0x22, 0xa5, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69,
	0x76, 0x65, 0x4d, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d,
	0x74, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb8, 0x01, 0x0a, 0x1f, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x53, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x68, 0x0a,
	0x15, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x74, 0x5f, 0x73, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x64, 0x61, 0x70, 0x74,
	0x69, 0x76, 0x65, 0x4d, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x13, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x74, 0x53, 0x65,
	0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x42, 0xc9, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
	0x61, 0x74, 0x65, 0x2e, 0x76, 0x33, 0x42, 0x0f, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65,
	0x4d, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x2f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x70, 0x62, 0x3b, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x65, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x2e, 0x56, 0x33, 0xca, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x5c, 0x56,
	0x33, 0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x3a, 0x3a, 0x56, 0x33,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_translate_v3_adaptive_mt_proto_rawDescOnce sync.Once
	file_google_cloud_translate_v3_adaptive_mt_proto_rawDescData = file_google_cloud_translate_v3_adaptive_mt_proto_rawDesc
)

func file_google_cloud_translate_v3_adaptive_mt_proto_rawDescGZIP() []byte {
	file_google_cloud_translate_v3_adaptive_mt_proto_rawDescOnce.Do(func() {
		file_google_cloud_translate_v3_adaptive_mt_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_translate_v3_adaptive_mt_proto_rawDescData)
	})
	return file_google_cloud_translate_v3_adaptive_mt_proto_rawDescData
}

var file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_google_cloud_translate_v3_adaptive_mt_proto_goTypes = []interface{}{
	(*AdaptiveMtDataset)(nil),               // 0: google.cloud.translation.v3.AdaptiveMtDataset
	(*CreateAdaptiveMtDatasetRequest)(nil),  // 1: google.cloud.translation.v3.CreateAdaptiveMtDatasetRequest
	(*DeleteAdaptiveMtDatasetRequest)(nil),  // 2: google.cloud.translation.v3.DeleteAdaptiveMtDatasetRequest
	(*GetAdaptiveMtDatasetRequest)(nil),     // 3: google.cloud.translation.v3.GetAdaptiveMtDatasetRequest
	(*ListAdaptiveMtDatasetsRequest)(nil),   // 4: google.cloud.translation.v3.ListAdaptiveMtDatasetsRequest
	(*ListAdaptiveMtDatasetsResponse)(nil),  // 5: google.cloud.translation.v3.ListAdaptiveMtDatasetsResponse
	(*AdaptiveMtTranslateRequest)(nil),      // 6: google.cloud.translation.v3.AdaptiveMtTranslateRequest
	(*AdaptiveMtTranslation)(nil),           // 7: google.cloud.translation.v3.AdaptiveMtTranslation
	(*AdaptiveMtTranslateResponse)(nil),     // 8: google.cloud.translation.v3.AdaptiveMtTranslateResponse
	(*AdaptiveMtFile)(nil),                  // 9: google.cloud.translation.v3.AdaptiveMtFile
	(*GetAdaptiveMtFileRequest)(nil),        // 10: google.cloud.translation.v3.GetAdaptiveMtFileRequest
	(*DeleteAdaptiveMtFileRequest)(nil),     // 11: google.cloud.translation.v3.DeleteAdaptiveMtFileRequest
	(*ImportAdaptiveMtFileRequest)(nil),     // 12: google.cloud.translation.v3.ImportAdaptiveMtFileRequest
	(*ImportAdaptiveMtFileResponse)(nil),    // 13: google.cloud.translation.v3.ImportAdaptiveMtFileResponse
	(*ListAdaptiveMtFilesRequest)(nil),      // 14: google.cloud.translation.v3.ListAdaptiveMtFilesRequest
	(*ListAdaptiveMtFilesResponse)(nil),     // 15: google.cloud.translation.v3.ListAdaptiveMtFilesResponse
	(*AdaptiveMtSentence)(nil),              // 16: google.cloud.translation.v3.AdaptiveMtSentence
	(*ListAdaptiveMtSentencesRequest)(nil),  // 17: google.cloud.translation.v3.ListAdaptiveMtSentencesRequest
	(*ListAdaptiveMtSentencesResponse)(nil), // 18: google.cloud.translation.v3.ListAdaptiveMtSentencesResponse
	(*timestamppb.Timestamp)(nil),           // 19: google.protobuf.Timestamp
	(*FileInputSource)(nil),                 // 20: google.cloud.translation.v3.FileInputSource
	(*GcsInputSource)(nil),                  // 21: google.cloud.translation.v3.GcsInputSource
}
var file_google_cloud_translate_v3_adaptive_mt_proto_depIdxs = []int32{
	19, // 0: google.cloud.translation.v3.AdaptiveMtDataset.create_time:type_name -> google.protobuf.Timestamp
	19, // 1: google.cloud.translation.v3.AdaptiveMtDataset.update_time:type_name -> google.protobuf.Timestamp
	0,  // 2: google.cloud.translation.v3.CreateAdaptiveMtDatasetRequest.adaptive_mt_dataset:type_name -> google.cloud.translation.v3.AdaptiveMtDataset
	0,  // 3: google.cloud.translation.v3.ListAdaptiveMtDatasetsResponse.adaptive_mt_datasets:type_name -> google.cloud.translation.v3.AdaptiveMtDataset
	7,  // 4: google.cloud.translation.v3.AdaptiveMtTranslateResponse.translations:type_name -> google.cloud.translation.v3.AdaptiveMtTranslation
	19, // 5: google.cloud.translation.v3.AdaptiveMtFile.create_time:type_name -> google.protobuf.Timestamp
	19, // 6: google.cloud.translation.v3.AdaptiveMtFile.update_time:type_name -> google.protobuf.Timestamp
	20, // 7: google.cloud.translation.v3.ImportAdaptiveMtFileRequest.file_input_source:type_name -> google.cloud.translation.v3.FileInputSource
	21, // 8: google.cloud.translation.v3.ImportAdaptiveMtFileRequest.gcs_input_source:type_name -> google.cloud.translation.v3.GcsInputSource
	9,  // 9: google.cloud.translation.v3.ImportAdaptiveMtFileResponse.adaptive_mt_file:type_name -> google.cloud.translation.v3.AdaptiveMtFile
	9,  // 10: google.cloud.translation.v3.ListAdaptiveMtFilesResponse.adaptive_mt_files:type_name -> google.cloud.translation.v3.AdaptiveMtFile
	19, // 11: google.cloud.translation.v3.AdaptiveMtSentence.create_time:type_name -> google.protobuf.Timestamp
	19, // 12: google.cloud.translation.v3.AdaptiveMtSentence.update_time:type_name -> google.protobuf.Timestamp
	16, // 13: google.cloud.translation.v3.ListAdaptiveMtSentencesResponse.adaptive_mt_sentences:type_name -> google.cloud.translation.v3.AdaptiveMtSentence
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_translate_v3_adaptive_mt_proto_init() }
func file_google_cloud_translate_v3_adaptive_mt_proto_init() {
	if File_google_cloud_translate_v3_adaptive_mt_proto != nil {
		return
	}
	file_google_cloud_translate_v3_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdaptiveMtDataset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAdaptiveMtDatasetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAdaptiveMtDatasetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAdaptiveMtDatasetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAdaptiveMtDatasetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAdaptiveMtDatasetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdaptiveMtTranslateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdaptiveMtTranslation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdaptiveMtTranslateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdaptiveMtFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAdaptiveMtFileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAdaptiveMtFileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAdaptiveMtFileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAdaptiveMtFileResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAdaptiveMtFilesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAdaptiveMtFilesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdaptiveMtSentence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAdaptiveMtSentencesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAdaptiveMtSentencesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*ImportAdaptiveMtFileRequest_FileInputSource)(nil),
		(*ImportAdaptiveMtFileRequest_GcsInputSource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_translate_v3_adaptive_mt_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_translate_v3_adaptive_mt_proto_goTypes,
		DependencyIndexes: file_google_cloud_translate_v3_adaptive_mt_proto_depIdxs,
		MessageInfos:      file_google_cloud_translate_v3_adaptive_mt_proto_msgTypes,
	}.Build()
	File_google_cloud_translate_v3_adaptive_mt_proto = out.File
	file_google_cloud_translate_v3_adaptive_mt_proto_rawDesc = nil
	file_google_cloud_translate_v3_adaptive_mt_proto_goTypes = nil
	file_google_cloud_translate_v3_adaptive_mt_proto_depIdxs = nil
}
