/**
 * \file pappsomspp/processing/cbor/psm/psmfileappend.h
 * \date 10/07/2025
 * \author Olivier Langella
 * \brief append many PSM cbor file into a single one
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include "psmfilereaderbase.h"
#include "../cborstreamwriter.h"
#include <QTemporaryDir>

namespace pappso::cbor::psm
{
/**
 * @todo write docs
 */
class PsmFileAppend : public PsmFileReaderBase
{
  public:
  /**
   * Default constructor
   */
  PsmFileAppend(pappso::cbor::CborStreamWriter *p_output);

  /**
   * Destructor
   */
  virtual ~PsmFileAppend();


  void informationsReady(pappso::UiMonitorInterface &monitor) override;
  void parameterMapReady(pappso::UiMonitorInterface &monitor) override;
  void fastaFilesReady(pappso::UiMonitorInterface &monitor) override;
  void readSample(pappso::UiMonitorInterface &monitor) override;

  void close() override;


  protected:
  void mergeParameterMap();

  struct SampleStorage
  {
    QString fileId;
    QString temporaryFile;
  };

  private:
  QTemporaryDir *mpa_temporaryDirectory;
  pappso::cbor::CborStreamWriter *mp_output;

  bool m_isInformations = false;

  QCborMap m_outputParameterMap;
  QStringList m_outputTargetFastaFiles;
  QStringList m_outputDecoyFastaFiles;
  std::vector<SampleStorage> m_sampleStorageList;
};
} // namespace pappso::cbor::psm
