# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object import DataObject


class CompositeDataSet(DataObject):
    r"""
    CompositeDataSet - abstract superclass for composite (multi-block
    or AMR) datasets
    
    Superclass: DataObject
    
    CompositeDataSet is an abstract class that represents a collection
    of datasets (including other composite datasets). It provides an
    interface to access the datasets through iterators.
    CompositeDataSet provides methods that are used by subclasses to
    store the datasets. CompositeDataSet provides the datastructure
    for a full tree representation. Subclasses provide the semantics for
    it and control how this tree is built.
    
    @sa
    CompositeDataIterator
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCompositeDataSet, obj, update, **traits)
    
    def get_data_set(self, *args):
        """
        get_data_set(self, iter:CompositeDataIterator) -> DataObject
        C++: virtual DataObject *get_data_set(
            CompositeDataIterator *iter)
        Returns the dataset located at the positiong pointed by the
        iterator. The iterator does not need to be iterating over this
        dataset itself. It can be an iterator for composite dataset with
        similar structure (achieved by using copy_structure).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetDataSet, *my_args)
        return wrap_vtk(ret)

    def set_data_set(self, *args):
        """
        set_data_set(self, iter:CompositeDataIterator,
            dataObj:DataObject) -> None
        C++: virtual void set_data_set(CompositeDataIterator *iter,
            DataObject *dataObj)
        Sets the data set at the location pointed by the iterator. The
        iterator does not need to be iterating over this dataset itself.
        It can be any composite datasite with similar structure (achieved
        by using copy_structure).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetDataSet, *my_args)
        return ret

    def get_bounds(self, *args):
        """
        get_bounds(self, bounds:[float, float, float, float, float, float])
             -> None
        C++: void get_bounds(double bounds[6])
        Return the geometric bounding box in the form (xmin,xmax,
        ymin,ymax, zmin,zmax).  Note that if the composite dataset
        contains abstract types (i.e., non DataSet types) such as
        tables these will be ignored by the method. In cases where no
        DataSet is contained in the composite dataset then the
        returned bounds will be undefined. THIS METHOD IS THREAD SAFE IF
        FIRST CALLED FROM A SINGLE THREAD AND THE DATASET IS NOT
        MODIFIED.
        """
        ret = self._wrap_call(self._vtk_obj.GetBounds, *args)
        return ret

    def _get_number_of_cells(self):
        return self._vtk_obj.GetNumberOfCells()
    number_of_cells = traits.Property(_get_number_of_cells, desc=\
        r"""
        Returns the total number of cells of all blocks. This will
        iterate over all blocks and call get_number_of_points() so it might
        be expensive.
        """
    )

    def _get_number_of_points(self):
        return self._vtk_obj.GetNumberOfPoints()
    number_of_points = traits.Property(_get_number_of_points, desc=\
        r"""
        Returns the total number of points of all blocks. This will
        iterate over all blocks and call get_number_of_points() so it might
        be expensive.
        """
    )

    def CURRENT_PROCESS_CAN_LOAD_BLOCK(self):
        """
        current__process__can__load__block() -> InformationIntegerKey
        C++: static InformationIntegerKey *current__process__can__load__block(
            )
        Key used to indicate that the current process can load the data
        in the node.  Used for parallel readers where the nodes are
        assigned to the processes by the reader to indicate further down
        the pipeline which nodes will be on which processes.
        ***THIS IS AN EXPERIMENTAL KEY SUBJECT TO CHANGE WITHOUT
            NOTICE***
        """
        ret = wrap_vtk(self._vtk_obj.CURRENT_PROCESS_CAN_LOAD_BLOCK())
        return ret
        

    def copy_structure(self, *args):
        """
        copy_structure(self, input:CompositeDataSet) -> None
        C++: virtual void copy_structure(CompositeDataSet *input)
        Copies the tree structure from the input. All pointers to
        non-composite data objects are initialized to nullptr. This also
        shallow copies the meta data associated with all the nodes.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyStructure, *my_args)
        return ret

    def NAME(self):
        """
        name() -> InformationStringKey
        C++: static InformationStringKey *name()
        Key used to put node name in the meta-data associated with a
        node.
        """
        ret = wrap_vtk(self._vtk_obj.NAME())
        return ret
        

    def new_iterator(self):
        """
        new_iterator(self) -> CompositeDataIterator
        C++: virtual CompositeDataIterator *new_iterator()
        Return a new iterator (the iterator has to be deleted by user).
        """
        ret = wrap_vtk(self._vtk_obj.NewIterator())
        return ret
        

    def recursive_shallow_copy(self, *args):
        """
        recursive_shallow_copy(self, src:DataObject) -> None
        C++: virtual void recursive_shallow_copy(DataObject *src)
        For historical reasons, `vtkcomposite_data_set::shallow_copy` simply
        pass pointers to the leaf non-composite datasets. In some cases,
        we truly want to shallow copy those leaf non-composite datasets
        as well. For those cases, use this method.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RecursiveShallowCopy, *my_args)
        return ret

    _updateable_traits_ = \
    (('global_release_data_flag', 'GetGlobalReleaseDataFlag'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_release_data_flag', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CompositeDataSet, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CompositeDataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_release_data_flag'], [], []),
            title='Edit CompositeDataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CompositeDataSet properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

