/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Vector;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.psvi.StringList;
import org.apache.xerces.impl.xs.psvi.XSAttributeDeclaration;
import org.apache.xerces.impl.xs.psvi.XSAttributeGroupDefinition;
import org.apache.xerces.impl.xs.psvi.XSElementDeclaration;
import org.apache.xerces.impl.xs.psvi.XSModel;
import org.apache.xerces.impl.xs.psvi.XSModelGroupDefinition;
import org.apache.xerces.impl.xs.psvi.XSNamedMap;
import org.apache.xerces.impl.xs.psvi.XSNamespaceItemList;
import org.apache.xerces.impl.xs.psvi.XSNotationDeclaration;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.impl.xs.util.NSItemListImpl;
import org.apache.xerces.impl.xs.util.StringListImpl;
import org.apache.xerces.impl.xs.util.XSNamedMap4Types;
import org.apache.xerces.impl.xs.util.XSNamedMapImpl;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.util.XMLSymbols;

public class XSModelImpl
implements XSModel {
    private static final short MAX_COMP_IDX = 14;
    private static final boolean[] GLOBAL_COMP = new boolean[]{false, true, true, true, false, true, true, false, false, false, false, true, false, true, true};
    private int fGrammarCount;
    private String[] fNamespaces;
    private SchemaGrammar[] fGrammarList;
    private SymbolHash fGrammarMap;
    private XSNamedMap[] fGlobalComponents;
    private XSNamedMap[][] fNSComponents;
    private SymbolHash[] fTables;

    public XSModelImpl(SchemaGrammar[] schemaGrammarArray) {
        int n = schemaGrammarArray.length;
        this.fNamespaces = new String[Math.max(n + 1, 5)];
        this.fGrammarList = new SchemaGrammar[Math.max(n + 1, 5)];
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            this.fNamespaces[n2] = schemaGrammarArray[n2].getTargetNamespace();
            this.fGrammarList[n2] = schemaGrammarArray[n2];
            if (this.fNamespaces[n2] == SchemaSymbols.URI_SCHEMAFORSCHEMA) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            this.fNamespaces[n] = SchemaSymbols.URI_SCHEMAFORSCHEMA;
            this.fGrammarList[n++] = SchemaGrammar.SG_SchemaNS;
        }
        int n3 = 0;
        while (n3 < n) {
            SchemaGrammar schemaGrammar = this.fGrammarList[n3];
            Vector vector = schemaGrammar.getImportedGrammars();
            int n4 = vector == null ? -1 : vector.size() - 1;
            while (n4 >= 0) {
                SchemaGrammar schemaGrammar2 = (SchemaGrammar)vector.elementAt(n4);
                int n5 = 0;
                while (n5 < n) {
                    if (schemaGrammar2 == this.fGrammarList[n5]) break;
                    ++n5;
                }
                if (n5 == n) {
                    if (n == this.fGrammarList.length) {
                        String[] stringArray = new String[n * 2];
                        System.arraycopy(this.fNamespaces, 0, stringArray, 0, n);
                        this.fNamespaces = stringArray;
                        SchemaGrammar[] schemaGrammarArray2 = new SchemaGrammar[n * 2];
                        System.arraycopy(this.fGrammarList, 0, schemaGrammarArray2, 0, n);
                        this.fGrammarList = schemaGrammarArray2;
                    }
                    this.fNamespaces[n] = schemaGrammar2.getTargetNamespace();
                    this.fGrammarList[n] = schemaGrammar2;
                    ++n;
                }
                --n4;
            }
            ++n3;
        }
        this.fGrammarMap = new SymbolHash(n * 2);
        n3 = 0;
        while (n3 < n) {
            this.fGrammarMap.put(XSModelImpl.null2EmptyString(this.fNamespaces[n3]), this.fGrammarList[n3]);
            ++n3;
        }
        this.fGrammarCount = n;
        this.fGlobalComponents = new XSNamedMap[15];
        this.fNSComponents = new XSNamedMap[n][15];
        this.fTables = new SymbolHash[this.fGrammarCount];
    }

    public StringList getNamespaces() {
        return new StringListImpl(this.fNamespaces, this.fGrammarCount);
    }

    public XSNamespaceItemList getNamespaceItems() {
        return new NSItemListImpl(this.fGrammarList, this.fGrammarCount);
    }

    public synchronized XSNamedMap getComponents(short s) {
        if (s <= 0 || s > 14 || !GLOBAL_COMP[s]) {
            return null;
        }
        if (this.fGlobalComponents[s] == null) {
            int n = 0;
            while (n < this.fGrammarCount) {
                switch (s) {
                    case 3: 
                    case 13: 
                    case 14: {
                        this.fTables[n] = this.fGrammarList[n].fGlobalTypeDecls;
                        break;
                    }
                    case 1: {
                        this.fTables[n] = this.fGrammarList[n].fGlobalAttrDecls;
                        break;
                    }
                    case 2: {
                        this.fTables[n] = this.fGrammarList[n].fGlobalElemDecls;
                        break;
                    }
                    case 5: {
                        this.fTables[n] = this.fGrammarList[n].fGlobalAttrGrpDecls;
                        break;
                    }
                    case 6: {
                        this.fTables[n] = this.fGrammarList[n].fGlobalGroupDecls;
                        break;
                    }
                    case 11: {
                        this.fTables[n] = this.fGrammarList[n].fGlobalNotationDecls;
                    }
                }
                ++n;
            }
            this.fGlobalComponents[s] = s == 13 || s == 14 ? new XSNamedMap4Types(this.fNamespaces, this.fTables, this.fGrammarCount, s) : new XSNamedMapImpl(this.fNamespaces, this.fTables, this.fGrammarCount);
        }
        return this.fGlobalComponents[s];
    }

    public synchronized XSNamedMap getComponentsByNamespace(short s, String string) {
        if (s <= 0 || s > 14 || !GLOBAL_COMP[s]) {
            return null;
        }
        int n = 0;
        while (n < this.fGrammarCount) {
            if (this.fNamespaces[n] == string) break;
            ++n;
        }
        if (n == this.fGrammarCount) {
            return null;
        }
        if (this.fNSComponents[n][s] == null) {
            SymbolHash symbolHash = null;
            switch (s) {
                case 3: 
                case 13: 
                case 14: {
                    symbolHash = this.fGrammarList[n].fGlobalTypeDecls;
                    break;
                }
                case 1: {
                    symbolHash = this.fGrammarList[n].fGlobalAttrDecls;
                    break;
                }
                case 2: {
                    symbolHash = this.fGrammarList[n].fGlobalElemDecls;
                    break;
                }
                case 5: {
                    symbolHash = this.fGrammarList[n].fGlobalAttrGrpDecls;
                    break;
                }
                case 6: {
                    symbolHash = this.fGrammarList[n].fGlobalGroupDecls;
                    break;
                }
                case 11: {
                    symbolHash = this.fGrammarList[n].fGlobalNotationDecls;
                }
            }
            this.fNSComponents[n][s] = s == 13 || s == 14 ? new XSNamedMap4Types(string, symbolHash, s) : new XSNamedMapImpl(string, symbolHash);
        }
        return this.fNSComponents[n][s];
    }

    public XSTypeDefinition getTypeDefinition(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSTypeDefinition)schemaGrammar.fGlobalTypeDecls.get(string);
    }

    public XSAttributeDeclaration getAttributeDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSAttributeDeclaration)schemaGrammar.fGlobalAttrDecls.get(string);
    }

    public XSElementDeclaration getElementDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSElementDeclaration)schemaGrammar.fGlobalElemDecls.get(string);
    }

    public XSAttributeGroupDefinition getAttributeGroup(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSAttributeGroupDefinition)schemaGrammar.fGlobalAttrGrpDecls.get(string);
    }

    public XSModelGroupDefinition getModelGroupDefinition(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSModelGroupDefinition)schemaGrammar.fGlobalGroupDecls.get(string);
    }

    public XSNotationDeclaration getNotationDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSNotationDeclaration)schemaGrammar.fGlobalNotationDecls.get(string);
    }

    public XSObjectList getAnnotations() {
        return null;
    }

    private static final String null2EmptyString(String string) {
        return string == null ? XMLSymbols.EMPTY_STRING : string;
    }
}

