# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RankRequest(Model):
    """Request a set of actions to be ranked by the Personalizer service.

    All required parameters must be populated in order to send to Azure.

    :param context_features: Features of the context used for Personalizer as
     a
     dictionary of dictionaries. This depends on the application, and
     typically includes features about the current user, their
     device, profile information, data about time and date, etc.
    :type context_features: list[object]
    :param actions: Required. The set of actions the Personalizer service can
     pick from.
     The set should not contain more than 50 actions.
     The order of the actions does not affect the rank result but the order
     should match the sequence your application would have used to display
     them.
    :type actions:
     list[~azure.cognitiveservices.personalizer.models.RankableAction]
    :param excluded_actions: The set of action ids to exclude from ranking.
    :type excluded_actions: list[str]
    :param event_id: Optionally pass an eventId that uniquely identifies this
     Rank event.
     If null, the service generates a unique eventId. The eventId will be used
     for
     associating this request with its reward, as well as seeding the
     pseudo-random
     generator when making a Personalizer call.
    :type event_id: str
    :param defer_activation: Send false if the user will see the rank results,
     therefore
     Personalizer will expect a Reward call, otherwise it will assign the
     default
     Reward to the event. Send true if it is possible the user will not see the
     rank results, because the page is rendering later, or the Rank results may
     be
     overridden by code further downstream. Default value: False .
    :type defer_activation: bool
    """

    _validation = {
        "actions": {"required": True},
        "event_id": {"max_length": 256},
    }

    _attribute_map = {
        "context_features": {"key": "contextFeatures", "type": "[object]"},
        "actions": {"key": "actions", "type": "[RankableAction]"},
        "excluded_actions": {"key": "excludedActions", "type": "[str]"},
        "event_id": {"key": "eventId", "type": "str"},
        "defer_activation": {"key": "deferActivation", "type": "bool"},
    }

    def __init__(
        self,
        *,
        actions,
        context_features=None,
        excluded_actions=None,
        event_id: str = None,
        defer_activation: bool = False,
        **kwargs
    ) -> None:
        super(RankRequest, self).__init__(**kwargs)
        self.context_features = context_features
        self.actions = actions
        self.excluded_actions = excluded_actions
        self.event_id = event_id
        self.defer_activation = defer_activation
