% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tween_elements.R
\name{tween_elements}
\alias{tween_elements}
\title{Create frames based on individual element states}
\usage{
tween_elements(data, time, group, ease, timerange, nframes)
}
\arguments{
\item{data}{A data.frame consisting at least of a column giving the
observation id, a column giving timepoints for each state and a column giving
the easing to apply when transitioning away from the state.}

\item{time}{The name of the column holding timepoints}

\item{group}{The name of the column holding the observation id}

\item{ease}{The name of the column holding the easing function name}

\item{timerange}{The range of time to span. If missing it will default to
\code{range(data[[time]])}}

\item{nframes}{The number of frames to generate. If missing it will default
to \code{ceiling(diff(timerange) + 1)} (At least one frame for each
individual timepoint)}
}
\value{
A data.frame with the same columns as \code{data} except for the
group and ease columns, but replicated \code{nframes} times. Two additional
columns called \code{.frame} and \code{.group} will be added giving the frame
number and observation id for each row.
}
\description{
This function creates tweens for each observation individually, in cases
where the data doesn't pass through collective states but consists of fully
independent transitions. Each observation is identified by an id and each
state must have a time associated with it.
}
\examples{
data <- data.frame(
  x = c(1, 2, 2, 1, 2, 2),
  y = c(1, 2, 2, 2, 1, 1),
  time = c(1, 4, 10, 4, 8, 10),
  group = c(1, 1, 1, 2, 2, 2),
  ease = rep('cubic-in-out', 6)
)

data <- tween_elements(data, 'time', 'group', 'ease', nframes = 100)

}
\seealso{
Other data.frame tween: 
\code{\link{tween_along}()},
\code{\link{tween_appear}()},
\code{\link{tween_components}()},
\code{\link{tween_events}()},
\code{\link{tween_states}()}
}
\concept{data.frame tween}
