# 2025-05-04 Triage Log

A relatively noisy week due to addition of new benchmarks as part of our [2025
benchmark update], and a number of large regressions in a rollup landing late
in the week, with investigation [here](https://github.com/rust-lang/rust/pull/140652).

[2025 benchmark update]: https://github.com/rust-lang/rustc-perf/issues/2024

Triage done by **@simulacrum**.
Revision range: [25cdf1f6..62c5f58f](https://perf.rust-lang.org/?start=25cdf1f67463c9365d8d83778c933ec7480e940b&end=62c5f58f57670ce65e7fec34f8c4ba00c27da2d9&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.9%  | [0.2%, 14.4%]  | 47    |
| Regressions ❌ <br /> (secondary)  | 2.0%  | [0.1%, 11.8%]  | 156   |
| Improvements ✅ <br /> (primary)   | -0.6% | [-3.4%, -0.2%] | 34    |
| Improvements ✅ <br /> (secondary) | -1.6% | [-3.7%, -0.3%] | 20    |
| All ❌✅ (primary)                 | 0.9%  | [-3.4%, 14.4%] | 81    |

2 Regressions, 2 Improvements, 6 Mixed; 3 of them in rollups
31 artifact comparisons made in total

#### Regressions

Introduce Arena::try_alloc_from_iter. [#140023](https://github.com/rust-lang/rust/pull/140023) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=74509131e85a97353c67c503ea32e148a56cf4bd&end=0fbb922e530399599aab8296ea975cb9e7ed67bf&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.3%, 0.4%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.1%, 0.4%] | 15    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.3%, 0.4%] | 3     |

Regressions look plausibly real (they've held up for a bit) but given they're
small and limited to just doc builds I'm inclined to accept. It seems plausible
this is just some slight differences in the ABI of the functions here or
similar. Marking as triaged.

Set groundwork for proper const normalization [#140549](https://github.com/rust-lang/rust/pull/140549) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3559e0ab0e370b98bc3f9e6b688152c47eb9e6c8&end=1bea580f364c65bd5f7380a1056e150df7b8a1a6&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.3%, 1.4%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.1%, 0.6%] | 7     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.3%, 1.4%] | 3     |

Mostly what looks like inlining noise. See [comment](https://github.com/rust-lang/rust/pull/140549#issuecomment-2849664075)
for more details.

#### Improvements

perf: delay checking of `#[rustc_no_implicit_autorefs]` in autoref lint [#140406](https://github.com/rust-lang/rust/pull/140406) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7c96085b64580af5c5f619384f0e3f082138ff13&end=4824c2bb7445cb2478aab0190c268c939d77a0f6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.2% | [-3.4%, -0.2%] | 13    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 1     |
| All ❌✅ (primary)                 | -1.2% | [-3.4%, -0.2%] | 13    |

Use a closure instead of three chained iterators [#140464](https://github.com/rust-lang/rust/pull/140464) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5fe04cbebd593c6530a21cd7bd0e8e9503b1ffe4&end=d7df5bdf2986e596aeaeec38e732711c69ebbce1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.6%, -0.2%] | 13    |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 2     |
| All ❌✅ (primary)                 | -0.3% | [-0.6%, -0.2%] | 13    |

#### Mixed

Rollup of 7 pull requests [#140474](https://github.com/rust-lang/rust/pull/140474) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=efcbb94dccbe0fcc1076f031f88332db4a6a2a52&end=74509131e85a97353c67c503ea32e148a56cf4bd&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.9% | [-2.9%, -2.9%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 2     |
| All ❌✅ (primary)                 | -1.3% | [-2.9%, 0.3%]  | 2     |

Regression is limited to unicode-normalization-0.1.19 and appears within noise
limit for that benchmark. Marking as triaged.

Simplify `LazyAttrTokenStream` [#127516](https://github.com/rust-lang/rust/pull/127516) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0fbb922e530399599aab8296ea975cb9e7ed67bf&end=f242d6c26cc6fc187257bd1be9590b4b39632425&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.3%, 0.8%]   | 7     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -2.1% | [-4.0%, -1.4%] | 16    |
| All ❌✅ (primary)                 | -     | -              | 0     |

> Improvements outweigh regressions, and all the movement is in secondary benchmarks.

Streamline the `format` macro. [#140188](https://github.com/rust-lang/rust/pull/140188) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f242d6c26cc6fc187257bd1be9590b4b39632425&end=427288b3ce2d574847fdb41cc3184c893750e09a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 1.8%  | [1.7%, 1.9%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.1%] | 10    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.2% | [-0.4%, 0.2%]  | 11    |

> The improvements on primary benchmarks were deemed to outweigh the regressions on secondary benchmarks.

shared-generics: Do not share instantiations that contain local-only types [#138522](https://github.com/rust-lang/rust/pull/138522) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6e23095adf9209614a45f7f75fea36dad7b92afb&end=0e517d38ad0e72f93c734b14fabd4bb9b7441de6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.4%, 1.5%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.7%, -0.3%] | 6     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.0%, -1.0%] | 1     |
| All ❌✅ (primary)                 | -0.0% | [-0.7%, 1.5%]  | 9     |

> Marking perf as triaged. There's some improvements, some regressions, but the
> regressions look like potentially bimodality -- and where they're possibly
> real hard to justify further digging in. The change seems overall a slight
> improvement on our benchmarks.

Rollup of 9 pull requests [#140596](https://github.com/rust-lang/rust/pull/140596) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4824c2bb7445cb2478aab0190c268c939d77a0f6&end=2d5ffc513f1c56b7bc95bacb2519705096e8cc2b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 0.5%]   | 2     |
| Improvements ✅ <br /> (primary)   | -1.2% | [-1.2%, -1.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.2% | [-1.2%, -1.2%] | 1     |

Regression triaged. Regressions look like bimodality/noise, not worth further follow up.

Rollup of 7 pull requests [#140633](https://github.com/rust-lang/rust/pull/140633) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1bea580f364c65bd5f7380a1056e150df7b8a1a6&end=622ac043764d5d4ffff8de8cf86a1cc938a8a71b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2%  | [0.2%, 13.4%]  | 77    |
| Regressions ❌ <br /> (secondary)  | 1.9%  | [0.2%, 11.0%]  | 155   |
| Improvements ✅ <br /> (primary)   | -1.5% | [-1.5%, -1.5%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 1.2%  | [-1.5%, 13.4%] | 78    |

Per investigation on the PR, the root cause is [#139675](https://github.com/rust-lang/rust/pull/139675). Per discussion [here](https://github.com/rust-lang/rust/pull/140652) we expect that this will be mostly resolved in our next LLVM bump, but is likely an acceptable regression in the meantime (primarily to very short compiles) for the feature in question.
