/* WARNING: THIS FILE IS GENERATED - DO NOT PATCH!
   It's not enough alone in any case, because the defaults may be
   coming from the individual *-settings.c in some situations. If you
   wish to modify defaults, change the other *-settings.c files and
   just delete this file. This file will be automatically regenerated
   by make. (This file is distributed in the tarball only because some
   systems might not have Perl installed.) */
#include "lib.h"
#include "array.h"
#include "str.h"
#include "ipwd.h"
#include "env-util.h"
#include "var-expand.h"
#include "file-lock.h"
#include "fsync-mode.h"
#include "hash-format.h"
#include "net.h"
#include "unichar.h"
#include "hash-method.h"
#include "settings.h"
#include "message-header-parser.h"
#include "rfc2822.h"
#include "urn.h"
#include "sieve-common.h"
#include "sieve-limits.h"
#include "sieve-address-source.h"
#include "managesieve-url.h"
#include "sieve-extprograms-limits.h"
#include "pigeonhole-settings.h"
#include <unistd.h>
#ifdef LDAP_PLUGIN
#include <ldap.h>
#endif
#define CONFIG_BINARY
/* ../../../src/lib-sieve/plugins/duplicate/ext-duplicate-settings.h */
struct ext_duplicate_settings {
	pool_t pool;

	unsigned int default_period;
	unsigned int max_period;
};
/* ../../../src/lib-sieve/plugins/editheader/ext-editheader-settings.h */
struct ext_editheader_header_settings {
	pool_t pool;
	const char *name;

	bool forbid_add;
	bool forbid_delete;
};
struct ext_editheader_settings {
	pool_t pool;

	uoff_t max_header_size;
	ARRAY_TYPE(const_string) headers;
};
/* ../../../src/lib-sieve/plugins/extlists/ext-extlists-settings.h */

/* <settings checks> */
#define SIEVE_URN_PREFIX "urn:ietf:params:sieve"
#define SIEVE_URN_ADDRBOOK SIEVE_URN_PREFIX":addrbook"
#define SIEVE_URN_ADDRBOOK_DEFAULT SIEVE_URN_ADDRBOOK":default"
/* </settings checks> */

/* <settings checks> */
int ext_extlists_name_normalize(const char **name, const char **error_r);
/* </settings checks> */
struct ext_extlists_list_settings {
	pool_t pool;

	const char *name;
	/* Maximum size of lookup value */
	size_t max_lookup_size;

	struct {
		const char *name;
	} parsed;
};
struct ext_extlists_settings {
	pool_t pool;

	ARRAY_TYPE(const_string) lists;
};
/* ../../../src/lib-sieve/plugins/include/ext-include-settings.h */
struct ext_include_settings {
	pool_t pool;

	unsigned int max_nesting_depth;
	unsigned int max_includes;
};
/* ../../../src/lib-sieve/plugins/spamvirustest/ext-spamvirustest-settings.h */

/* <settings checks> */
enum ext_spamvirustest_status_type {
	EXT_SPAMVIRUSTEST_STATUS_TYPE_SCORE,
	EXT_SPAMVIRUSTEST_STATUS_TYPE_STRLEN,
	EXT_SPAMVIRUSTEST_STATUS_TYPE_TEXT,
};
/* </settings checks> */

/* <settings checks> */
bool ext_spamvirustest_parse_decimal_value(const char *str_value,
					   float *value_r,
					   const char **error_r);
/* </settings checks> */
struct ext_spamvirustest_settings {
	pool_t pool;

	const char *status_header;
	const char *status_type;
	const char *score_max_header;
	const char *score_max_value;

	ARRAY_TYPE(const_string) text_value;

	struct {
		enum ext_spamvirustest_status_type status_type;

		float score_max_value;

		const char *text_values[11];
	} parsed;
};
/* ../../../src/lib-sieve/plugins/subaddress/ext-subaddress-settings.h */
struct ext_subaddress_settings {
	pool_t pool;

	const char *recipient_delimiter;
};
/* ../../../src/lib-sieve/plugins/vacation/ext-vacation-settings.h */
struct ext_vacation_settings {
	pool_t pool;

	unsigned int min_period;
	unsigned int max_period;
	unsigned int default_period;

	const char *default_subject;
	const char *default_subject_template;

	bool use_original_recipient;
	bool check_recipient;
	bool send_from_recipient;
	bool to_header_ignore_envelope;
};
/* ../../../src/lib-sieve/plugins/variables/ext-variables-settings.h */
struct ext_variables_settings {
	pool_t pool;

	/* Maximum number of variables (in a scope) */
	unsigned int max_scope_count;
	/* Maximum size of variable value */
	uoff_t max_value_size;
};
/* ../../../src/lib-sieve/plugins/vnd.dovecot/environment/ext-vnd-environment-settings.h */
struct ext_vnd_environment_settings {
	pool_t pool;

	ARRAY_TYPE(const_string) envs;
};
/* ../../../src/lib-sieve/plugins/vnd.dovecot/report/ext-vnd-report-settings.h */
struct ext_report_settings {
	pool_t pool;

	const char *from;

	struct {
		struct sieve_address_source from;
	} parsed;
};
/* ../../../src/lib-sieve/sieve-settings.h */
struct sieve_settings {
	pool_t pool;

	bool enabled;

	uoff_t max_script_size;
	unsigned int max_actions;
	unsigned int max_redirects;
	unsigned int max_cpu_time;
	unsigned int resource_usage_timeout;

	const char* redirect_envelope_from;
	unsigned int redirect_duplicate_period;

	const char *user_email;
	const char *user_log_path;

	const char *trace_dir;
	const char *trace_level;
	bool trace_debug;
	bool trace_addresses;

	ARRAY_TYPE(const_string) plugins;
	const char *plugin_dir;

	ARRAY_TYPE(const_string) extensions;
	ARRAY_TYPE(const_string) global_extensions;
	ARRAY_TYPE(const_string) implicit_extensions;

	struct {
		struct sieve_address_source redirect_envelope_from;
		const struct smtp_address *user_email;
	} parsed;
};
/* ../../../src/lib-sieve/sieve-storage-settings.h */
struct sieve_storage_settings {
	pool_t pool;

	const char *script_storage;
	unsigned int script_precedence;

	const char *script_type;
	ARRAY_TYPE(const_string) script_cause;

	const char *script_driver;
	const char *script_name;
	const char *script_bin_path;

	uoff_t quota_storage_size;
	unsigned int quota_script_count;

	ARRAY_TYPE(const_string) storages;
};
/* ../../../src/lib-sieve/storage/dict/sieve-dict-storage-settings.h */
/* ../../../src/lib-sieve/storage/file/sieve-file-storage-settings.h */
#define SIEVE_FILE_DEFAULT_ACTIVE_PATH "~/.dovecot."SIEVE_SCRIPT_FILEEXT
struct sieve_file_storage_settings {
	pool_t pool;

	const char *script_path;
	const char *script_active_path;
};
/* ../../../src/lib-sieve/storage/ldap/sieve-ldap-storage-settings.h */
struct sieve_ldap_settings {
	pool_t pool;

	const char *uris;
	const char *auth_dn;
	const char *auth_dn_password;

	bool starttls;
	ARRAY_TYPE(const_string) auth_sasl_mechanisms;
	const char *auth_sasl_realm;
	const char *auth_sasl_authz_id;

	const char *deref;
	const char *scope;
	const char *base;
	unsigned int version;

	unsigned int debug_level;

	/* ... */
	struct {
		int deref, scope, tls_require_cert;
	} parsed;
};
struct sieve_ldap_storage_settings {
	pool_t pool;

	const char *script_attribute;
	const char *modified_attribute;
	const char *filter;
};
/* ../../../src/lib-sieve/plugins/enotify/mailto/ntfy-mailto-settings.h */
struct ntfy_mailto_settings {
	pool_t pool;

	const char *envelope_from;

	struct {
		struct sieve_address_source envelope_from;
	} parsed;
};
/* ../../../src/plugins/imapsieve/imap-sieve-settings.h */
struct imap_sieve_settings {
	pool_t pool;

	const char *url;
	bool expunge_discarded;

	ARRAY_TYPE(const_string) from;
	const char *from_name;
};
/* ../../../src/plugins/sieve-extprograms/sieve-extprograms-settings.h */

/* <settings checks> */
enum sieve_extprograms_eol {
	SIEVE_EXTPROGRAMS_EOL_CRLF = 0,
	SIEVE_EXTPROGRAMS_EOL_LF
};
/* </settings checks> */
struct sieve_extprograms_settings {
	pool_t pool;

	const char *bin_dir;
	const char *socket_dir;
	const char *input_eol;

	unsigned int exec_timeout;

	struct {
		enum sieve_extprograms_eol input_eol;
	} parsed;
};
/* ../../../src/lib-sieve/plugins/enotify/mailto/ntfy-mailto-settings.c */
extern const struct setting_parser_info ntfy_mailto_setting_parser_info;

/* <settings checks> */
static bool
ntfy_mailto_settings_check(void *_set, pool_t pool, const char **error_r)
{
	struct ntfy_mailto_settings *set = _set;

	if (!sieve_address_source_parse(pool, set->envelope_from,
					&set->parsed.envelope_from)) {
		*error_r = t_strdup_printf("sieve_notify_mailto_envelope_from: "
					   "Invalid address source '%s'",
					   set->envelope_from);
		return FALSE;
	}

	return TRUE;
}
/* </settings checks> */
#undef DEF
#define DEF(type, name) \
	SETTING_DEFINE_STRUCT_##type("sieve_notify_mailto_"#name, name, \
				     struct ntfy_mailto_settings)
static const struct setting_define ntfy_mailto_setting_defines[] = {
	DEF(STR, envelope_from),

	SETTING_DEFINE_LIST_END,
};
static const struct ntfy_mailto_settings ntfy_mailto_default_settings = {
	.envelope_from = "",
};
const struct setting_parser_info ntfy_mailto_setting_parser_info = {
	.name = "sieve_notify_mailto",

	.defines = ntfy_mailto_setting_defines,
	.defaults = &ntfy_mailto_default_settings,

	.struct_size = sizeof(struct ntfy_mailto_settings),

	.check_func = ntfy_mailto_settings_check,

	.pool_offset1 = 1 + offsetof(struct ntfy_mailto_settings, pool),
};
/* ../../../src/plugins/imapsieve/imap-sieve-settings.c */
extern const struct setting_parser_info imap_sieve_setting_parser_info;

/* <settings checks> */
static bool
imap_sieve_settings_check(void *_set, pool_t pool ATTR_UNUSED,
			  const char **error_r)
{
	struct imap_sieve_settings *set = _set;
	const char *error;

	if (*set->url != '\0' &&
	    managesieve_url_parse(set->url, 0, pool_datastack_create(),
				  NULL, &error) < 0) {
		*error_r = t_strdup_printf(
			"Invalid URL for imapsieve_url setting: %s",
			set->url);
		return FALSE;
	}

	return TRUE;
}
/* </settings checks> */
#undef DEF
#define DEF(type, name) \
	SETTING_DEFINE_STRUCT_##type("imapsieve_"#name, name, \
				     struct imap_sieve_settings)
static const struct setting_define imap_sieve_setting_defines[] = {
	DEF(STR, url),
	DEF(BOOL, expunge_discarded),

	{ .type = SET_FILTER_ARRAY, .key = "imapsieve_from",
	   .offset = offsetof(struct imap_sieve_settings, from),
	   .filter_array_field_name = "imapsieve_from_name" },
	DEF(STR, from_name),

	SETTING_DEFINE_LIST_END,
};
static const struct imap_sieve_settings imap_sieve_default_settings = {
	.url = "",
	.expunge_discarded = FALSE,

	.from = ARRAY_INIT,
	.from_name = "",
};
const struct setting_parser_info imap_sieve_setting_parser_info = {
	.name = "imapsieve",

	.defines = imap_sieve_setting_defines,
	.defaults = &imap_sieve_default_settings,

	.struct_size = sizeof(struct imap_sieve_settings),

	.check_func = imap_sieve_settings_check,

	.pool_offset1 = 1 + offsetof(struct imap_sieve_settings, pool),
};
/* ../../../src/plugins/sieve-extprograms/sieve-extprograms-settings.c */
extern const struct setting_parser_info sieve_ext_vnd_pipe_setting_parser_info;
extern const struct setting_parser_info sieve_ext_vnd_filter_setting_parser_info;
extern const struct setting_parser_info sieve_ext_vnd_execute_setting_parser_info;

/* <settings checks> */
static bool
sieve_extprograms_settings_check(void *_set, pool_t pool ATTR_UNUSED,
				 const char **error_r ATTR_UNUSED)
{
	struct sieve_extprograms_settings *set = _set;

	if (strcasecmp(set->input_eol, "crlf") == 0)
		set->parsed.input_eol = SIEVE_EXTPROGRAMS_EOL_CRLF;
	else if (strcasecmp(set->input_eol, "lf") == 0)
		set->parsed.input_eol = SIEVE_EXTPROGRAMS_EOL_LF;
	else
		i_unreached();
	return TRUE;
}
/* </settings checks> */
#undef DEF
#define DEF(type, name) \
	SETTING_DEFINE_STRUCT_##type("sieve_pipe_"#name, name, \
				     struct sieve_extprograms_settings)
static const struct setting_define ext_pipe_setting_defines[] = {
	DEF(STR, bin_dir),
	DEF(STR, socket_dir),
	DEF(ENUM, input_eol),

	DEF(TIME, exec_timeout),

	SETTING_DEFINE_LIST_END,
};
#undef DEF
#define DEF(type, name) \
	SETTING_DEFINE_STRUCT_##type("sieve_filter_"#name, name, \
				     struct sieve_extprograms_settings)
static const struct setting_define ext_filter_setting_defines[] = {
	DEF(STR, bin_dir),
	DEF(STR, socket_dir),
	DEF(ENUM, input_eol),

	DEF(TIME, exec_timeout),

	SETTING_DEFINE_LIST_END,
};
#undef DEF
#define DEF(type, name) \
	SETTING_DEFINE_STRUCT_##type("sieve_execute_"#name, name, \
				     struct sieve_extprograms_settings)
static const struct setting_define ext_execute_setting_defines[] = {
	DEF(STR, bin_dir),
	DEF(STR, socket_dir),
	DEF(ENUM, input_eol),

	DEF(TIME, exec_timeout),

	SETTING_DEFINE_LIST_END,
};
static const struct sieve_extprograms_settings sieve_extprograms_default_settings = {
	.bin_dir = "",
	.socket_dir = "",
	.input_eol = "crlf:lf",
	.exec_timeout = 10,
};
const struct setting_parser_info sieve_ext_vnd_pipe_setting_parser_info = {
	.name = "sieve_ext_pipe",

	.defines = ext_pipe_setting_defines,
	.defaults = &sieve_extprograms_default_settings,

	.struct_size = sizeof(struct sieve_extprograms_settings),

	.check_func = sieve_extprograms_settings_check,

	.pool_offset1 = 1 + offsetof(struct sieve_extprograms_settings, pool),
};
const struct setting_parser_info sieve_ext_vnd_filter_setting_parser_info = {
	.name = "sieve_ext_filter",

	.defines = ext_filter_setting_defines,
	.defaults = &sieve_extprograms_default_settings,

	.struct_size = sizeof(struct sieve_extprograms_settings),

	.check_func = sieve_extprograms_settings_check,

	.pool_offset1 = 1 + offsetof(struct sieve_extprograms_settings, pool),
};
const struct setting_parser_info sieve_ext_vnd_execute_setting_parser_info = {
	.name = "sieve_ext_execute",

	.defines = ext_execute_setting_defines,
	.defaults = &sieve_extprograms_default_settings,

	.struct_size = sizeof(struct sieve_extprograms_settings),

	.check_func = sieve_extprograms_settings_check,

	.pool_offset1 = 1 + offsetof(struct sieve_extprograms_settings, pool),
};
/* ../../../src/lib-sieve/plugins/duplicate/ext-duplicate-settings.c */
extern const struct setting_parser_info ext_duplicate_setting_parser_info;
/* ../../../src/lib-sieve/plugins/editheader/ext-editheader-settings.c */
extern const struct setting_parser_info ext_editheader_header_setting_parser_info;
extern const struct setting_parser_info ext_editheader_setting_parser_info;
/* ../../../src/lib-sieve/plugins/extlists/ext-extlists-settings.c */
extern const struct setting_parser_info ext_extlists_list_setting_parser_info;
extern const struct setting_parser_info ext_extlists_setting_parser_info;
/* ../../../src/lib-sieve/plugins/include/ext-include-settings.c */
extern const struct setting_parser_info ext_include_setting_parser_info;
/* ../../../src/lib-sieve/plugins/spamvirustest/ext-spamvirustest-settings.c */
extern const struct setting_parser_info ext_spamtest_setting_parser_info;
extern const struct setting_parser_info ext_virustest_setting_parser_info;
/* ../../../src/lib-sieve/plugins/subaddress/ext-subaddress-settings.c */
extern const struct setting_parser_info ext_subaddress_setting_parser_info;
/* ../../../src/lib-sieve/plugins/vacation/ext-vacation-settings.c */
extern const struct setting_parser_info ext_vacation_setting_parser_info;
/* ../../../src/lib-sieve/plugins/variables/ext-variables-settings.c */
extern const struct setting_parser_info ext_variables_setting_parser_info;
/* ../../../src/lib-sieve/plugins/vnd.dovecot/environment/ext-vnd-environment-settings.c */
extern const struct setting_parser_info ext_vnd_environment_setting_parser_info;
/* ../../../src/lib-sieve/plugins/vnd.dovecot/report/ext-vnd-report-settings.c */
extern const struct setting_parser_info ext_report_setting_parser_info;
/* ../../../src/lib-sieve/sieve-settings.c */
extern const struct setting_parser_info sieve_setting_parser_info;
/* ../../../src/lib-sieve/sieve-storage-settings.c */
extern const struct setting_parser_info sieve_storage_setting_parser_info;
/* ../../../src/lib-sieve/storage/dict/sieve-dict-storage-settings.c */
extern const struct setting_parser_info sieve_dict_storage_setting_parser_info;
/* ../../../src/lib-sieve/storage/file/sieve-file-storage-settings.c */
extern const struct setting_parser_info sieve_file_storage_setting_parser_info;
/* ../../../src/lib-sieve/storage/ldap/sieve-ldap-storage-settings.c */
extern const struct setting_parser_info sieve_ldap_setting_parser_info;
extern const struct setting_parser_info sieve_ldap_storage_setting_parser_info;
const struct setting_parser_info *pigeonhole_settings_set_infos[] = {

	&ext_duplicate_setting_parser_info,

	&ext_editheader_header_setting_parser_info,

	&ext_editheader_setting_parser_info,

	&ext_extlists_list_setting_parser_info,

	&ext_extlists_setting_parser_info,

	&ext_include_setting_parser_info,

	&ext_report_setting_parser_info,

	&ext_spamtest_setting_parser_info,

	&ext_subaddress_setting_parser_info,

	&ext_vacation_setting_parser_info,

	&ext_variables_setting_parser_info,

	&ext_virustest_setting_parser_info,

	&ext_vnd_environment_setting_parser_info,

	&imap_sieve_setting_parser_info,

	&ntfy_mailto_setting_parser_info,

	&sieve_dict_storage_setting_parser_info,

	&sieve_ext_vnd_execute_setting_parser_info,

	&sieve_ext_vnd_filter_setting_parser_info,

	&sieve_ext_vnd_pipe_setting_parser_info,

	&sieve_file_storage_setting_parser_info,
#ifdef STORAGE_LDAP
	&sieve_ldap_setting_parser_info,
#endif
#ifdef STORAGE_LDAP
	&sieve_ldap_storage_setting_parser_info,
#endif

	&sieve_setting_parser_info,

	&sieve_storage_setting_parser_info,
	NULL
};
