#!/usr/bin/env bats
# Test to check if the FUTURE config settings match
# those shown by ssh and sshd.

setup_file() {
    update-crypto-policies --set FUTURE
}

. ./openssh/shared

@test "FUTURE policy: Client Ciphers match expected" {
    assert_client_ciphers
}
@test "FUTURE policy: Client MACs match expected" {
    assert_client_macs
}
@test "FUTURE policy: Client KEX match expected" {
    assert_client_kex
}
@test "FUTURE policy: Client PubKey match expected" {
    assert_client_pubkey
}
@test "FUTURE policy: Client GSSAPIKex match expected" {
    assert_client_gssapikex
}
@test "FUTURE policy: Client HostBased match expected" {
    assert_client_hostbased
}
@test "FUTURE policy: Client CASignature match expected" {
    assert_client_casignature
}
@test "FUTURE policy: Client RSASize match expected" {
    assert_client_rsasize
}

@test "FUTURE policy: Server Ciphers match expected" {
    assert_server_ciphers
}
@test "FUTURE policy: Server MACs match expected" {
    assert_server_macs
}
@test "FUTURE policy: Server KEX match expected" {
    assert_server_kex
}
@test "FUTURE policy: Server PubKey match expected" {
    assert_server_pubkey
}
@test "FUTURE policy: Server GSSAPIKex match expected" {
    assert_server_gssapikex
}
@test "FUTURE policy: Server HostBased match expected" {
    assert_server_hostbased
}
@test "FUTURE policy: Server CASignature match expected" {
    assert_server_casignature
}
@test "FUTURE policy: Server RSASize match expected" {
    assert_server_rsasize
}

