// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// Generated by Fuzzlyn v2.7 on 2025-04-23 21:44:41
// Run on X64 Windows
// Seed: 3309115426102150651-vectort,vector128,vector256,vector512,x86aes,x86avx,x86avx2,x86avx512bw,x86avx512bwvl,x86avx512cd,x86avx512cdvl,x86avx512dq,x86avx512dqvl,x86avx512f,x86avx512fvl,x86avx512fx64,x86avx512vbmi,x86avx512vbmivl,x86bmi1,x86bmi1x64,x86bmi2,x86bmi2x64,x86fma,x86lzcnt,x86lzcntx64,x86pclmulqdq,x86popcnt,x86popcntx64,x86sse,x86ssex64,x86sse2,x86sse2x64,x86sse3,x86sse41,x86sse41x64,x86sse42,x86sse42x64,x86ssse3,x86x86base
// Reduced from 179.3 KiB to 1.4 KiB in 00:01:49
// Debug: Outputs <255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255>
// Release: Outputs <255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0>

using System.Runtime.Intrinsics;
using System.Runtime.Intrinsics.X86;
using Xunit;

public class C0
{
}

public class C1
{
    public Vector512<short> F4;
}

public class C2
{
    public Vector128<sbyte> F6;
}

public class Runtime_114978
{
    public static IRuntime s_rt;
	
	[Fact]
    public static void Problem()
    {
		if (Avx512BW.VL.IsSupported)
		{
			s_rt = new Runtime();
			var vr14 = new C1();
			var vr16 = new C1();
			var vr17 = (byte)0;
			var vr18 = Vector512.CreateScalar(vr17);
			var vr19 = new C2();
			var vr20 = new C0();
			var vr21 = M10(vr14, vr18, vr19, vr20);
			s_rt.AssertEqual(Vector512<byte>.AllBitsSet, vr21);
			var vr22 = new C2();
			var vr23 = new C0();
			var vr24 = M10(vr16, vr21, vr22, vr23);
			s_rt.AssertEqual(Vector512<byte>.AllBitsSet, vr24);
		}
    }

    public static Vector512<byte> M10(C1 argThis, Vector512<byte> arg0, C2 arg1, C0 arg2)
    {
        var vr3 = arg1.F6;
        var vr6 = arg1.F6;
        var vr0 = Avx512BW.VL.CompareLessThanOrEqual(vr3, vr6);
        var vr10 = (sbyte)1;
        var vr9 = Vector128.CreateScalar(vr10);
        if (Sse41.TestZ(vr0, vr9))
        {
            s_rt.AssertEqual(Vector512<short>.Zero, argThis.F4);
        }

        return Avx512BW.CompareEqual(arg0, arg0);
    }
}

public interface IRuntime
{
    void AssertEqual<T>(Vector512<T> value1, Vector512<T> value2);
}

public class Runtime : IRuntime
{
    public void AssertEqual<T>(Vector512<T> value1, Vector512<T> value2)
        => Assert.Equal(value1, value2);
}