C
C ------------------------------------------------------------------
C
      SUBROUTINE DMVPC(NBLOCK, BET, MAXJ, J, S, NUMBER, RESNRM,
     *     ORTHCF, RV)
C
      INTEGER NBLOCK, MAXJ, J, NUMBER
      DOUBLE PRECISION BET(NBLOCK,1), S(MAXJ,1), RESNRM(1),
     *     ORTHCF(1), RV(1)
C
C THIS SUBROUTINE COMPUTES THE NORM AND THE SMALLEST ELEMENT
C (IN ABSOLUTE VALUE) OF THE VECTOR BET*SJI, WHERE SJI
C IS AN NBLOCK VECTOR OF THE LAST NBLOCK ELEMENTS OF THE ITH
C EIGENVECTOR OF T.  THESE QUANTITIES ARE THE RESIDUAL NORM
C AND THE ORTHOGONALITY COEFFICIENT RESPECTIVELY FOR THE
C CORRESPONDING RITZ PAIR.  THE ORTHOGONALITY COEFFICIENT IS
C NORMALIZED TO ACCOUNT FOR THE LOCAL REORTHOGONALIZATION.
C
      INTEGER I, K, M
      DOUBLE PRECISION DDOT, DNRM2, DABS, DMIN1
C
      M = J - NBLOCK + 1
      DO 20 I=1,NUMBER
         DO 10 K=1,NBLOCK
            RV(K) = DDOT(NBLOCK,S(M,I),1,BET(K,1),NBLOCK)
            IF (K.EQ.1) ORTHCF(I) = DABS(RV(K))
            ORTHCF(I) = DMIN1(ORTHCF(I),DABS(RV(K)))
   10    CONTINUE
         RESNRM(I) = DNRM2(NBLOCK,RV,1)
   20 CONTINUE
      RETURN
      END
