/*
 * Copyright (C) 2001-2003 Juha Heinanen
 *
 * This file is part of Kamailio, a free SIP server.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Kamailio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * Kamailio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*! \file
 * \brief Parser :: Remote-party-id: header parser
 *
 * \ingroup parser
 */

#ifndef PARSE_RPID_H
#define PARSE_RPID_H

#include "msg_parser.h"


/*! \brief casting macro for accessing RPID body */
#define get_rpid(p_msg) ((struct to_body *)(p_msg)->rpid->parsed)


/*
 * RPID header field parser
 */
int parse_rpid_header(struct sip_msg *msg);

#endif /* PARSE_RPID_H */
