 /* autogenerated ./testvalgrind.py > testvalgrind.c */

#include <unistd.h>
#include <string.h>
#include <sys/random.h>
#include <valgrind/memcheck.h>
#include <mceliece.h>
#include <stdlib.h>
#include <assert.h>
#include <randombytes.h>

void secret(void *xv, long long xlen) {
    VALGRIND_MAKE_MEM_UNDEFINED(xv, xlen);
}

void public(void *xv, long long xlen) {
    VALGRIND_MAKE_MEM_DEFINED(xv, xlen);
}

void getrandom_wrapper(void *xv, long long xlen) {

    unsigned char *x = (unsigned char *) xv;

    while (xlen > 0) {
        long long todo = 1048576;
        if (xlen < 1048576) todo = xlen;
        todo = getrandom(x, todo, 0);
        if (todo < 1) {
            sleep(1);
            continue;
        }
        x += todo;
        xlen -= todo;
    }
}

void randombytes(void *xv, long long xlen) {
    getrandom_wrapper(xv, xlen);
    secret(xv, xlen);
}

static void *alloc(long long len) {
    unsigned char *x = malloc(len);
    assert(x);
    return x;
}


#define mceliece_kem_mustfail_PUBLICKEYBYTES 256
#define mceliece_kem_mustfail_SECRETKEYBYTES 256
#define mceliece_kem_mustfail_CIPHERTEXTBYTES 256
#define mceliece_kem_mustfail_BYTES 256

void mceliece_kem_mustfail_keypair(unsigned char *pk, unsigned char *sk) {

    long long i, j;

    randombytes(sk, 256);
    for (i = 0; i < 256; ++i) {
        for (j = 0; j < 256; ++j) {
            if (sk[i] == j) pk[i] = sk[i];
        }
    }
}

int mceliece_kem_mustfail_enc(unsigned char *c, unsigned char *k, const unsigned char *pk) {

    long long i;

    randombytes(c, 256);
    for (i = 0; i < 256; ++i) {
        k[i] = pk[c[i]];
    }
    return 0;
}

int mceliece_kem_mustfail_dec(unsigned char *k, const unsigned char *c, const unsigned char *sk) {

    long long i;

    for (i = 0; i < 256; ++i) {
        k[i] = sk[c[i]];
    }
    return 0;
}

long long mceliece_numimpl_kem_mustfail(void) {
    return 1;
}
void (*mceliece_dispatch_kem_mustfail_keypair(long long i))(unsigned char *, unsigned char *) {
    (void) i;
    return  mceliece_kem_mustfail_keypair;
}
int (*mceliece_dispatch_kem_mustfail_enc(long long i))(unsigned char *, unsigned char *, const unsigned char *) {
    (void) i;
    return  mceliece_kem_mustfail_enc;
}
int (*mceliece_dispatch_kem_mustfail_dec(long long i))(unsigned char *, const unsigned char *, const unsigned char *) {
    (void) i;
    return  mceliece_kem_mustfail_dec;
}
const char *mceliece_dispatch_kem_mustfail_implementation(long long i) {
    (void) i;
    return "ref";
}
const char *mceliece_kem_mustfail_implementation(void) {
    return "ref";
}

void test_mustfail(const char *name, const char *implname) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *) = 0;
    int (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *) = 0;
    int (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *) = 0;
    long long pklen = mceliece_kem_mustfail_PUBLICKEYBYTES;
    long long sklen = mceliece_kem_mustfail_SECRETKEYBYTES;
    long long clen =  mceliece_kem_mustfail_CIPHERTEXTBYTES;
    long long klen = mceliece_kem_mustfail_BYTES;
    unsigned char *pk, *sk, *c, *k1, *k2, *space;
    int result;

    if (strcmp(name, "mustfail")) return;

    space = alloc(pklen + sklen + clen + klen + klen);
    pk = space; space += pklen;
    sk = space; space += sklen;
    c = space; space += clen;
    k1 = space; space += klen;
    k2 = space; space += klen;

    for (long long impl = 0; impl < mceliece_numimpl_kem_mustfail(); ++impl) {
        if (!strcmp(implname, mceliece_dispatch_kem_mustfail_implementation(impl))) {
            crypto_kem_keypair = mceliece_dispatch_kem_mustfail_keypair(impl);
            crypto_kem_enc = mceliece_dispatch_kem_mustfail_enc(impl);
            crypto_kem_dec = mceliece_dispatch_kem_mustfail_dec(impl);
            break;
        }
    }
    if (!crypto_kem_keypair) exit(10);

    /* keypair */
    crypto_kem_keypair(pk, sk);
    public(pk, pklen);
    public(sk, sklen);

    /* enc */
    secret(pk, pklen);
    result = crypto_kem_enc(c, k1, pk);
    public(&result, sizeof result);
    assert(result == 0);
    public(c, clen);
    public(k1, klen);
    public(pk, pklen);

    /* dec */
    secret(sk, sklen);
    secret(c, clen);
    result = crypto_kem_dec(k2, c, sk);
    public(&result, sizeof result);
    assert(result == 0);
    public(k2, klen);
    public(sk, sklen);
    public(c, clen);

    assert(!memcmp(k1, k2, klen));
    exit(0);
}

void test_6960119(const char *name, const char *implname) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *) = 0;
    int (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *) = 0;
    int (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *) = 0;
    long long pklen = mceliece_kem_6960119_PUBLICKEYBYTES;
    long long sklen = mceliece_kem_6960119_SECRETKEYBYTES;
    long long clen =  mceliece_kem_6960119_CIPHERTEXTBYTES;
    long long klen = mceliece_kem_6960119_BYTES;
    unsigned char *pk, *sk, *c, *k1, *k2, *space;
    int result;

    if (strcmp(name, "6960119")) return;

    space = alloc(pklen + sklen + clen + klen + klen);
    pk = space; space += pklen;
    sk = space; space += sklen;
    c = space; space += clen;
    k1 = space; space += klen;
    k2 = space; space += klen;

    for (long long impl = 0; impl < mceliece_numimpl_kem_6960119(); ++impl) {
        if (!strcmp(implname, mceliece_dispatch_kem_6960119_implementation(impl))) {
            crypto_kem_keypair = mceliece_dispatch_kem_6960119_keypair(impl);
            crypto_kem_enc = mceliece_dispatch_kem_6960119_enc(impl);
            crypto_kem_dec = mceliece_dispatch_kem_6960119_dec(impl);
            break;
        }
    }
    if (!crypto_kem_keypair) exit(10);

    /* keypair */
    crypto_kem_keypair(pk, sk);
    public(pk, pklen);
    public(sk, sklen);

    /* enc */
    secret(pk, pklen);
    result = crypto_kem_enc(c, k1, pk);
    public(&result, sizeof result);
    assert(result == 0);
    public(c, clen);
    public(k1, klen);
    public(pk, pklen);

    /* dec */
    secret(sk, sklen);
    secret(c, clen);
    result = crypto_kem_dec(k2, c, sk);
    public(&result, sizeof result);
    assert(result == 0);
    public(k2, klen);
    public(sk, sklen);
    public(c, clen);

    assert(!memcmp(k1, k2, klen));
    exit(0);
}

void test_6960119f(const char *name, const char *implname) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *) = 0;
    int (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *) = 0;
    int (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *) = 0;
    long long pklen = mceliece_kem_6960119f_PUBLICKEYBYTES;
    long long sklen = mceliece_kem_6960119f_SECRETKEYBYTES;
    long long clen =  mceliece_kem_6960119f_CIPHERTEXTBYTES;
    long long klen = mceliece_kem_6960119f_BYTES;
    unsigned char *pk, *sk, *c, *k1, *k2, *space;
    int result;

    if (strcmp(name, "6960119f")) return;

    space = alloc(pklen + sklen + clen + klen + klen);
    pk = space; space += pklen;
    sk = space; space += sklen;
    c = space; space += clen;
    k1 = space; space += klen;
    k2 = space; space += klen;

    for (long long impl = 0; impl < mceliece_numimpl_kem_6960119f(); ++impl) {
        if (!strcmp(implname, mceliece_dispatch_kem_6960119f_implementation(impl))) {
            crypto_kem_keypair = mceliece_dispatch_kem_6960119f_keypair(impl);
            crypto_kem_enc = mceliece_dispatch_kem_6960119f_enc(impl);
            crypto_kem_dec = mceliece_dispatch_kem_6960119f_dec(impl);
            break;
        }
    }
    if (!crypto_kem_keypair) exit(10);

    /* keypair */
    crypto_kem_keypair(pk, sk);
    public(pk, pklen);
    public(sk, sklen);

    /* enc */
    secret(pk, pklen);
    result = crypto_kem_enc(c, k1, pk);
    public(&result, sizeof result);
    assert(result == 0);
    public(c, clen);
    public(k1, klen);
    public(pk, pklen);

    /* dec */
    secret(sk, sklen);
    secret(c, clen);
    result = crypto_kem_dec(k2, c, sk);
    public(&result, sizeof result);
    assert(result == 0);
    public(k2, klen);
    public(sk, sklen);
    public(c, clen);

    assert(!memcmp(k1, k2, klen));
    exit(0);
}

void test_6688128(const char *name, const char *implname) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *) = 0;
    int (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *) = 0;
    int (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *) = 0;
    long long pklen = mceliece_kem_6688128_PUBLICKEYBYTES;
    long long sklen = mceliece_kem_6688128_SECRETKEYBYTES;
    long long clen =  mceliece_kem_6688128_CIPHERTEXTBYTES;
    long long klen = mceliece_kem_6688128_BYTES;
    unsigned char *pk, *sk, *c, *k1, *k2, *space;
    int result;

    if (strcmp(name, "6688128")) return;

    space = alloc(pklen + sklen + clen + klen + klen);
    pk = space; space += pklen;
    sk = space; space += sklen;
    c = space; space += clen;
    k1 = space; space += klen;
    k2 = space; space += klen;

    for (long long impl = 0; impl < mceliece_numimpl_kem_6688128(); ++impl) {
        if (!strcmp(implname, mceliece_dispatch_kem_6688128_implementation(impl))) {
            crypto_kem_keypair = mceliece_dispatch_kem_6688128_keypair(impl);
            crypto_kem_enc = mceliece_dispatch_kem_6688128_enc(impl);
            crypto_kem_dec = mceliece_dispatch_kem_6688128_dec(impl);
            break;
        }
    }
    if (!crypto_kem_keypair) exit(10);

    /* keypair */
    crypto_kem_keypair(pk, sk);
    public(pk, pklen);
    public(sk, sklen);

    /* enc */
    secret(pk, pklen);
    result = crypto_kem_enc(c, k1, pk);
    public(&result, sizeof result);
    assert(result == 0);
    public(c, clen);
    public(k1, klen);
    public(pk, pklen);

    /* dec */
    secret(sk, sklen);
    secret(c, clen);
    result = crypto_kem_dec(k2, c, sk);
    public(&result, sizeof result);
    assert(result == 0);
    public(k2, klen);
    public(sk, sklen);
    public(c, clen);

    assert(!memcmp(k1, k2, klen));
    exit(0);
}

void test_6688128f(const char *name, const char *implname) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *) = 0;
    int (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *) = 0;
    int (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *) = 0;
    long long pklen = mceliece_kem_6688128f_PUBLICKEYBYTES;
    long long sklen = mceliece_kem_6688128f_SECRETKEYBYTES;
    long long clen =  mceliece_kem_6688128f_CIPHERTEXTBYTES;
    long long klen = mceliece_kem_6688128f_BYTES;
    unsigned char *pk, *sk, *c, *k1, *k2, *space;
    int result;

    if (strcmp(name, "6688128f")) return;

    space = alloc(pklen + sklen + clen + klen + klen);
    pk = space; space += pklen;
    sk = space; space += sklen;
    c = space; space += clen;
    k1 = space; space += klen;
    k2 = space; space += klen;

    for (long long impl = 0; impl < mceliece_numimpl_kem_6688128f(); ++impl) {
        if (!strcmp(implname, mceliece_dispatch_kem_6688128f_implementation(impl))) {
            crypto_kem_keypair = mceliece_dispatch_kem_6688128f_keypair(impl);
            crypto_kem_enc = mceliece_dispatch_kem_6688128f_enc(impl);
            crypto_kem_dec = mceliece_dispatch_kem_6688128f_dec(impl);
            break;
        }
    }
    if (!crypto_kem_keypair) exit(10);

    /* keypair */
    crypto_kem_keypair(pk, sk);
    public(pk, pklen);
    public(sk, sklen);

    /* enc */
    secret(pk, pklen);
    result = crypto_kem_enc(c, k1, pk);
    public(&result, sizeof result);
    assert(result == 0);
    public(c, clen);
    public(k1, klen);
    public(pk, pklen);

    /* dec */
    secret(sk, sklen);
    secret(c, clen);
    result = crypto_kem_dec(k2, c, sk);
    public(&result, sizeof result);
    assert(result == 0);
    public(k2, klen);
    public(sk, sklen);
    public(c, clen);

    assert(!memcmp(k1, k2, klen));
    exit(0);
}

void test_8192128(const char *name, const char *implname) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *) = 0;
    int (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *) = 0;
    int (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *) = 0;
    long long pklen = mceliece_kem_8192128_PUBLICKEYBYTES;
    long long sklen = mceliece_kem_8192128_SECRETKEYBYTES;
    long long clen =  mceliece_kem_8192128_CIPHERTEXTBYTES;
    long long klen = mceliece_kem_8192128_BYTES;
    unsigned char *pk, *sk, *c, *k1, *k2, *space;
    int result;

    if (strcmp(name, "8192128")) return;

    space = alloc(pklen + sklen + clen + klen + klen);
    pk = space; space += pklen;
    sk = space; space += sklen;
    c = space; space += clen;
    k1 = space; space += klen;
    k2 = space; space += klen;

    for (long long impl = 0; impl < mceliece_numimpl_kem_8192128(); ++impl) {
        if (!strcmp(implname, mceliece_dispatch_kem_8192128_implementation(impl))) {
            crypto_kem_keypair = mceliece_dispatch_kem_8192128_keypair(impl);
            crypto_kem_enc = mceliece_dispatch_kem_8192128_enc(impl);
            crypto_kem_dec = mceliece_dispatch_kem_8192128_dec(impl);
            break;
        }
    }
    if (!crypto_kem_keypair) exit(10);

    /* keypair */
    crypto_kem_keypair(pk, sk);
    public(pk, pklen);
    public(sk, sklen);

    /* enc */
    secret(pk, pklen);
    result = crypto_kem_enc(c, k1, pk);
    public(&result, sizeof result);
    assert(result == 0);
    public(c, clen);
    public(k1, klen);
    public(pk, pklen);

    /* dec */
    secret(sk, sklen);
    secret(c, clen);
    result = crypto_kem_dec(k2, c, sk);
    public(&result, sizeof result);
    assert(result == 0);
    public(k2, klen);
    public(sk, sklen);
    public(c, clen);

    assert(!memcmp(k1, k2, klen));
    exit(0);
}

void test_8192128f(const char *name, const char *implname) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *) = 0;
    int (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *) = 0;
    int (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *) = 0;
    long long pklen = mceliece_kem_8192128f_PUBLICKEYBYTES;
    long long sklen = mceliece_kem_8192128f_SECRETKEYBYTES;
    long long clen =  mceliece_kem_8192128f_CIPHERTEXTBYTES;
    long long klen = mceliece_kem_8192128f_BYTES;
    unsigned char *pk, *sk, *c, *k1, *k2, *space;
    int result;

    if (strcmp(name, "8192128f")) return;

    space = alloc(pklen + sklen + clen + klen + klen);
    pk = space; space += pklen;
    sk = space; space += sklen;
    c = space; space += clen;
    k1 = space; space += klen;
    k2 = space; space += klen;

    for (long long impl = 0; impl < mceliece_numimpl_kem_8192128f(); ++impl) {
        if (!strcmp(implname, mceliece_dispatch_kem_8192128f_implementation(impl))) {
            crypto_kem_keypair = mceliece_dispatch_kem_8192128f_keypair(impl);
            crypto_kem_enc = mceliece_dispatch_kem_8192128f_enc(impl);
            crypto_kem_dec = mceliece_dispatch_kem_8192128f_dec(impl);
            break;
        }
    }
    if (!crypto_kem_keypair) exit(10);

    /* keypair */
    crypto_kem_keypair(pk, sk);
    public(pk, pklen);
    public(sk, sklen);

    /* enc */
    secret(pk, pklen);
    result = crypto_kem_enc(c, k1, pk);
    public(&result, sizeof result);
    assert(result == 0);
    public(c, clen);
    public(k1, klen);
    public(pk, pklen);

    /* dec */
    secret(sk, sklen);
    secret(c, clen);
    result = crypto_kem_dec(k2, c, sk);
    public(&result, sizeof result);
    assert(result == 0);
    public(k2, klen);
    public(sk, sklen);
    public(c, clen);

    assert(!memcmp(k1, k2, klen));
    exit(0);
}

void test_460896(const char *name, const char *implname) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *) = 0;
    int (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *) = 0;
    int (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *) = 0;
    long long pklen = mceliece_kem_460896_PUBLICKEYBYTES;
    long long sklen = mceliece_kem_460896_SECRETKEYBYTES;
    long long clen =  mceliece_kem_460896_CIPHERTEXTBYTES;
    long long klen = mceliece_kem_460896_BYTES;
    unsigned char *pk, *sk, *c, *k1, *k2, *space;
    int result;

    if (strcmp(name, "460896")) return;

    space = alloc(pklen + sklen + clen + klen + klen);
    pk = space; space += pklen;
    sk = space; space += sklen;
    c = space; space += clen;
    k1 = space; space += klen;
    k2 = space; space += klen;

    for (long long impl = 0; impl < mceliece_numimpl_kem_460896(); ++impl) {
        if (!strcmp(implname, mceliece_dispatch_kem_460896_implementation(impl))) {
            crypto_kem_keypair = mceliece_dispatch_kem_460896_keypair(impl);
            crypto_kem_enc = mceliece_dispatch_kem_460896_enc(impl);
            crypto_kem_dec = mceliece_dispatch_kem_460896_dec(impl);
            break;
        }
    }
    if (!crypto_kem_keypair) exit(10);

    /* keypair */
    crypto_kem_keypair(pk, sk);
    public(pk, pklen);
    public(sk, sklen);

    /* enc */
    secret(pk, pklen);
    result = crypto_kem_enc(c, k1, pk);
    public(&result, sizeof result);
    assert(result == 0);
    public(c, clen);
    public(k1, klen);
    public(pk, pklen);

    /* dec */
    secret(sk, sklen);
    secret(c, clen);
    result = crypto_kem_dec(k2, c, sk);
    public(&result, sizeof result);
    assert(result == 0);
    public(k2, klen);
    public(sk, sklen);
    public(c, clen);

    assert(!memcmp(k1, k2, klen));
    exit(0);
}

void test_460896f(const char *name, const char *implname) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *) = 0;
    int (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *) = 0;
    int (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *) = 0;
    long long pklen = mceliece_kem_460896f_PUBLICKEYBYTES;
    long long sklen = mceliece_kem_460896f_SECRETKEYBYTES;
    long long clen =  mceliece_kem_460896f_CIPHERTEXTBYTES;
    long long klen = mceliece_kem_460896f_BYTES;
    unsigned char *pk, *sk, *c, *k1, *k2, *space;
    int result;

    if (strcmp(name, "460896f")) return;

    space = alloc(pklen + sklen + clen + klen + klen);
    pk = space; space += pklen;
    sk = space; space += sklen;
    c = space; space += clen;
    k1 = space; space += klen;
    k2 = space; space += klen;

    for (long long impl = 0; impl < mceliece_numimpl_kem_460896f(); ++impl) {
        if (!strcmp(implname, mceliece_dispatch_kem_460896f_implementation(impl))) {
            crypto_kem_keypair = mceliece_dispatch_kem_460896f_keypair(impl);
            crypto_kem_enc = mceliece_dispatch_kem_460896f_enc(impl);
            crypto_kem_dec = mceliece_dispatch_kem_460896f_dec(impl);
            break;
        }
    }
    if (!crypto_kem_keypair) exit(10);

    /* keypair */
    crypto_kem_keypair(pk, sk);
    public(pk, pklen);
    public(sk, sklen);

    /* enc */
    secret(pk, pklen);
    result = crypto_kem_enc(c, k1, pk);
    public(&result, sizeof result);
    assert(result == 0);
    public(c, clen);
    public(k1, klen);
    public(pk, pklen);

    /* dec */
    secret(sk, sklen);
    secret(c, clen);
    result = crypto_kem_dec(k2, c, sk);
    public(&result, sizeof result);
    assert(result == 0);
    public(k2, klen);
    public(sk, sklen);
    public(c, clen);

    assert(!memcmp(k1, k2, klen));
    exit(0);
}

void test_348864(const char *name, const char *implname) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *) = 0;
    int (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *) = 0;
    int (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *) = 0;
    long long pklen = mceliece_kem_348864_PUBLICKEYBYTES;
    long long sklen = mceliece_kem_348864_SECRETKEYBYTES;
    long long clen =  mceliece_kem_348864_CIPHERTEXTBYTES;
    long long klen = mceliece_kem_348864_BYTES;
    unsigned char *pk, *sk, *c, *k1, *k2, *space;
    int result;

    if (strcmp(name, "348864")) return;

    space = alloc(pklen + sklen + clen + klen + klen);
    pk = space; space += pklen;
    sk = space; space += sklen;
    c = space; space += clen;
    k1 = space; space += klen;
    k2 = space; space += klen;

    for (long long impl = 0; impl < mceliece_numimpl_kem_348864(); ++impl) {
        if (!strcmp(implname, mceliece_dispatch_kem_348864_implementation(impl))) {
            crypto_kem_keypair = mceliece_dispatch_kem_348864_keypair(impl);
            crypto_kem_enc = mceliece_dispatch_kem_348864_enc(impl);
            crypto_kem_dec = mceliece_dispatch_kem_348864_dec(impl);
            break;
        }
    }
    if (!crypto_kem_keypair) exit(10);

    /* keypair */
    crypto_kem_keypair(pk, sk);
    public(pk, pklen);
    public(sk, sklen);

    /* enc */
    secret(pk, pklen);
    result = crypto_kem_enc(c, k1, pk);
    public(&result, sizeof result);
    assert(result == 0);
    public(c, clen);
    public(k1, klen);
    public(pk, pklen);

    /* dec */
    secret(sk, sklen);
    secret(c, clen);
    result = crypto_kem_dec(k2, c, sk);
    public(&result, sizeof result);
    assert(result == 0);
    public(k2, klen);
    public(sk, sklen);
    public(c, clen);

    assert(!memcmp(k1, k2, klen));
    exit(0);
}

void test_348864f(const char *name, const char *implname) {
    void (*crypto_kem_keypair)(unsigned char *,unsigned char *) = 0;
    int (*crypto_kem_enc)(unsigned char *,unsigned char *,const unsigned char *) = 0;
    int (*crypto_kem_dec)(unsigned char *,const unsigned char *,const unsigned char *) = 0;
    long long pklen = mceliece_kem_348864f_PUBLICKEYBYTES;
    long long sklen = mceliece_kem_348864f_SECRETKEYBYTES;
    long long clen =  mceliece_kem_348864f_CIPHERTEXTBYTES;
    long long klen = mceliece_kem_348864f_BYTES;
    unsigned char *pk, *sk, *c, *k1, *k2, *space;
    int result;

    if (strcmp(name, "348864f")) return;

    space = alloc(pklen + sklen + clen + klen + klen);
    pk = space; space += pklen;
    sk = space; space += sklen;
    c = space; space += clen;
    k1 = space; space += klen;
    k2 = space; space += klen;

    for (long long impl = 0; impl < mceliece_numimpl_kem_348864f(); ++impl) {
        if (!strcmp(implname, mceliece_dispatch_kem_348864f_implementation(impl))) {
            crypto_kem_keypair = mceliece_dispatch_kem_348864f_keypair(impl);
            crypto_kem_enc = mceliece_dispatch_kem_348864f_enc(impl);
            crypto_kem_dec = mceliece_dispatch_kem_348864f_dec(impl);
            break;
        }
    }
    if (!crypto_kem_keypair) exit(10);

    /* keypair */
    crypto_kem_keypair(pk, sk);
    public(pk, pklen);
    public(sk, sklen);

    /* enc */
    secret(pk, pklen);
    result = crypto_kem_enc(c, k1, pk);
    public(&result, sizeof result);
    assert(result == 0);
    public(c, clen);
    public(k1, klen);
    public(pk, pklen);

    /* dec */
    secret(sk, sklen);
    secret(c, clen);
    result = crypto_kem_dec(k2, c, sk);
    public(&result, sizeof result);
    assert(result == 0);
    public(k2, klen);
    public(sk, sklen);
    public(c, clen);

    assert(!memcmp(k1, k2, klen));
    exit(0);
}

int main(int argc, char **argv) {

    assert(argc == 3);
    assert(argv[0]);
    assert(argv[1]);
    assert(argv[2]);

    test_mustfail(argv[1], argv[2]);
    test_6960119(argv[1], argv[2]);
    test_6960119f(argv[1], argv[2]);
    test_6688128(argv[1], argv[2]);
    test_6688128f(argv[1], argv[2]);
    test_8192128(argv[1], argv[2]);
    test_8192128f(argv[1], argv[2]);
    test_460896(argv[1], argv[2]);
    test_460896f(argv[1], argv[2]);
    test_348864(argv[1], argv[2]);
    test_348864f(argv[1], argv[2]);

    return 100;
}

