
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file CountSelectionTypeAttributes.h
    \\brief Definition of CountSelectionType Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "CountSelectionTypeWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



CountSelectionTypeWrapper::CountSelectionTypeWrapper(): countselectiontype_(new CountSelectionType())


{


	
	LevelSelectionWrapper::object(countselectiontype_);
	

}
CountSelectionTypeWrapper::CountSelectionTypeWrapper(CountSelectionType* countselectiontype): countselectiontype_(countselectiontype)
{

	
	LevelSelectionWrapper::object(countselectiontype_);
	
}

CountSelectionTypeWrapper::~CountSelectionTypeWrapper()
{

}

void CountSelectionTypeWrapper::set(const MagRequest& request)
{

	

	LevelSelectionWrapper::set(request);
	

	if  (request.countValues("CONTOUR_LEVEL_COUNT") ) {
		int levelCount_value = request("CONTOUR_LEVEL_COUNT");
		countselectiontype_->levelCount_ = levelCount_value;
		}
	if  (request.countValues("CONTOUR_LEVEL_TOLERANCE") ) {
		int tolerance_value = request("CONTOUR_LEVEL_TOLERANCE");
		countselectiontype_->tolerance_ = tolerance_value;
		}
	if  (request.countValues("CONTOUR_REFERENCE_LEVEL") ) {
		double reference_value = request("CONTOUR_REFERENCE_LEVEL");
		countselectiontype_->reference_ = reference_value;
		}
	
	
}

void CountSelectionTypeWrapper::print(ostream& out)  const
{
	out << "CountSelectionTypeWrapper[]";
}


