/*
 * Copyright 2021-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.events.api;

import org.apiguardian.api.API;
import org.opentest4j.reporting.schema.QualifiedName;

import static org.apiguardian.api.API.Status.EXPERIMENTAL;

/**
 * Base class for child elements with well-known parent types.
 *
 * @param <P> parent element type
 * @param <T> child element type
 * @since 0.1.0
 */
@API(status = EXPERIMENTAL, since = "0.1.0")
public class ChildElement<P extends Element<P>, T extends ChildElement<P, T>> extends Element<T> {

	/**
	 * Create an instance with the supplied {@linkplain Context context} and {@linkplain QualifiedName qualified name}.
	 *
	 * @param context       the context of this instance
	 * @param qualifiedName the qualified name of this instance
	 */
	public ChildElement(Context context, QualifiedName qualifiedName) {
		super(context, qualifiedName);
	}

}
