# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class Alias(_serialization.Model):
    """The alias type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The alias name.
    :vartype name: str
    :ivar paths: The paths for an alias.
    :vartype paths: list[~azure.mgmt.resource.policy.models.AliasPath]
    :ivar type: The type of the alias. Known values are: "NotSpecified", "PlainText", and "Mask".
    :vartype type: str or ~azure.mgmt.resource.policy.models.AliasType
    :ivar default_path: The default path for an alias.
    :vartype default_path: str
    :ivar default_pattern: The default pattern for an alias.
    :vartype default_pattern: ~azure.mgmt.resource.policy.models.AliasPattern
    :ivar default_metadata: The default alias path metadata. Applies to the default path and to any
     alias path that doesn't have metadata.
    :vartype default_metadata: ~azure.mgmt.resource.policy.models.AliasPathMetadata
    """

    _validation = {
        "default_metadata": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "paths": {"key": "paths", "type": "[AliasPath]"},
        "type": {"key": "type", "type": "str"},
        "default_path": {"key": "defaultPath", "type": "str"},
        "default_pattern": {"key": "defaultPattern", "type": "AliasPattern"},
        "default_metadata": {"key": "defaultMetadata", "type": "AliasPathMetadata"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        paths: Optional[list["_models.AliasPath"]] = None,
        type: Optional[Union[str, "_models.AliasType"]] = None,
        default_path: Optional[str] = None,
        default_pattern: Optional["_models.AliasPattern"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The alias name.
        :paramtype name: str
        :keyword paths: The paths for an alias.
        :paramtype paths: list[~azure.mgmt.resource.policy.models.AliasPath]
        :keyword type: The type of the alias. Known values are: "NotSpecified", "PlainText", and
         "Mask".
        :paramtype type: str or ~azure.mgmt.resource.policy.models.AliasType
        :keyword default_path: The default path for an alias.
        :paramtype default_path: str
        :keyword default_pattern: The default pattern for an alias.
        :paramtype default_pattern: ~azure.mgmt.resource.policy.models.AliasPattern
        """
        super().__init__(**kwargs)
        self.name = name
        self.paths = paths
        self.type = type
        self.default_path = default_path
        self.default_pattern = default_pattern
        self.default_metadata: Optional["_models.AliasPathMetadata"] = None


class AliasPath(_serialization.Model):
    """The type of the paths for alias.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar path: The path of an alias.
    :vartype path: str
    :ivar api_versions: The API versions.
    :vartype api_versions: list[str]
    :ivar pattern: The pattern for an alias path.
    :vartype pattern: ~azure.mgmt.resource.policy.models.AliasPattern
    :ivar metadata: The metadata of the alias path. If missing, fall back to the default metadata
     of the alias.
    :vartype metadata: ~azure.mgmt.resource.policy.models.AliasPathMetadata
    """

    _validation = {
        "metadata": {"readonly": True},
    }

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "api_versions": {"key": "apiVersions", "type": "[str]"},
        "pattern": {"key": "pattern", "type": "AliasPattern"},
        "metadata": {"key": "metadata", "type": "AliasPathMetadata"},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        api_versions: Optional[list[str]] = None,
        pattern: Optional["_models.AliasPattern"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: The path of an alias.
        :paramtype path: str
        :keyword api_versions: The API versions.
        :paramtype api_versions: list[str]
        :keyword pattern: The pattern for an alias path.
        :paramtype pattern: ~azure.mgmt.resource.policy.models.AliasPattern
        """
        super().__init__(**kwargs)
        self.path = path
        self.api_versions = api_versions
        self.pattern = pattern
        self.metadata: Optional["_models.AliasPathMetadata"] = None


class AliasPathMetadata(_serialization.Model):
    """AliasPathMetadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the token that the alias path is referring to. Known values are:
     "NotSpecified", "Any", "String", "Object", "Array", "Integer", "Number", and "Boolean".
    :vartype type: str or ~azure.mgmt.resource.policy.models.AliasPathTokenType
    :ivar attributes: The attributes of the token that the alias path is referring to. Known values
     are: "None" and "Modifiable".
    :vartype attributes: str or ~azure.mgmt.resource.policy.models.AliasPathAttributes
    """

    _validation = {
        "type": {"readonly": True},
        "attributes": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "attributes": {"key": "attributes", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[Union[str, "_models.AliasPathTokenType"]] = None
        self.attributes: Optional[Union[str, "_models.AliasPathAttributes"]] = None


class AliasPattern(_serialization.Model):
    """The type of the pattern for an alias path.

    :ivar phrase: The alias pattern phrase.
    :vartype phrase: str
    :ivar variable: The alias pattern variable.
    :vartype variable: str
    :ivar type: The type of alias pattern. Known values are: "NotSpecified" and "Extract".
    :vartype type: str or ~azure.mgmt.resource.policy.models.AliasPatternType
    """

    _attribute_map = {
        "phrase": {"key": "phrase", "type": "str"},
        "variable": {"key": "variable", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        phrase: Optional[str] = None,
        variable: Optional[str] = None,
        type: Optional[Union[str, "_models.AliasPatternType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword phrase: The alias pattern phrase.
        :paramtype phrase: str
        :keyword variable: The alias pattern variable.
        :paramtype variable: str
        :keyword type: The type of alias pattern. Known values are: "NotSpecified" and "Extract".
        :paramtype type: str or ~azure.mgmt.resource.policy.models.AliasPatternType
        """
        super().__init__(**kwargs)
        self.phrase = phrase
        self.variable = variable
        self.type = type


class DataEffect(_serialization.Model):
    """The data effect definition.

    :ivar name: The data effect name.
    :vartype name: str
    :ivar details_schema: The data effect details schema.
    :vartype details_schema: JSON
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "details_schema": {"key": "detailsSchema", "type": "object"},
    }

    def __init__(self, *, name: Optional[str] = None, details_schema: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword name: The data effect name.
        :paramtype name: str
        :keyword details_schema: The data effect details schema.
        :paramtype details_schema: JSON
        """
        super().__init__(**kwargs)
        self.name = name
        self.details_schema = details_schema


class DataManifestCustomResourceFunctionDefinition(_serialization.Model):  # pylint: disable=name-too-long
    """The custom resource function definition.

    :ivar name: The function name as it will appear in the policy rule. eg - 'vault'.
    :vartype name: str
    :ivar fully_qualified_resource_type: The fully qualified control plane resource type that this
     function represents. eg - 'Microsoft.KeyVault/vaults'.
    :vartype fully_qualified_resource_type: str
    :ivar default_properties: The top-level properties that can be selected on the function's
     output. eg - [ "name", "location" ] if vault().name and vault().location are supported.
    :vartype default_properties: list[str]
    :ivar allow_custom_properties: A value indicating whether the custom properties within the
     property bag are allowed. Needs api-version to be specified in the policy rule eg -
     vault('2019-06-01').
    :vartype allow_custom_properties: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "fully_qualified_resource_type": {"key": "fullyQualifiedResourceType", "type": "str"},
        "default_properties": {"key": "defaultProperties", "type": "[str]"},
        "allow_custom_properties": {"key": "allowCustomProperties", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        fully_qualified_resource_type: Optional[str] = None,
        default_properties: Optional[list[str]] = None,
        allow_custom_properties: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The function name as it will appear in the policy rule. eg - 'vault'.
        :paramtype name: str
        :keyword fully_qualified_resource_type: The fully qualified control plane resource type that
         this function represents. eg - 'Microsoft.KeyVault/vaults'.
        :paramtype fully_qualified_resource_type: str
        :keyword default_properties: The top-level properties that can be selected on the function's
         output. eg - [ "name", "location" ] if vault().name and vault().location are supported.
        :paramtype default_properties: list[str]
        :keyword allow_custom_properties: A value indicating whether the custom properties within the
         property bag are allowed. Needs api-version to be specified in the policy rule eg -
         vault('2019-06-01').
        :paramtype allow_custom_properties: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.fully_qualified_resource_type = fully_qualified_resource_type
        self.default_properties = default_properties
        self.allow_custom_properties = allow_custom_properties


class DataPolicyManifest(_serialization.Model):
    """The data policy manifest.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the data policy manifest.
    :vartype id: str
    :ivar name: The name of the data policy manifest (it's the same as the Policy Mode).
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/dataPolicyManifests).
    :vartype type: str
    :ivar namespaces: The list of namespaces for the data policy manifest.
    :vartype namespaces: list[str]
    :ivar policy_mode: The policy mode of the data policy manifest.
    :vartype policy_mode: str
    :ivar is_built_in_only: A value indicating whether policy mode is allowed only in built-in
     definitions.
    :vartype is_built_in_only: bool
    :ivar resource_type_aliases: An array of resource type aliases.
    :vartype resource_type_aliases: list[~azure.mgmt.resource.policy.models.ResourceTypeAliases]
    :ivar effects: The effect definition.
    :vartype effects: list[~azure.mgmt.resource.policy.models.DataEffect]
    :ivar field_values: The non-alias field accessor values that can be used in the policy rule.
    :vartype field_values: list[str]
    :ivar standard: The standard resource functions (subscription and/or resourceGroup).
    :vartype standard: list[str]
    :ivar custom: An array of data manifest custom resource definition.
    :vartype custom:
     list[~azure.mgmt.resource.policy.models.DataManifestCustomResourceFunctionDefinition]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "namespaces": {"key": "properties.namespaces", "type": "[str]"},
        "policy_mode": {"key": "properties.policyMode", "type": "str"},
        "is_built_in_only": {"key": "properties.isBuiltInOnly", "type": "bool"},
        "resource_type_aliases": {"key": "properties.resourceTypeAliases", "type": "[ResourceTypeAliases]"},
        "effects": {"key": "properties.effects", "type": "[DataEffect]"},
        "field_values": {"key": "properties.fieldValues", "type": "[str]"},
        "standard": {"key": "properties.resourceFunctions.standard", "type": "[str]"},
        "custom": {
            "key": "properties.resourceFunctions.custom",
            "type": "[DataManifestCustomResourceFunctionDefinition]",
        },
    }

    def __init__(
        self,
        *,
        namespaces: Optional[list[str]] = None,
        policy_mode: Optional[str] = None,
        is_built_in_only: Optional[bool] = None,
        resource_type_aliases: Optional[list["_models.ResourceTypeAliases"]] = None,
        effects: Optional[list["_models.DataEffect"]] = None,
        field_values: Optional[list[str]] = None,
        standard: Optional[list[str]] = None,
        custom: Optional[list["_models.DataManifestCustomResourceFunctionDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword namespaces: The list of namespaces for the data policy manifest.
        :paramtype namespaces: list[str]
        :keyword policy_mode: The policy mode of the data policy manifest.
        :paramtype policy_mode: str
        :keyword is_built_in_only: A value indicating whether policy mode is allowed only in built-in
         definitions.
        :paramtype is_built_in_only: bool
        :keyword resource_type_aliases: An array of resource type aliases.
        :paramtype resource_type_aliases: list[~azure.mgmt.resource.policy.models.ResourceTypeAliases]
        :keyword effects: The effect definition.
        :paramtype effects: list[~azure.mgmt.resource.policy.models.DataEffect]
        :keyword field_values: The non-alias field accessor values that can be used in the policy rule.
        :paramtype field_values: list[str]
        :keyword standard: The standard resource functions (subscription and/or resourceGroup).
        :paramtype standard: list[str]
        :keyword custom: An array of data manifest custom resource definition.
        :paramtype custom:
         list[~azure.mgmt.resource.policy.models.DataManifestCustomResourceFunctionDefinition]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.namespaces = namespaces
        self.policy_mode = policy_mode
        self.is_built_in_only = is_built_in_only
        self.resource_type_aliases = resource_type_aliases
        self.effects = effects
        self.field_values = field_values
        self.standard = standard
        self.custom = custom


class DataPolicyManifestListResult(_serialization.Model):
    """List of data policy manifests.

    :ivar value: An array of data policy manifests.
    :vartype value: list[~azure.mgmt.resource.policy.models.DataPolicyManifest]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DataPolicyManifest]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.DataPolicyManifest"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of data policy manifests.
        :paramtype value: list[~azure.mgmt.resource.policy.models.DataPolicyManifest]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.policy.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.resource.policy.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponse]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[list["_models.ErrorResponse"]] = None
        self.additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = None


class Identity(_serialization.Model):
    """Identity for the resource.  Policy assignments support a maximum of one identity.  That is
    either a system assigned identity or a single user assigned identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the resource identity.  This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the resource identity.  This property will only be provided
     for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The identity type. This is the only required field when adding a system or user
     assigned identity to a resource. Known values are: "SystemAssigned", "UserAssigned", and
     "None".
    :vartype type: str or ~azure.mgmt.resource.policy.models.ResourceIdentityType
    :ivar user_assigned_identities: The user identity associated with the policy. The user identity
     dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.resource.policy.models.UserAssignedIdentitiesValue]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentitiesValue}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentitiesValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The identity type. This is the only required field when adding a system or user
         assigned identity to a resource. Known values are: "SystemAssigned", "UserAssigned", and
         "None".
        :paramtype type: str or ~azure.mgmt.resource.policy.models.ResourceIdentityType
        :keyword user_assigned_identities: The user identity associated with the policy. The user
         identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.resource.policy.models.UserAssignedIdentitiesValue]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class NonComplianceMessage(_serialization.Model):
    """A message that describes why a resource is non-compliant with the policy. This is shown in
    'deny' error messages and on resource's non-compliant compliance results.

    All required parameters must be populated in order to send to server.

    :ivar message: A message that describes why a resource is non-compliant with the policy. This
     is shown in 'deny' error messages and on resource's non-compliant compliance results. Required.
    :vartype message: str
    :ivar policy_definition_reference_id: The policy definition reference ID within a policy set
     definition the message is intended for. This is only applicable if the policy assignment
     assigns a policy set definition. If this is not provided the message applies to all policies
     assigned by this policy assignment.
    :vartype policy_definition_reference_id: str
    """

    _validation = {
        "message": {"required": True},
    }

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "policy_definition_reference_id": {"key": "policyDefinitionReferenceId", "type": "str"},
    }

    def __init__(self, *, message: str, policy_definition_reference_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword message: A message that describes why a resource is non-compliant with the policy.
         This is shown in 'deny' error messages and on resource's non-compliant compliance results.
         Required.
        :paramtype message: str
        :keyword policy_definition_reference_id: The policy definition reference ID within a policy set
         definition the message is intended for. This is only applicable if the policy assignment
         assigns a policy set definition. If this is not provided the message applies to all policies
         assigned by this policy assignment.
        :paramtype policy_definition_reference_id: str
        """
        super().__init__(**kwargs)
        self.message = message
        self.policy_definition_reference_id = policy_definition_reference_id


class Override(_serialization.Model):
    """The policy property value override.

    :ivar kind: The override kind. "policyEffect"
    :vartype kind: str or ~azure.mgmt.resource.policy.models.OverrideKind
    :ivar value: The value to override the policy property.
    :vartype value: str
    :ivar selectors: The list of the selector expressions.
    :vartype selectors: list[~azure.mgmt.resource.policy.models.Selector]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "selectors": {"key": "selectors", "type": "[Selector]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.OverrideKind"]] = None,
        value: Optional[str] = None,
        selectors: Optional[list["_models.Selector"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The override kind. "policyEffect"
        :paramtype kind: str or ~azure.mgmt.resource.policy.models.OverrideKind
        :keyword value: The value to override the policy property.
        :paramtype value: str
        :keyword selectors: The list of the selector expressions.
        :paramtype selectors: list[~azure.mgmt.resource.policy.models.Selector]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.value = value
        self.selectors = selectors


class ParameterDefinitionsValue(_serialization.Model):
    """The definition of a parameter that can be provided to the policy.

    :ivar type: The data type of the parameter. Known values are: "String", "Array", "Object",
     "Boolean", "Integer", "Float", and "DateTime".
    :vartype type: str or ~azure.mgmt.resource.policy.models.ParameterType
    :ivar allowed_values: The allowed values for the parameter.
    :vartype allowed_values: list[JSON]
    :ivar default_value: The default value for the parameter if no value is provided.
    :vartype default_value: JSON
    :ivar schema: Provides validation of parameter inputs during assignment using a self-defined
     JSON schema. This property is only supported for object-type parameters and follows the
     Json.NET Schema 2019-09 implementation. You can learn more about using schemas at
     https://json-schema.org/ and test draft schemas at https://www.jsonschemavalidator.net/.
    :vartype schema: JSON
    :ivar metadata: General metadata for the parameter.
    :vartype metadata: ~azure.mgmt.resource.policy.models.ParameterDefinitionsValueMetadata
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "allowed_values": {"key": "allowedValues", "type": "[object]"},
        "default_value": {"key": "defaultValue", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "metadata": {"key": "metadata", "type": "ParameterDefinitionsValueMetadata"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ParameterType"]] = None,
        allowed_values: Optional[list[JSON]] = None,
        default_value: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        metadata: Optional["_models.ParameterDefinitionsValueMetadata"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The data type of the parameter. Known values are: "String", "Array", "Object",
         "Boolean", "Integer", "Float", and "DateTime".
        :paramtype type: str or ~azure.mgmt.resource.policy.models.ParameterType
        :keyword allowed_values: The allowed values for the parameter.
        :paramtype allowed_values: list[JSON]
        :keyword default_value: The default value for the parameter if no value is provided.
        :paramtype default_value: JSON
        :keyword schema: Provides validation of parameter inputs during assignment using a self-defined
         JSON schema. This property is only supported for object-type parameters and follows the
         Json.NET Schema 2019-09 implementation. You can learn more about using schemas at
         https://json-schema.org/ and test draft schemas at https://www.jsonschemavalidator.net/.
        :paramtype schema: JSON
        :keyword metadata: General metadata for the parameter.
        :paramtype metadata: ~azure.mgmt.resource.policy.models.ParameterDefinitionsValueMetadata
        """
        super().__init__(**kwargs)
        self.type = type
        self.allowed_values = allowed_values
        self.default_value = default_value
        self.schema = schema
        self.metadata = metadata


class ParameterDefinitionsValueMetadata(_serialization.Model):
    """General metadata for the parameter.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar display_name: The display name for the parameter.
    :vartype display_name: str
    :ivar description: The description of the parameter.
    :vartype description: str
    :ivar strong_type: Used when assigning the policy definition through the portal. Provides a
     context aware list of values for the user to choose from.
    :vartype strong_type: str
    :ivar assign_permissions: Set to true to have Azure portal create role assignments on the
     resource ID or resource scope value of this parameter during policy assignment. This property
     is useful in case you wish to assign permissions outside the assignment scope.
    :vartype assign_permissions: bool
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "strong_type": {"key": "strongType", "type": "str"},
        "assign_permissions": {"key": "assignPermissions", "type": "bool"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[dict[str, JSON]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        strong_type: Optional[str] = None,
        assign_permissions: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword display_name: The display name for the parameter.
        :paramtype display_name: str
        :keyword description: The description of the parameter.
        :paramtype description: str
        :keyword strong_type: Used when assigning the policy definition through the portal. Provides a
         context aware list of values for the user to choose from.
        :paramtype strong_type: str
        :keyword assign_permissions: Set to true to have Azure portal create role assignments on the
         resource ID or resource scope value of this parameter during policy assignment. This property
         is useful in case you wish to assign permissions outside the assignment scope.
        :paramtype assign_permissions: bool
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.display_name = display_name
        self.description = description
        self.strong_type = strong_type
        self.assign_permissions = assign_permissions


class ParameterValuesValue(_serialization.Model):
    """The value of a parameter.

    :ivar value: The value of the parameter.
    :vartype value: JSON
    """

    _attribute_map = {
        "value": {"key": "value", "type": "object"},
    }

    def __init__(self, *, value: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword value: The value of the parameter.
        :paramtype value: JSON
        """
        super().__init__(**kwargs)
        self.value = value


class PolicyAssignment(_serialization.Model):
    """The policy assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy assignment.
    :vartype id: str
    :ivar type: The type of the policy assignment.
    :vartype type: str
    :ivar name: The name of the policy assignment.
    :vartype name: str
    :ivar location: The location of the policy assignment. Only required when utilizing managed
     identity.
    :vartype location: str
    :ivar identity: The managed identity associated with the policy assignment.
    :vartype identity: ~azure.mgmt.resource.policy.models.Identity
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.resource.policy.models.SystemData
    :ivar display_name: The display name of the policy assignment.
    :vartype display_name: str
    :ivar policy_definition_id: The ID of the policy definition or policy set definition being
     assigned.
    :vartype policy_definition_id: str
    :ivar definition_version: The version of the policy definition to use.
    :vartype definition_version: str
    :ivar latest_definition_version: The latest version of the policy definition available. This is
     only present if requested via the $expand query parameter.
    :vartype latest_definition_version: str
    :ivar effective_definition_version: The effective version of the policy definition in use. This
     is only present if requested via the $expand query parameter.
    :vartype effective_definition_version: str
    :ivar scope: The scope for the policy assignment.
    :vartype scope: str
    :ivar not_scopes: The policy's excluded scopes.
    :vartype not_scopes: list[str]
    :ivar parameters: The parameter values for the assigned policy rule. The keys are the parameter
     names.
    :vartype parameters: dict[str, ~azure.mgmt.resource.policy.models.ParameterValuesValue]
    :ivar description: This message will be part of response in case of policy violation.
    :vartype description: str
    :ivar metadata: The policy assignment metadata. Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar enforcement_mode: The policy assignment enforcement mode. Possible values are Default and
     DoNotEnforce. Known values are: "Default" and "DoNotEnforce".
    :vartype enforcement_mode: str or ~azure.mgmt.resource.policy.models.EnforcementMode
    :ivar non_compliance_messages: The messages that describe why a resource is non-compliant with
     the policy.
    :vartype non_compliance_messages: list[~azure.mgmt.resource.policy.models.NonComplianceMessage]
    :ivar resource_selectors: The resource selector list to filter policies by resource properties.
    :vartype resource_selectors: list[~azure.mgmt.resource.policy.models.ResourceSelector]
    :ivar overrides: The policy property value override.
    :vartype overrides: list[~azure.mgmt.resource.policy.models.Override]
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "latest_definition_version": {"readonly": True},
        "effective_definition_version": {"readonly": True},
        "scope": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "policy_definition_id": {"key": "properties.policyDefinitionId", "type": "str"},
        "definition_version": {"key": "properties.definitionVersion", "type": "str"},
        "latest_definition_version": {"key": "properties.latestDefinitionVersion", "type": "str"},
        "effective_definition_version": {"key": "properties.effectiveDefinitionVersion", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "not_scopes": {"key": "properties.notScopes", "type": "[str]"},
        "parameters": {"key": "properties.parameters", "type": "{ParameterValuesValue}"},
        "description": {"key": "properties.description", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "enforcement_mode": {"key": "properties.enforcementMode", "type": "str"},
        "non_compliance_messages": {"key": "properties.nonComplianceMessages", "type": "[NonComplianceMessage]"},
        "resource_selectors": {"key": "properties.resourceSelectors", "type": "[ResourceSelector]"},
        "overrides": {"key": "properties.overrides", "type": "[Override]"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        identity: Optional["_models.Identity"] = None,
        display_name: Optional[str] = None,
        policy_definition_id: Optional[str] = None,
        definition_version: Optional[str] = None,
        not_scopes: Optional[list[str]] = None,
        parameters: Optional[dict[str, "_models.ParameterValuesValue"]] = None,
        description: Optional[str] = None,
        metadata: Optional[JSON] = None,
        enforcement_mode: Union[str, "_models.EnforcementMode"] = "Default",
        non_compliance_messages: Optional[list["_models.NonComplianceMessage"]] = None,
        resource_selectors: Optional[list["_models.ResourceSelector"]] = None,
        overrides: Optional[list["_models.Override"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the policy assignment. Only required when utilizing managed
         identity.
        :paramtype location: str
        :keyword identity: The managed identity associated with the policy assignment.
        :paramtype identity: ~azure.mgmt.resource.policy.models.Identity
        :keyword display_name: The display name of the policy assignment.
        :paramtype display_name: str
        :keyword policy_definition_id: The ID of the policy definition or policy set definition being
         assigned.
        :paramtype policy_definition_id: str
        :keyword definition_version: The version of the policy definition to use.
        :paramtype definition_version: str
        :keyword not_scopes: The policy's excluded scopes.
        :paramtype not_scopes: list[str]
        :keyword parameters: The parameter values for the assigned policy rule. The keys are the
         parameter names.
        :paramtype parameters: dict[str, ~azure.mgmt.resource.policy.models.ParameterValuesValue]
        :keyword description: This message will be part of response in case of policy violation.
        :paramtype description: str
        :keyword metadata: The policy assignment metadata. Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword enforcement_mode: The policy assignment enforcement mode. Possible values are Default
         and DoNotEnforce. Known values are: "Default" and "DoNotEnforce".
        :paramtype enforcement_mode: str or ~azure.mgmt.resource.policy.models.EnforcementMode
        :keyword non_compliance_messages: The messages that describe why a resource is non-compliant
         with the policy.
        :paramtype non_compliance_messages:
         list[~azure.mgmt.resource.policy.models.NonComplianceMessage]
        :keyword resource_selectors: The resource selector list to filter policies by resource
         properties.
        :paramtype resource_selectors: list[~azure.mgmt.resource.policy.models.ResourceSelector]
        :keyword overrides: The policy property value override.
        :paramtype overrides: list[~azure.mgmt.resource.policy.models.Override]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.type: Optional[str] = None
        self.name: Optional[str] = None
        self.location = location
        self.identity = identity
        self.system_data: Optional["_models.SystemData"] = None
        self.display_name = display_name
        self.policy_definition_id = policy_definition_id
        self.definition_version = definition_version
        self.latest_definition_version: Optional[str] = None
        self.effective_definition_version: Optional[str] = None
        self.scope: Optional[str] = None
        self.not_scopes = not_scopes
        self.parameters = parameters
        self.description = description
        self.metadata = metadata
        self.enforcement_mode = enforcement_mode
        self.non_compliance_messages = non_compliance_messages
        self.resource_selectors = resource_selectors
        self.overrides = overrides


class PolicyAssignmentListResult(_serialization.Model):
    """List of policy assignments.

    :ivar value: An array of policy assignments.
    :vartype value: list[~azure.mgmt.resource.policy.models.PolicyAssignment]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicyAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.PolicyAssignment"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of policy assignments.
        :paramtype value: list[~azure.mgmt.resource.policy.models.PolicyAssignment]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicyAssignmentUpdate(_serialization.Model):
    """The policy assignment for Patch request.

    :ivar location: The location of the policy assignment. Only required when utilizing managed
     identity.
    :vartype location: str
    :ivar identity: The managed identity associated with the policy assignment.
    :vartype identity: ~azure.mgmt.resource.policy.models.Identity
    :ivar resource_selectors: The resource selector list to filter policies by resource properties.
    :vartype resource_selectors: list[~azure.mgmt.resource.policy.models.ResourceSelector]
    :ivar overrides: The policy property value override.
    :vartype overrides: list[~azure.mgmt.resource.policy.models.Override]
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "resource_selectors": {"key": "properties.resourceSelectors", "type": "[ResourceSelector]"},
        "overrides": {"key": "properties.overrides", "type": "[Override]"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        identity: Optional["_models.Identity"] = None,
        resource_selectors: Optional[list["_models.ResourceSelector"]] = None,
        overrides: Optional[list["_models.Override"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the policy assignment. Only required when utilizing managed
         identity.
        :paramtype location: str
        :keyword identity: The managed identity associated with the policy assignment.
        :paramtype identity: ~azure.mgmt.resource.policy.models.Identity
        :keyword resource_selectors: The resource selector list to filter policies by resource
         properties.
        :paramtype resource_selectors: list[~azure.mgmt.resource.policy.models.ResourceSelector]
        :keyword overrides: The policy property value override.
        :paramtype overrides: list[~azure.mgmt.resource.policy.models.Override]
        """
        super().__init__(**kwargs)
        self.location = location
        self.identity = identity
        self.resource_selectors = resource_selectors
        self.overrides = overrides


class PolicyDefinition(_serialization.Model):
    """The policy definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy definition.
    :vartype id: str
    :ivar name: The name of the policy definition.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/policyDefinitions).
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.resource.policy.models.SystemData
    :ivar policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
     Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
    :vartype policy_type: str or ~azure.mgmt.resource.policy.models.PolicyType
    :ivar mode: The policy definition mode. Some examples are All, Indexed,
     Microsoft.KeyVault.Data.
    :vartype mode: str
    :ivar display_name: The display name of the policy definition.
    :vartype display_name: str
    :ivar description: The policy definition description.
    :vartype description: str
    :ivar policy_rule: The policy rule.
    :vartype policy_rule: JSON
    :ivar metadata: The policy definition metadata.  Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar parameters: The parameter definitions for parameters used in the policy rule. The keys
     are the parameter names.
    :vartype parameters: dict[str, ~azure.mgmt.resource.policy.models.ParameterDefinitionsValue]
    :ivar version: The policy definition version in #.#.# format.
    :vartype version: str
    :ivar versions: A list of available versions for this policy definition.
    :vartype versions: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "policy_type": {"key": "properties.policyType", "type": "str"},
        "mode": {"key": "properties.mode", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "policy_rule": {"key": "properties.policyRule", "type": "object"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "parameters": {"key": "properties.parameters", "type": "{ParameterDefinitionsValue}"},
        "version": {"key": "properties.version", "type": "str"},
        "versions": {"key": "properties.versions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        policy_type: Optional[Union[str, "_models.PolicyType"]] = None,
        mode: str = "Indexed",
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        policy_rule: Optional[JSON] = None,
        metadata: Optional[JSON] = None,
        parameters: Optional[dict[str, "_models.ParameterDefinitionsValue"]] = None,
        version: Optional[str] = None,
        versions: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
         Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
        :paramtype policy_type: str or ~azure.mgmt.resource.policy.models.PolicyType
        :keyword mode: The policy definition mode. Some examples are All, Indexed,
         Microsoft.KeyVault.Data.
        :paramtype mode: str
        :keyword display_name: The display name of the policy definition.
        :paramtype display_name: str
        :keyword description: The policy definition description.
        :paramtype description: str
        :keyword policy_rule: The policy rule.
        :paramtype policy_rule: JSON
        :keyword metadata: The policy definition metadata.  Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword parameters: The parameter definitions for parameters used in the policy rule. The keys
         are the parameter names.
        :paramtype parameters: dict[str, ~azure.mgmt.resource.policy.models.ParameterDefinitionsValue]
        :keyword version: The policy definition version in #.#.# format.
        :paramtype version: str
        :keyword versions: A list of available versions for this policy definition.
        :paramtype versions: list[str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None
        self.policy_type = policy_type
        self.mode = mode
        self.display_name = display_name
        self.description = description
        self.policy_rule = policy_rule
        self.metadata = metadata
        self.parameters = parameters
        self.version = version
        self.versions = versions


class PolicyDefinitionGroup(_serialization.Model):
    """The policy definition group.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the group. Required.
    :vartype name: str
    :ivar display_name: The group's display name.
    :vartype display_name: str
    :ivar category: The group's category.
    :vartype category: str
    :ivar description: The group's description.
    :vartype description: str
    :ivar additional_metadata_id: A resource ID of a resource that contains additional metadata
     about the group.
    :vartype additional_metadata_id: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "additional_metadata_id": {"key": "additionalMetadataId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        display_name: Optional[str] = None,
        category: Optional[str] = None,
        description: Optional[str] = None,
        additional_metadata_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the group. Required.
        :paramtype name: str
        :keyword display_name: The group's display name.
        :paramtype display_name: str
        :keyword category: The group's category.
        :paramtype category: str
        :keyword description: The group's description.
        :paramtype description: str
        :keyword additional_metadata_id: A resource ID of a resource that contains additional metadata
         about the group.
        :paramtype additional_metadata_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.category = category
        self.description = description
        self.additional_metadata_id = additional_metadata_id


class PolicyDefinitionListResult(_serialization.Model):
    """List of policy definitions.

    :ivar value: An array of policy definitions.
    :vartype value: list[~azure.mgmt.resource.policy.models.PolicyDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicyDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.PolicyDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of policy definitions.
        :paramtype value: list[~azure.mgmt.resource.policy.models.PolicyDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicyDefinitionReference(_serialization.Model):
    """The policy definition reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar policy_definition_id: The ID of the policy definition or policy set definition. Required.
    :vartype policy_definition_id: str
    :ivar definition_version: The version of the policy definition to use.
    :vartype definition_version: str
    :ivar latest_definition_version: The latest version of the policy definition available. This is
     only present if requested via the $expand query parameter.
    :vartype latest_definition_version: str
    :ivar effective_definition_version: The effective version of the policy definition in use. This
     is only present if requested via the $expand query parameter.
    :vartype effective_definition_version: str
    :ivar parameters: The parameter values for the referenced policy rule. The keys are the
     parameter names.
    :vartype parameters: dict[str, ~azure.mgmt.resource.policy.models.ParameterValuesValue]
    :ivar policy_definition_reference_id: A unique id (within the policy set definition) for this
     policy definition reference.
    :vartype policy_definition_reference_id: str
    :ivar group_names: The name of the groups that this policy definition reference belongs to.
    :vartype group_names: list[str]
    """

    _validation = {
        "policy_definition_id": {"required": True},
        "latest_definition_version": {"readonly": True},
        "effective_definition_version": {"readonly": True},
    }

    _attribute_map = {
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "definition_version": {"key": "definitionVersion", "type": "str"},
        "latest_definition_version": {"key": "latestDefinitionVersion", "type": "str"},
        "effective_definition_version": {"key": "effectiveDefinitionVersion", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterValuesValue}"},
        "policy_definition_reference_id": {"key": "policyDefinitionReferenceId", "type": "str"},
        "group_names": {"key": "groupNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        policy_definition_id: str,
        definition_version: Optional[str] = None,
        parameters: Optional[dict[str, "_models.ParameterValuesValue"]] = None,
        policy_definition_reference_id: Optional[str] = None,
        group_names: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_definition_id: The ID of the policy definition or policy set definition.
         Required.
        :paramtype policy_definition_id: str
        :keyword definition_version: The version of the policy definition to use.
        :paramtype definition_version: str
        :keyword parameters: The parameter values for the referenced policy rule. The keys are the
         parameter names.
        :paramtype parameters: dict[str, ~azure.mgmt.resource.policy.models.ParameterValuesValue]
        :keyword policy_definition_reference_id: A unique id (within the policy set definition) for
         this policy definition reference.
        :paramtype policy_definition_reference_id: str
        :keyword group_names: The name of the groups that this policy definition reference belongs to.
        :paramtype group_names: list[str]
        """
        super().__init__(**kwargs)
        self.policy_definition_id = policy_definition_id
        self.definition_version = definition_version
        self.latest_definition_version: Optional[str] = None
        self.effective_definition_version: Optional[str] = None
        self.parameters = parameters
        self.policy_definition_reference_id = policy_definition_reference_id
        self.group_names = group_names


class PolicyDefinitionVersion(_serialization.Model):
    """The ID of the policy definition version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy definition version.
    :vartype id: str
    :ivar name: The name of the policy definition version.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/policyDefinitions/versions).
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.resource.policy.models.SystemData
    :ivar policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
     Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
    :vartype policy_type: str or ~azure.mgmt.resource.policy.models.PolicyType
    :ivar mode: The policy definition mode. Some examples are All, Indexed,
     Microsoft.KeyVault.Data.
    :vartype mode: str
    :ivar display_name: The display name of the policy definition.
    :vartype display_name: str
    :ivar description: The policy definition description.
    :vartype description: str
    :ivar policy_rule: The policy rule.
    :vartype policy_rule: JSON
    :ivar metadata: The policy definition metadata.  Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar parameters: The parameter definitions for parameters used in the policy rule. The keys
     are the parameter names.
    :vartype parameters: dict[str, ~azure.mgmt.resource.policy.models.ParameterDefinitionsValue]
    :ivar version: The policy definition version in #.#.# format.
    :vartype version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "policy_type": {"key": "properties.policyType", "type": "str"},
        "mode": {"key": "properties.mode", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "policy_rule": {"key": "properties.policyRule", "type": "object"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "parameters": {"key": "properties.parameters", "type": "{ParameterDefinitionsValue}"},
        "version": {"key": "properties.version", "type": "str"},
    }

    def __init__(
        self,
        *,
        policy_type: Optional[Union[str, "_models.PolicyType"]] = None,
        mode: str = "Indexed",
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        policy_rule: Optional[JSON] = None,
        metadata: Optional[JSON] = None,
        parameters: Optional[dict[str, "_models.ParameterDefinitionsValue"]] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
         Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
        :paramtype policy_type: str or ~azure.mgmt.resource.policy.models.PolicyType
        :keyword mode: The policy definition mode. Some examples are All, Indexed,
         Microsoft.KeyVault.Data.
        :paramtype mode: str
        :keyword display_name: The display name of the policy definition.
        :paramtype display_name: str
        :keyword description: The policy definition description.
        :paramtype description: str
        :keyword policy_rule: The policy rule.
        :paramtype policy_rule: JSON
        :keyword metadata: The policy definition metadata.  Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword parameters: The parameter definitions for parameters used in the policy rule. The keys
         are the parameter names.
        :paramtype parameters: dict[str, ~azure.mgmt.resource.policy.models.ParameterDefinitionsValue]
        :keyword version: The policy definition version in #.#.# format.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None
        self.policy_type = policy_type
        self.mode = mode
        self.display_name = display_name
        self.description = description
        self.policy_rule = policy_rule
        self.metadata = metadata
        self.parameters = parameters
        self.version = version


class PolicyDefinitionVersionListResult(_serialization.Model):
    """List of policy definition versions.

    :ivar value: An array of policy definitions versions.
    :vartype value: list[~azure.mgmt.resource.policy.models.PolicyDefinitionVersion]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicyDefinitionVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.PolicyDefinitionVersion"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of policy definitions versions.
        :paramtype value: list[~azure.mgmt.resource.policy.models.PolicyDefinitionVersion]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicyExemption(_serialization.Model):
    """The policy exemption.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resource.policy.models.SystemData
    :ivar id: The ID of the policy exemption.
    :vartype id: str
    :ivar name: The name of the policy exemption.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/policyExemptions).
    :vartype type: str
    :ivar policy_assignment_id: The ID of the policy assignment that is being exempted. Required.
    :vartype policy_assignment_id: str
    :ivar policy_definition_reference_ids: The policy definition reference ID list when the
     associated policy assignment is an assignment of a policy set definition.
    :vartype policy_definition_reference_ids: list[str]
    :ivar exemption_category: The policy exemption category. Possible values are Waiver and
     Mitigated. Required. Known values are: "Waiver" and "Mitigated".
    :vartype exemption_category: str or ~azure.mgmt.resource.policy.models.ExemptionCategory
    :ivar expires_on: The expiration date and time (in UTC ISO 8601 format yyyy-MM-ddTHH:mm:ssZ) of
     the policy exemption.
    :vartype expires_on: ~datetime.datetime
    :ivar display_name: The display name of the policy exemption.
    :vartype display_name: str
    :ivar description: The description of the policy exemption.
    :vartype description: str
    :ivar metadata: The policy exemption metadata. Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar resource_selectors: The resource selector list to filter policies by resource properties.
    :vartype resource_selectors: list[~azure.mgmt.resource.policy.models.ResourceSelector]
    :ivar assignment_scope_validation: The option whether validate the exemption is at or under the
     assignment scope. Known values are: "Default" and "DoNotValidate".
    :vartype assignment_scope_validation: str or
     ~azure.mgmt.resource.policy.models.AssignmentScopeValidation
    """

    _validation = {
        "system_data": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "policy_assignment_id": {"required": True},
        "exemption_category": {"required": True},
    }

    _attribute_map = {
        "system_data": {"key": "systemData", "type": "SystemData"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "policy_assignment_id": {"key": "properties.policyAssignmentId", "type": "str"},
        "policy_definition_reference_ids": {"key": "properties.policyDefinitionReferenceIds", "type": "[str]"},
        "exemption_category": {"key": "properties.exemptionCategory", "type": "str"},
        "expires_on": {"key": "properties.expiresOn", "type": "iso-8601"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "resource_selectors": {"key": "properties.resourceSelectors", "type": "[ResourceSelector]"},
        "assignment_scope_validation": {"key": "properties.assignmentScopeValidation", "type": "str"},
    }

    def __init__(
        self,
        *,
        policy_assignment_id: str,
        exemption_category: Union[str, "_models.ExemptionCategory"],
        policy_definition_reference_ids: Optional[list[str]] = None,
        expires_on: Optional[datetime.datetime] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        metadata: Optional[JSON] = None,
        resource_selectors: Optional[list["_models.ResourceSelector"]] = None,
        assignment_scope_validation: Optional[Union[str, "_models.AssignmentScopeValidation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_assignment_id: The ID of the policy assignment that is being exempted.
         Required.
        :paramtype policy_assignment_id: str
        :keyword policy_definition_reference_ids: The policy definition reference ID list when the
         associated policy assignment is an assignment of a policy set definition.
        :paramtype policy_definition_reference_ids: list[str]
        :keyword exemption_category: The policy exemption category. Possible values are Waiver and
         Mitigated. Required. Known values are: "Waiver" and "Mitigated".
        :paramtype exemption_category: str or ~azure.mgmt.resource.policy.models.ExemptionCategory
        :keyword expires_on: The expiration date and time (in UTC ISO 8601 format yyyy-MM-ddTHH:mm:ssZ)
         of the policy exemption.
        :paramtype expires_on: ~datetime.datetime
        :keyword display_name: The display name of the policy exemption.
        :paramtype display_name: str
        :keyword description: The description of the policy exemption.
        :paramtype description: str
        :keyword metadata: The policy exemption metadata. Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword resource_selectors: The resource selector list to filter policies by resource
         properties.
        :paramtype resource_selectors: list[~azure.mgmt.resource.policy.models.ResourceSelector]
        :keyword assignment_scope_validation: The option whether validate the exemption is at or under
         the assignment scope. Known values are: "Default" and "DoNotValidate".
        :paramtype assignment_scope_validation: str or
         ~azure.mgmt.resource.policy.models.AssignmentScopeValidation
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.policy_assignment_id = policy_assignment_id
        self.policy_definition_reference_ids = policy_definition_reference_ids
        self.exemption_category = exemption_category
        self.expires_on = expires_on
        self.display_name = display_name
        self.description = description
        self.metadata = metadata
        self.resource_selectors = resource_selectors
        self.assignment_scope_validation = assignment_scope_validation


class PolicyExemptionListResult(_serialization.Model):
    """List of policy exemptions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of policy exemptions.
    :vartype value: list[~azure.mgmt.resource.policy.models.PolicyExemption]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicyExemption]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.PolicyExemption"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of policy exemptions.
        :paramtype value: list[~azure.mgmt.resource.policy.models.PolicyExemption]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class PolicyExemptionUpdate(_serialization.Model):
    """The policy exemption for Patch request.

    :ivar resource_selectors: The resource selector list to filter policies by resource properties.
    :vartype resource_selectors: list[~azure.mgmt.resource.policy.models.ResourceSelector]
    :ivar assignment_scope_validation: The option whether validate the exemption is at or under the
     assignment scope. Known values are: "Default" and "DoNotValidate".
    :vartype assignment_scope_validation: str or
     ~azure.mgmt.resource.policy.models.AssignmentScopeValidation
    """

    _attribute_map = {
        "resource_selectors": {"key": "properties.resourceSelectors", "type": "[ResourceSelector]"},
        "assignment_scope_validation": {"key": "properties.assignmentScopeValidation", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_selectors: Optional[list["_models.ResourceSelector"]] = None,
        assignment_scope_validation: Optional[Union[str, "_models.AssignmentScopeValidation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_selectors: The resource selector list to filter policies by resource
         properties.
        :paramtype resource_selectors: list[~azure.mgmt.resource.policy.models.ResourceSelector]
        :keyword assignment_scope_validation: The option whether validate the exemption is at or under
         the assignment scope. Known values are: "Default" and "DoNotValidate".
        :paramtype assignment_scope_validation: str or
         ~azure.mgmt.resource.policy.models.AssignmentScopeValidation
        """
        super().__init__(**kwargs)
        self.resource_selectors = resource_selectors
        self.assignment_scope_validation = assignment_scope_validation


class PolicySetDefinition(_serialization.Model):
    """The policy set definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy set definition.
    :vartype id: str
    :ivar name: The name of the policy set definition.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/policySetDefinitions).
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.resource.policy.models.SystemData
    :ivar policy_type: The type of policy set definition. Possible values are NotSpecified,
     BuiltIn, Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and
     "Static".
    :vartype policy_type: str or ~azure.mgmt.resource.policy.models.PolicyType
    :ivar display_name: The display name of the policy set definition.
    :vartype display_name: str
    :ivar description: The policy set definition description.
    :vartype description: str
    :ivar metadata: The policy set definition metadata.  Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar parameters: The policy set definition parameters that can be used in policy definition
     references.
    :vartype parameters: dict[str, ~azure.mgmt.resource.policy.models.ParameterDefinitionsValue]
    :ivar policy_definitions: An array of policy definition references.
    :vartype policy_definitions: list[~azure.mgmt.resource.policy.models.PolicyDefinitionReference]
    :ivar policy_definition_groups: The metadata describing groups of policy definition references
     within the policy set definition.
    :vartype policy_definition_groups:
     list[~azure.mgmt.resource.policy.models.PolicyDefinitionGroup]
    :ivar version: The policy set definition version in #.#.# format.
    :vartype version: str
    :ivar versions: A list of available versions for this policy set definition.
    :vartype versions: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "policy_type": {"key": "properties.policyType", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "parameters": {"key": "properties.parameters", "type": "{ParameterDefinitionsValue}"},
        "policy_definitions": {"key": "properties.policyDefinitions", "type": "[PolicyDefinitionReference]"},
        "policy_definition_groups": {"key": "properties.policyDefinitionGroups", "type": "[PolicyDefinitionGroup]"},
        "version": {"key": "properties.version", "type": "str"},
        "versions": {"key": "properties.versions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        policy_type: Optional[Union[str, "_models.PolicyType"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        metadata: Optional[JSON] = None,
        parameters: Optional[dict[str, "_models.ParameterDefinitionsValue"]] = None,
        policy_definitions: Optional[list["_models.PolicyDefinitionReference"]] = None,
        policy_definition_groups: Optional[list["_models.PolicyDefinitionGroup"]] = None,
        version: Optional[str] = None,
        versions: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_type: The type of policy set definition. Possible values are NotSpecified,
         BuiltIn, Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and
         "Static".
        :paramtype policy_type: str or ~azure.mgmt.resource.policy.models.PolicyType
        :keyword display_name: The display name of the policy set definition.
        :paramtype display_name: str
        :keyword description: The policy set definition description.
        :paramtype description: str
        :keyword metadata: The policy set definition metadata.  Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword parameters: The policy set definition parameters that can be used in policy definition
         references.
        :paramtype parameters: dict[str, ~azure.mgmt.resource.policy.models.ParameterDefinitionsValue]
        :keyword policy_definitions: An array of policy definition references.
        :paramtype policy_definitions:
         list[~azure.mgmt.resource.policy.models.PolicyDefinitionReference]
        :keyword policy_definition_groups: The metadata describing groups of policy definition
         references within the policy set definition.
        :paramtype policy_definition_groups:
         list[~azure.mgmt.resource.policy.models.PolicyDefinitionGroup]
        :keyword version: The policy set definition version in #.#.# format.
        :paramtype version: str
        :keyword versions: A list of available versions for this policy set definition.
        :paramtype versions: list[str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None
        self.policy_type = policy_type
        self.display_name = display_name
        self.description = description
        self.metadata = metadata
        self.parameters = parameters
        self.policy_definitions = policy_definitions
        self.policy_definition_groups = policy_definition_groups
        self.version = version
        self.versions = versions


class PolicySetDefinitionListResult(_serialization.Model):
    """List of policy set definitions.

    :ivar value: An array of policy set definitions.
    :vartype value: list[~azure.mgmt.resource.policy.models.PolicySetDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicySetDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.PolicySetDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of policy set definitions.
        :paramtype value: list[~azure.mgmt.resource.policy.models.PolicySetDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicySetDefinitionVersion(_serialization.Model):
    """The policy set definition version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy set definition version.
    :vartype id: str
    :ivar name: The name of the policy set definition version.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/policySetDefinitions/versions).
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.resource.policy.models.SystemData
    :ivar policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
     Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
    :vartype policy_type: str or ~azure.mgmt.resource.policy.models.PolicyType
    :ivar display_name: The display name of the policy set definition.
    :vartype display_name: str
    :ivar description: The policy set definition description.
    :vartype description: str
    :ivar metadata: The policy set definition metadata.  Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar parameters: The policy set definition parameters that can be used in policy definition
     references.
    :vartype parameters: dict[str, ~azure.mgmt.resource.policy.models.ParameterDefinitionsValue]
    :ivar policy_definitions: An array of policy definition references.
    :vartype policy_definitions: list[~azure.mgmt.resource.policy.models.PolicyDefinitionReference]
    :ivar policy_definition_groups: The metadata describing groups of policy definition references
     within the policy set definition.
    :vartype policy_definition_groups:
     list[~azure.mgmt.resource.policy.models.PolicyDefinitionGroup]
    :ivar version: The policy set definition version in #.#.# format.
    :vartype version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "policy_type": {"key": "properties.policyType", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "parameters": {"key": "properties.parameters", "type": "{ParameterDefinitionsValue}"},
        "policy_definitions": {"key": "properties.policyDefinitions", "type": "[PolicyDefinitionReference]"},
        "policy_definition_groups": {"key": "properties.policyDefinitionGroups", "type": "[PolicyDefinitionGroup]"},
        "version": {"key": "properties.version", "type": "str"},
    }

    def __init__(
        self,
        *,
        policy_type: Optional[Union[str, "_models.PolicyType"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        metadata: Optional[JSON] = None,
        parameters: Optional[dict[str, "_models.ParameterDefinitionsValue"]] = None,
        policy_definitions: Optional[list["_models.PolicyDefinitionReference"]] = None,
        policy_definition_groups: Optional[list["_models.PolicyDefinitionGroup"]] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword policy_type: The type of policy definition. Possible values are NotSpecified, BuiltIn,
         Custom, and Static. Known values are: "NotSpecified", "BuiltIn", "Custom", and "Static".
        :paramtype policy_type: str or ~azure.mgmt.resource.policy.models.PolicyType
        :keyword display_name: The display name of the policy set definition.
        :paramtype display_name: str
        :keyword description: The policy set definition description.
        :paramtype description: str
        :keyword metadata: The policy set definition metadata.  Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword parameters: The policy set definition parameters that can be used in policy definition
         references.
        :paramtype parameters: dict[str, ~azure.mgmt.resource.policy.models.ParameterDefinitionsValue]
        :keyword policy_definitions: An array of policy definition references.
        :paramtype policy_definitions:
         list[~azure.mgmt.resource.policy.models.PolicyDefinitionReference]
        :keyword policy_definition_groups: The metadata describing groups of policy definition
         references within the policy set definition.
        :paramtype policy_definition_groups:
         list[~azure.mgmt.resource.policy.models.PolicyDefinitionGroup]
        :keyword version: The policy set definition version in #.#.# format.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None
        self.policy_type = policy_type
        self.display_name = display_name
        self.description = description
        self.metadata = metadata
        self.parameters = parameters
        self.policy_definitions = policy_definitions
        self.policy_definition_groups = policy_definition_groups
        self.version = version


class PolicySetDefinitionVersionListResult(_serialization.Model):
    """List of policy set definition versions.

    :ivar value: An array of policy set definition versions.
    :vartype value: list[~azure.mgmt.resource.policy.models.PolicySetDefinitionVersion]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicySetDefinitionVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.PolicySetDefinitionVersion"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of policy set definition versions.
        :paramtype value: list[~azure.mgmt.resource.policy.models.PolicySetDefinitionVersion]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicyVariableColumn(_serialization.Model):
    """The variable column.

    All required parameters must be populated in order to send to server.

    :ivar column_name: The name of this policy variable column. Required.
    :vartype column_name: str
    """

    _validation = {
        "column_name": {"required": True},
    }

    _attribute_map = {
        "column_name": {"key": "columnName", "type": "str"},
    }

    def __init__(self, *, column_name: str, **kwargs: Any) -> None:
        """
        :keyword column_name: The name of this policy variable column. Required.
        :paramtype column_name: str
        """
        super().__init__(**kwargs)
        self.column_name = column_name


class PolicyVariableValueColumnValue(_serialization.Model):
    """The name value tuple for this variable value column.

    All required parameters must be populated in order to send to server.

    :ivar column_name: Column name for the variable value. Required.
    :vartype column_name: str
    :ivar column_value: Column value for the variable value; this can be an integer, double,
     boolean, null or a string. Required.
    :vartype column_value: JSON
    """

    _validation = {
        "column_name": {"required": True},
        "column_value": {"required": True},
    }

    _attribute_map = {
        "column_name": {"key": "columnName", "type": "str"},
        "column_value": {"key": "columnValue", "type": "object"},
    }

    def __init__(self, *, column_name: str, column_value: JSON, **kwargs: Any) -> None:
        """
        :keyword column_name: Column name for the variable value. Required.
        :paramtype column_name: str
        :keyword column_value: Column value for the variable value; this can be an integer, double,
         boolean, null or a string. Required.
        :paramtype column_value: JSON
        """
        super().__init__(**kwargs)
        self.column_name = column_name
        self.column_value = column_value


class ResourceSelector(_serialization.Model):
    """The resource selector to filter policies by resource properties.

    :ivar name: The name of the resource selector.
    :vartype name: str
    :ivar selectors: The list of the selector expressions.
    :vartype selectors: list[~azure.mgmt.resource.policy.models.Selector]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "selectors": {"key": "selectors", "type": "[Selector]"},
    }

    def __init__(
        self, *, name: Optional[str] = None, selectors: Optional[list["_models.Selector"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the resource selector.
        :paramtype name: str
        :keyword selectors: The list of the selector expressions.
        :paramtype selectors: list[~azure.mgmt.resource.policy.models.Selector]
        """
        super().__init__(**kwargs)
        self.name = name
        self.selectors = selectors


class ResourceTypeAliases(_serialization.Model):
    """The resource type aliases definition.

    :ivar resource_type: The resource type name.
    :vartype resource_type: str
    :ivar aliases: The aliases for property names.
    :vartype aliases: list[~azure.mgmt.resource.policy.models.Alias]
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "aliases": {"key": "aliases", "type": "[Alias]"},
    }

    def __init__(
        self, *, resource_type: Optional[str] = None, aliases: Optional[list["_models.Alias"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_type: The resource type name.
        :paramtype resource_type: str
        :keyword aliases: The aliases for property names.
        :paramtype aliases: list[~azure.mgmt.resource.policy.models.Alias]
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.aliases = aliases


class Selector(_serialization.Model):
    """The selector expression.

    :ivar kind: The selector kind. Known values are: "resourceLocation", "resourceType",
     "resourceWithoutLocation", and "policyDefinitionReferenceId".
    :vartype kind: str or ~azure.mgmt.resource.policy.models.SelectorKind
    :ivar in_property: The list of values to filter in.
    :vartype in_property: list[str]
    :ivar not_in: The list of values to filter out.
    :vartype not_in: list[str]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "in_property": {"key": "in", "type": "[str]"},
        "not_in": {"key": "notIn", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.SelectorKind"]] = None,
        in_property: Optional[list[str]] = None,
        not_in: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The selector kind. Known values are: "resourceLocation", "resourceType",
         "resourceWithoutLocation", and "policyDefinitionReferenceId".
        :paramtype kind: str or ~azure.mgmt.resource.policy.models.SelectorKind
        :keyword in_property: The list of values to filter in.
        :paramtype in_property: list[str]
        :keyword not_in: The list of values to filter out.
        :paramtype not_in: list[str]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.in_property = in_property
        self.not_in = not_in


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.resource.policy.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.resource.policy.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.resource.policy.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.resource.policy.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentitiesValue(_serialization.Model):
    """UserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class Variable(_serialization.Model):
    """The variable.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resource.policy.models.SystemData
    :ivar id: The ID of the variable.
    :vartype id: str
    :ivar name: The name of the variable.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/variables).
    :vartype type: str
    :ivar columns: Variable column definitions. Required.
    :vartype columns: list[~azure.mgmt.resource.policy.models.PolicyVariableColumn]
    """

    _validation = {
        "system_data": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "columns": {"required": True},
    }

    _attribute_map = {
        "system_data": {"key": "systemData", "type": "SystemData"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "columns": {"key": "properties.columns", "type": "[PolicyVariableColumn]"},
    }

    def __init__(self, *, columns: list["_models.PolicyVariableColumn"], **kwargs: Any) -> None:
        """
        :keyword columns: Variable column definitions. Required.
        :paramtype columns: list[~azure.mgmt.resource.policy.models.PolicyVariableColumn]
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.columns = columns


class VariableListResult(_serialization.Model):
    """List of variables.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of variables.
    :vartype value: list[~azure.mgmt.resource.policy.models.Variable]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Variable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.Variable"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of variables.
        :paramtype value: list[~azure.mgmt.resource.policy.models.Variable]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class VariableValue(_serialization.Model):
    """The variable value.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resource.policy.models.SystemData
    :ivar id: The ID of the variable.
    :vartype id: str
    :ivar name: The name of the variable.
    :vartype name: str
    :ivar type: The type of the resource (Microsoft.Authorization/variables/values).
    :vartype type: str
    :ivar values: Variable value column value array. Required.
    :vartype values: list[~azure.mgmt.resource.policy.models.PolicyVariableValueColumnValue]
    """

    _validation = {
        "system_data": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "values": {"required": True},
    }

    _attribute_map = {
        "system_data": {"key": "systemData", "type": "SystemData"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "values": {"key": "properties.values", "type": "[PolicyVariableValueColumnValue]"},
    }

    def __init__(self, *, values: list["_models.PolicyVariableValueColumnValue"], **kwargs: Any) -> None:
        """
        :keyword values: Variable value column value array. Required.
        :paramtype values: list[~azure.mgmt.resource.policy.models.PolicyVariableValueColumnValue]
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.values = values


class VariableValueListResult(_serialization.Model):
    """List of variable values.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of variable values.
    :vartype value: list[~azure.mgmt.resource.policy.models.VariableValue]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VariableValue]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[list["_models.VariableValue"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of variable values.
        :paramtype value: list[~azure.mgmt.resource.policy.models.VariableValue]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None
