% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_bayesian_to_frequentist.R
\name{convert_bayesian_as_frequentist}
\alias{convert_bayesian_as_frequentist}
\alias{bayesian_as_frequentist}
\title{Convert (refit) a Bayesian model to frequentist}
\usage{
convert_bayesian_as_frequentist(model, data = NULL, REML = TRUE)

bayesian_as_frequentist(model, data = NULL, REML = TRUE)
}
\arguments{
\item{model}{A Bayesian model.}

\item{data}{Data used by the model. If \code{NULL}, will try to extract it
from the model.}

\item{REML}{For mixed effects, should models be estimated using
restricted maximum likelihood (REML) (\code{TRUE}, default) or maximum
likelihood (\code{FALSE})?}
}
\description{
Refit Bayesian model as frequentist. Can be useful for comparisons.
}
\examples{
\dontshow{if (require("rstanarm")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Rstanarm ----------------------
# Simple regressions
model <- rstanarm::stan_glm(Sepal.Length ~ Species,
  data = iris, chains = 2, refresh = 0
)
bayesian_as_frequentist(model)

model <- rstanarm::stan_glm(vs ~ mpg,
  family = "binomial",
  data = mtcars, chains = 2, refresh = 0
)
bayesian_as_frequentist(model)

# Mixed models
model <- rstanarm::stan_glmer(
  Sepal.Length ~ Petal.Length + (1 | Species),
  data = iris, chains = 2, refresh = 0
)
bayesian_as_frequentist(model)

model <- rstanarm::stan_glmer(vs ~ mpg + (1 | cyl),
  family = "binomial",
  data = mtcars, chains = 2, refresh = 0
)
bayesian_as_frequentist(model)
}
\dontshow{\}) # examplesIf}
}
