% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation_recipe.R
\name{visualisation_recipe}
\alias{visualisation_recipe}
\title{Prepare objects for visualisation}
\usage{
visualisation_recipe(x, ...)
}
\arguments{
\item{x}{An \code{easystats} object.}

\item{...}{Other arguments passed to other functions.}
}
\description{
This function prepares objects for visualisation by returning a list of
layers with data and geoms that can be easily plotted using for instance
\code{ggplot2}.

If the \code{see} package is installed, the call to \code{visualization_recipe()} can be
replaced by \code{plot()}, which will internally call the former and then plot it
using \code{ggplot}. The resulting plot can be customized ad-hoc (by adding
ggplot's geoms, theme or specifications), or via some of the arguments
of \code{visualisation_recipe()} that control the aesthetic parameters.

See the specific documentation page for your object's class:
\itemize{
\item {modelbased}: \url{https://easystats.github.io/modelbased/reference/visualisation_recipe.estimate_predicted.html}
\item {correlation}: \url{https://easystats.github.io/correlation/reference/visualisation_recipe.easycormatrix.html}
}
}
