% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{FeaturePlot}
\alias{FeaturePlot}
\alias{FeatureHeatmap}
\title{Visualize 'features' on a dimensional reduction plot}
\usage{
FeaturePlot(
  object,
  features,
  dims = c(1, 2),
  cells = NULL,
  cols = if (blend) {
     c("lightgrey", "#ff0000", "#00ff00")
 } else {
    
    c("lightgrey", "blue")
 },
  pt.size = NULL,
  alpha = 1,
  stroke.size = NULL,
  order = FALSE,
  min.cutoff = NA,
  max.cutoff = NA,
  reduction = NULL,
  split.by = NULL,
  keep.scale = "feature",
  shape.by = NULL,
  slot = "data",
  blend = FALSE,
  blend.threshold = 0.5,
  label = FALSE,
  label.size = 4,
  label.color = "black",
  repel = FALSE,
  ncol = NULL,
  coord.fixed = FALSE,
  by.col = TRUE,
  sort.cell = deprecated(),
  interactive = FALSE,
  combine = TRUE,
  raster = NULL,
  raster.dpi = c(512, 512)
)
}
\arguments{
\item{object}{Seurat object}

\item{features}{Vector of features to plot. Features can come from:
\itemize{
  \item An \code{Assay} feature (e.g. a gene name - "MS4A1")
  \item A column name from meta.data (e.g. mitochondrial percentage -
    "percent.mito")
  \item A column name from a \code{DimReduc} object corresponding to the
    cell embedding values (e.g. the PC 1 scores - "PC_1")
}}

\item{dims}{Dimensions to plot, must be a two-length numeric vector specifying x- and y-dimensions}

\item{cells}{Vector of cells to plot (default is all cells)}

\item{cols}{The two colors to form the gradient over. Provide as string vector with
the first color corresponding to low values, the second to high. Also accepts a Brewer
color scale or vector of colors. Note: this will bin the data into number of colors provided.
When blend is \code{TRUE}, takes anywhere from 1-3 colors:
\describe{
  \item{1 color:}{Treated as color for double-negatives, will use default colors 2 and 3 for per-feature expression}
  \item{2 colors:}{Treated as colors for per-feature expression, will use default color 1 for double-negatives}
  \item{3+ colors:}{First color used for double-negatives, colors 2 and 3 used for per-feature expression, all others ignored}
}}

\item{pt.size}{Adjust point size for plotting}

\item{alpha}{Alpha value for plotting (default is 1)}

\item{stroke.size}{Adjust stroke (outline) size of points}

\item{order}{Boolean determining whether to plot cells in order of expression. Can be useful if
cells expressing given feature are getting buried.}

\item{min.cutoff, max.cutoff}{Vector of minimum and maximum cutoff values for each feature,
may specify quantile in the form of 'q##' where '##' is the quantile (eg, 'q1', 'q10')}

\item{reduction}{Which dimensionality reduction to use. If not specified, first searches for umap, then tsne, then pca}

\item{split.by}{A factor in object metadata to split the plot by, pass 'ident'
to split by cell identity}

\item{keep.scale}{How to handle the color scale across multiple plots. Options are:
\itemize{
  \item \dQuote{feature} (default; by row/feature scaling): The plots for
    each individual feature are scaled to the maximum expression of the
    feature across the conditions provided to \code{split.by}
  \item \dQuote{all} (universal scaling): The plots for all features and
    conditions are scaled to the maximum expression value for the feature
    with the highest overall expression
  \item \code{NULL} (no scaling): Each individual plot is scaled to the
    maximum expression value of the feature in the condition provided to
    \code{split.by}. Be aware setting \code{NULL} will result in color
    scales that are not comparable between plots
}}

\item{shape.by}{If NULL, all points are circles (default). You can specify any
cell attribute (that can be pulled with FetchData) allowing for both
different colors and different shapes on cells.  Only applicable if \code{raster = FALSE}.}

\item{slot}{Which slot to pull expression data from?}

\item{blend}{Scale and blend expression values to visualize coexpression of two features}

\item{blend.threshold}{The color cutoff from weak signal to strong signal; ranges from 0 to 1.}

\item{label}{Whether to label the clusters}

\item{label.size}{Sets size of labels}

\item{label.color}{Sets the color of the label text}

\item{repel}{Repel labels}

\item{ncol}{Number of columns to combine multiple feature plots to, ignored if \code{split.by} is not \code{NULL}}

\item{coord.fixed}{Plot cartesian coordinates with fixed aspect ratio}

\item{by.col}{If splitting by a factor, plot the splits per column with the features as rows; ignored if \code{blend = TRUE}}

\item{sort.cell}{Redundant with \code{order}. This argument is being
deprecated. Please use \code{order} instead.}

\item{interactive}{Launch an interactive \code{\link[Seurat:IFeaturePlot]{FeaturePlot}}}

\item{combine}{Combine plots into a single \code{\link[patchwork]{patchwork}ed}
ggplot object. If \code{FALSE}, return a list of ggplot objects}

\item{raster}{Convert points to raster format, default is \code{NULL} which
automatically rasterizes if plotting more than 100,000 cells}

\item{raster.dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore(). Default is c(512, 512).}
}
\value{
A \code{\link[patchwork]{patchwork}ed} ggplot object if
\code{combine = TRUE}; otherwise, a list of ggplot objects
}
\description{
Colors single cells on a dimensional reduction plot according to a 'feature'
(i.e. gene expression, PC scores, number of genes detected, etc.)
}
\note{
For the old \code{do.hover} and \code{do.identify} functionality, please see
\code{HoverLocator} and \code{CellSelector}, respectively.
}
\examples{
data("pbmc_small")
FeaturePlot(object = pbmc_small, features = 'PC_1')

}
\seealso{
\code{\link{DimPlot}} \code{\link{HoverLocator}}
\code{\link{CellSelector}}
}
\concept{visualization}
