//! # DBus interface proxy for: `org.freedesktop.UDisks2.Manager.NVMe`
//!
//! This code was generated by `zbus-xmlgen` `4.0.0` from DBus introspection data.
//! Source: `org.freedesktop.UDisks2.xml`.
//!
//! You may prefer to adapt it, instead of using it verbatim.
//!
//! More information can be found in the
//! [Writing a client proxy](https://dbus2.github.io/zbus/client.html)
//! section of the zbus documentation.
//!

use zbus::proxy;

use crate::error;

pub mod controller;
pub mod fabrics;
pub mod namespace;

#[proxy(
    interface = "org.freedesktop.UDisks2.Manager.NVMe",
    default_service = "org.freedesktop.UDisks2",
    default_path = "/org/freedesktop/UDisks2/Manager"
)]
pub trait NVMe {
    /// Connect method
    fn connect(
        &self,
        subsysnqn: &[u8],
        transport: &str,
        transport_addr: &str,
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<zbus::zvariant::OwnedObjectPath>;

    /// SetHostID method
    #[zbus(name = "SetHostID")]
    fn set_host_id(
        &self,
        hostid: &[u8],
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<()>;

    /// SetHostNQN method
    #[zbus(name = "SetHostNQN")]
    fn set_host_nqn(
        &self,
        hostnqn: &[u8],
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<()>;

    /// HostID property
    #[zbus(property, name = "HostID")]
    fn host_id(&self) -> error::Result<Vec<u8>>;

    /// HostNQN property
    #[zbus(property, name = "HostNQN")]
    fn host_nqn(&self) -> error::Result<Vec<u8>>;
}
