#![allow(clippy::assertions_on_constants, clippy::equatable_if_let, clippy::needless_if)]
#![warn(clippy::collapsible_if, clippy::collapsible_else_if)]

#[rustfmt::skip]
fn main() {
    let x = "hello";
    let y = "world";
    // Collapse `else { if .. }` to `else if ..`
    if x == "hello" {
        print!("Hello ");
    } else {
        if y == "world" {
            println!("world!")
        }
    }
    //~^^^^^ collapsible_else_if

    if x == "hello" {
        print!("Hello ");
    } else {
        if let Some(42) = Some(42) {
            println!("world!")
        }
    }
    //~^^^^^ collapsible_else_if

    if x == "hello" {
        print!("Hello ");
    } else {
        if y == "world" {
            println!("world")
        }
        else {
            println!("!")
        }
    }
    //~^^^^^^^^ collapsible_else_if

    if x == "hello" {
        print!("Hello ");
    } else {
        if let Some(42) = Some(42) {
            println!("world")
        }
        else {
            println!("!")
        }
    }
    //~^^^^^^^^ collapsible_else_if

    if let Some(42) = Some(42) {
        print!("Hello ");
    } else {
        if let Some(42) = Some(42) {
            println!("world")
        }
        else {
            println!("!")
        }
    }
    //~^^^^^^^^ collapsible_else_if

    if let Some(42) = Some(42) {
        print!("Hello ");
    } else {
        if x == "hello" {
            println!("world")
        }
        else {
            println!("!")
        }
    }
    //~^^^^^^^^ collapsible_else_if

    if let Some(42) = Some(42) {
        print!("Hello ");
    } else {
        if let Some(42) = Some(42) {
            println!("world")
        }
        else {
            println!("!")
        }
    }
    //~^^^^^^^^ collapsible_else_if

    if x == "hello" {
        print!("Hello ");
    } else {
        #[cfg(not(roflol))]
        if y == "world" {
            println!("world!")
        }
    }
}

#[rustfmt::skip]
fn issue_7318() {
    if true { println!("I've been resolved!")
    }else{
        if false {}
    }
    //~^^^ collapsible_else_if
}

fn issue_13365() {
    // all the `expect`s that we should fulfill
    if true {
    } else {
        #[expect(clippy::collapsible_else_if)]
        if false {}
    }

    if true {
    } else {
        #[expect(clippy::style)]
        if false {}
    }

    if true {
    } else {
        #[expect(clippy::all)]
        if false {}
    }

    if true {
    } else {
        #[expect(warnings)]
        if false {}
    }
}

fn issue14799() {
    use std::ops::ControlFlow;

    let c: ControlFlow<_, ()> = ControlFlow::Break(Some(42));
    if let ControlFlow::Break(Some(_)) = c {
        todo!();
    } else {
        #[cfg(target_os = "freebsd")]
        todo!();

        if let ControlFlow::Break(None) = c {
            todo!();
        } else {
            todo!();
        }
    }
}

fn in_parens() {
    let x = "hello";
    let y = "world";

    if x == "hello" {
        print!("Hello ");
    } else {
        (if y == "world" { println!("world") } else { println!("!") })
    }
    //~^^^ collapsible_else_if
}

fn in_brackets() {
    let x = "hello";
    let y = "world";

    // There is no lint when the inner `if` is in a block.
    if x == "hello" {
        print!("Hello ");
    } else {
        { if y == "world" { println!("world") } else { println!("!") } }
    }
}
