/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * This file is dual-licensed.
 * In addition to the GPLv3 license mentioned above, this code is also
 * licensed under LGPL 2.1. See LICENSES/COPYING.LGPL file for the
 * full text of the license.
 *
 */

/* Detection tables for Once Upon A Time: Baba Yaga and Abracadabra. */

#ifndef GOB_DETECTION_TABLES_ONCEUPON_H
#define GOB_DETECTION_TABLES_ONCEUPON_H

// -- Once Upon A Time: Abracadabra, Amiga --

{
	{
		"abracadabra",
		"",
		AD_ENTRY3s("stk1.stk", "a8e963eea170155548e5bc1d0f07d50d", 209806,
		           "stk2.stk", "e4b21818af03930dc9cab2ad4c93cb5b", 362106,
		           "stk3.stk", "76874ad92782f9b2de57beafc05ec877", 353482),
		FR_FRA,
		kPlatformAmiga,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"abracadabra",
		"",
		AD_ENTRY3s("stk1.stk", "a8e963eea170155548e5bc1d0f07d50d", 209806,
				   "stk2.stk", "e4b21818af03930dc9cab2ad4c93cb5b", 362106,
				   "stk3.stk", "76874ad92782f9b2de57beafc05ec877", 353482),
		DE_DEU,
		kPlatformAmiga,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"abracadabra",
		"",
		AD_ENTRY3s("stk1.stk", "a8e963eea170155548e5bc1d0f07d50d", 209806,
			       "stk2.stk", "e4b21818af03930dc9cab2ad4c93cb5b", 362106,
			       "stk3.stk", "76874ad92782f9b2de57beafc05ec877", 353482),
		EN_ANY,
		kPlatformAmiga,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"abracadabra",
		"",
		AD_ENTRY3s("stk1.stk", "a8e963eea170155548e5bc1d0f07d50d", 209806,
                   "stk2.stk", "e4b21818af03930dc9cab2ad4c93cb5b", 362106,
                   "stk3.stk", "76874ad92782f9b2de57beafc05ec877", 353482),
		IT_ITA,
		kPlatformAmiga,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"abracadabra",
		"",
		AD_ENTRY3s("stk1.stk", "a8e963eea170155548e5bc1d0f07d50d", 209806,
				   "stk2.stk", "e4b21818af03930dc9cab2ad4c93cb5b", 362106,
				   "stk3.stk", "76874ad92782f9b2de57beafc05ec877", 353482),
		ES_ESP,
		kPlatformAmiga,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},

// -- Once Upon A Time: Abracadabra, Atari ST --

{
	{
		"abracadabra",
		"",
		AD_ENTRY3s("stk1.stk", "a8e963eea170155548e5bc1d0f07d50d", 209806,
			       "stk2.stk", "c6440aaf068ec3149ae89bc5c41ebf02", 362123,
			       "stk3.stk", "5af3c1202ba6fcf8dad2b2125e1c1383", 353257),
		FR_FRA,
		kPlatformAtariST,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"abracadabra",
		"",
		AD_ENTRY3s("stk1.stk", "a8e963eea170155548e5bc1d0f07d50d", 209806,
			       "stk2.stk", "c6440aaf068ec3149ae89bc5c41ebf02", 362123,
			       "stk3.stk", "5af3c1202ba6fcf8dad2b2125e1c1383", 353257),
		DE_DEU,
		kPlatformAtariST,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"abracadabra",
		"",
		AD_ENTRY3s("stk1.stk", "a8e963eea170155548e5bc1d0f07d50d", 209806,
			       "stk2.stk", "c6440aaf068ec3149ae89bc5c41ebf02", 362123,
			       "stk3.stk", "5af3c1202ba6fcf8dad2b2125e1c1383", 353257),
		EN_ANY,
		kPlatformAtariST,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"abracadabra",
		"",
		AD_ENTRY3s("stk1.stk", "a8e963eea170155548e5bc1d0f07d50d", 209806,
			       "stk2.stk", "c6440aaf068ec3149ae89bc5c41ebf02", 362123,
			       "stk3.stk", "5af3c1202ba6fcf8dad2b2125e1c1383", 353257),
		IT_ITA,
		kPlatformAtariST,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"abracadabra",
		"",
		AD_ENTRY3s("stk1.stk", "a8e963eea170155548e5bc1d0f07d50d", 209806,
			       "stk2.stk", "c6440aaf068ec3149ae89bc5c41ebf02", 362123,
			       "stk3.stk", "5af3c1202ba6fcf8dad2b2125e1c1383", 353257),
		ES_ESP,
		kPlatformAtariST,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},

// -- Once Upon A Time: Baba Yaga, DOS EGA Floppy --

{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "3c777f43e6fb49fde9222543447e135a", 204813,
			       "stk2.stk", "6cf0b009dd185a8f589e91a1f9c33df5", 361582,
			       "stk3.stk", "6473183ca4db1b5b5cea047f9af59a26", 328925),
		FR_FRA,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesAdLib | kFeaturesEGA,
	0, 0, 0
},
{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "3c777f43e6fb49fde9222543447e135a", 204813,
			       "stk2.stk", "6cf0b009dd185a8f589e91a1f9c33df5", 361582,
			       "stk3.stk", "6473183ca4db1b5b5cea047f9af59a26", 328925),
		DE_DEU,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesAdLib | kFeaturesEGA,
	0, 0, 0
},
{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "3c777f43e6fb49fde9222543447e135a", 204813,
			       "stk2.stk", "6cf0b009dd185a8f589e91a1f9c33df5", 361582,
			       "stk3.stk", "6473183ca4db1b5b5cea047f9af59a26", 328925),
		EN_ANY,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesAdLib | kFeaturesEGA,
	0, 0, 0
},
{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "3c777f43e6fb49fde9222543447e135a", 204813,
			       "stk2.stk", "6cf0b009dd185a8f589e91a1f9c33df5", 361582,
			       "stk3.stk", "6473183ca4db1b5b5cea047f9af59a26", 328925),
		IT_ITA,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesAdLib | kFeaturesEGA,
	0, 0, 0
},
{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "3c777f43e6fb49fde9222543447e135a", 204813,
			       "stk2.stk", "6cf0b009dd185a8f589e91a1f9c33df5", 361582,
			       "stk3.stk", "6473183ca4db1b5b5cea047f9af59a26", 328925),
		ES_ESP,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesAdLib | kFeaturesEGA,
	0, 0, 0
},

// -- Once Upon A Time: Baba Yaga, Amiga --

{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "bcc823d2888057031e54716ed1b3c80e", 205090,
				   "stk2.stk", "f76bf7c2ff60d816d69962d1a593207c", 362122,
				   "stk3.stk", "6227d1aefdf39d88dcf83e38bea2a9af", 328922),
		FR_FRA,
		kPlatformAmiga,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "bcc823d2888057031e54716ed1b3c80e", 205090,
			       "stk2.stk", "f76bf7c2ff60d816d69962d1a593207c", 362122,
			       "stk3.stk", "6227d1aefdf39d88dcf83e38bea2a9af", 328922),
		DE_DEU,
		kPlatformAmiga,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "bcc823d2888057031e54716ed1b3c80e", 205090,
			       "stk2.stk", "f76bf7c2ff60d816d69962d1a593207c", 362122,
			       "stk3.stk", "6227d1aefdf39d88dcf83e38bea2a9af", 328922),
		EN_ANY,
		kPlatformAmiga,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "bcc823d2888057031e54716ed1b3c80e", 205090,
			       "stk2.stk", "f76bf7c2ff60d816d69962d1a593207c", 362122,
			       "stk3.stk", "6227d1aefdf39d88dcf83e38bea2a9af", 328922),
		IT_ITA,
		kPlatformAmiga,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "bcc823d2888057031e54716ed1b3c80e", 205090,
			       "stk2.stk", "f76bf7c2ff60d816d69962d1a593207c", 362122,
			       "stk3.stk", "6227d1aefdf39d88dcf83e38bea2a9af", 328922),
		ES_ESP,
		kPlatformAmiga,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},

// -- Once Upon A Time: Baba Yaga, Atari ST --

{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "17a4e3e7a18cc97231c92d280c7878a1", 205095,
				   "stk2.stk", "bfbc380e5461f63af28e9e6b10f334b5", 362128,
				   "stk3.stk", "6227d1aefdf39d88dcf83e38bea2a9af", 328922),
		FR_FRA,
		kPlatformAtariST,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "17a4e3e7a18cc97231c92d280c7878a1", 205095,
				   "stk2.stk", "bfbc380e5461f63af28e9e6b10f334b5", 362128,
				   "stk3.stk", "6227d1aefdf39d88dcf83e38bea2a9af", 328922),
		DE_DEU,
		kPlatformAtariST,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "17a4e3e7a18cc97231c92d280c7878a1", 205095,
				   "stk2.stk", "bfbc380e5461f63af28e9e6b10f334b5", 362128,
				   "stk3.stk", "6227d1aefdf39d88dcf83e38bea2a9af", 328922),
		EN_ANY,
		kPlatformAtariST,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "17a4e3e7a18cc97231c92d280c7878a1", 205095,
				   "stk2.stk", "bfbc380e5461f63af28e9e6b10f334b5", 362128,
				   "stk3.stk", "6227d1aefdf39d88dcf83e38bea2a9af", 328922),
		IT_ITA,
		kPlatformAtariST,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},
{
	{
		"babayaga",
		"",
		AD_ENTRY3s("stk1.stk", "17a4e3e7a18cc97231c92d280c7878a1", 205095,
				   "stk2.stk", "bfbc380e5461f63af28e9e6b10f334b5", 362128,
				   "stk3.stk", "6227d1aefdf39d88dcf83e38bea2a9af", 328922),
		ES_ESP,
		kPlatformAtariST,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSUBTITLES, GUIO_NOSPEECH)
	},
	kFeaturesEGA,
	0, 0, 0
},

#endif // GOB_DETECTION_TABLES_ONCEUPON_H
