---
title: Changes in the 2024 releases (versions 1.20.0 and 1.21.0)
---

## Version 1.21.0 (10.10.2024)

### Bugfixes

- sumo
  - Fixed unhelpful error message when giving an edge id instead of a lane id for a stop #15158 (regression in 1.11.0)
  - Fixed invalid error when loading a trip directly after a route with `repeat` #14992 (regression in 1.20.0)
  - Persons joining edge via access don't collide with vehicles again #15030 (regression in 1.20.0)
  - personInfo total duration now includes ride waiting time #14887
  - Fixed jump-related bug when there are two stops on the same edge #14883
  - Fixed saving/loading of maximum time value from state #14904
  - Fixed creeping vehicle approach to oncoming pedestrian on shared space #14920
  - Fixed invalid busStop id in warning "aborted waiting at busStop" #14929
  - Fixed emergency braking at pedestrian crossings #14939
  - Fixed emergency braking at pedestrian crossing in subsecond simulation #14928
  - Fixed emergency braking for right-turning traffic at prioritized pedestrian crossing #14952
  - Fixed emergency braking due to unsafe insertion speed #14941
  - Fixed unsafe insertion speed before prioritized pedestrian crossing when using **--step-method.ballistic**. #14951
  - Fixed lane-changing related deadlock around stopped vehicles #14322
  - Fixed crash when parallel routing encounters invalid trips #14963
  - Fixed handling of passed stops after rerouting #14918
  - Fixed crash when using junction-taz in railway simulation #14973
  - Fixed non-deterministic behavior with option **--device.rerouting.threads --weights.random-factor** #10292
  - Electric vehicles now issues a warning on running out of battery power #14980
  - Fixed crash when loading misconfigured NEMA controller #15001
  - Fixed invalid stopping when loading a route with attribute `repeat` and a single stop #13639
  - Fixed invalid density in edgedata-output in sublane simulation #15017
  - Fixed invalid behavior by GLOSA device when there are junctions ahead of a traffic light within **device.glosa.range** #15011
  - Removal of JuPedSim-pedestrians in vanishing area with period < 1 is now working. #14900
  - No more cooperative speed adaptation when setting lcCooperative=-1. #14871
  - Fixed invalid initial blinker for continuous lanechange in lefthand network #15058
  - Now avoiding orthogonal sliding in continuos lane change model with attribute `lcMaxSpeedLatStanding="0"` #15052
  - GLOSA device now follows intended 3-phase speed trajectory (decel, constant, accel) instead of (decel, accel) #15067
  - Fixed negative emissions with HBEFA4 model #15079
  - Fixed duplicate 'started' and 'ended' values in vehroute-output #15086
  - Fixed invalid taxi state when receiving a new dispatch while parking #15080
  - Fixed invalid stopping when a route with a single stop uses attribute `repeat` #13639
  - Fixed invalid rerouting one edge with change prohibitions #15098
  - Fixed collision in roundabout in network without internal links #15100
  - Fixed invalid GLOSA behavior when loading multiple programs for a traffic light #15139
  - Fixed crash during portion working #15165
  - Fixed skipped stop when train is joined by a vehicle on another edge #15166
  - Fixed high memory usage in simulation with chargingStations when not using **--chargingstations-output** #15238
  - Fixed bug where simulation does not finish with onDemand stop #15263
  - Fixed queue length estimation for laneAreaDetectors of delay_based traffic lights #15247
  - Fixed invalid laneAreaDetector end position checks #15275
  - Fixed bug where vehicle skips stop after waypoint #15293
  - Fixed emergency braking at zipper with low visibilityDistance #15224
  - Fixed bug where parking rerouter does not reroute occupants #15276
  - Fixed crash when using rerouters on vehicles with stops and looped routes #15290
  - Fixed low insertion speed for `departSpeed="max"` with waypoint #15308
  - Fixed nondeterministic order of constraint trackers in saved state #15406
  - Fixed infinite loop if rerouter interval end < begin #15416
  - Fixed bug where vType-param "device.rerouting.probability" could not be used to prevent rerouting #15288
  - edgeData output now excludes non-driving lanes from laneDensity computation #15383
  - rerouter closingReroute now preserves all existing stops when computing new route #14610
  - Fixed invalid emergency stop message for waypoint at route end #15485
  - Fixed bug where taxi disappears during dispatch #15508
  - Fixed crash when loading state related to rerouting device assignment #15517
  - Now updating via edges when rerouting to an alternative parkingArea #15545
  - StartUpDelay and ActionStepLength can now be used together #14229
  - StartUpDelay now works with small timesteps and IDM #14289
  - Fixed crash when using taxi with pre-booking and ride sharing #15385

- netconvert
  - Fixed crash when guessing ramps #14836 (regression in 1.20.0)
  - Fixed crash when edge removal affects roundabouts defined in OSM. #14930 (regression in 1.20.0)
  - OSM: fixed invalid bus permission on tram line #15301 (regression in 1.20.0)
  - Fixed bad ramp geometry when two ramps overlap #14839
  - Fixed invalid connection with option **--ramps.guess** if the input defines connections #14833
  - Fixed unsafe waiting position within a junction that conflicts with a pedestrian crossing #14946
  - Fixed invalid NEMA controllers in written network #15023
  - Fixed signal precision, signal lane validity and 0-length edges in xodr output. #15078
  - Fixed ugly junction shape #15103
  - Fixed self overlapping crossing outline shape #15111
  - Crossing parameters are now loaded from plain-xml #15135
  - Fixed double-projection of node and crossing shapes when setting option **--proj** #15136, #15137
  - Option **--railway.signal.guess.by-stops** can no longer turn switches into signals #15153
  - Fixed invalid pedestrian infrastructure connections that could cause invalid pedestrian routes #15177, #15183
  - Fixed broken lane shape in opendrive import #15197
  - Matsim import now handles node ids with unusual characters #15196
  - Fixed crash during opendrive import with boundary filter #15243
  - Fixed crash when using tlLayout="alternateOneWay" with crossings #14027
  - Connections from the same edge to the same target edge that cross over each other are now recognized as being in conflict. #15257

- netedit
  - Polygon context menu functions *simplify shape* and *close shape* are working again #14857 (regression in 1.6.0)
  - Custom junction shape polygon now has the correct context menu #14858 (regression in 1.6.0)
  - Fixed crash when attempting to transform person to personFlow #15040 (regression in 1.19.0)
  - Fixed Crash during undo-redo of stops/waypoints over stoppingPlaces #15249 (regression in 1.19.0)
  - Fixed crash when editing person and container types for a selection #15255 (regression in 1.19.0)
  - Fixed junction highlighting on hovering in edge mode #15413 (regression in 1.19.0)
  - Fixed invalid "embededRoute" element in view #15492 (regression in 1.19.0)
  - Vehicle type attribute dialog: guiShape combobox is now working with default vClass #14859  (regression in 1.19.0)
  - Fixed invalid tls link indices #14949 (regression in 1.20.0)
  - Fixed inspecting and selecting elements in data mode #14999 (regression in 1.20.0)
  - Fixed bug where additionals were not saved when saving a NeteditConfig #14739 (regression in 1.20.0)
  - Button "center" in "locate additional" dialog is working again #14986 (regression in 1.20.0)
  - Selecting lanes and edges via context menu is working again #14965 (regression in 1.20.0)
  - Inspected trips show the route again #14964 (regression in 1.20.0)
  - Selection rectangle now considers element locks again. #15010 (regression in 1.20.0)
  - TazRelations can be inspected again #15019 (regression in 1.20.0)
  - Fixed crash when joining edges with crossings #15073 (regression in 1.20.0)
  - Fixed crash when removing junction with crossing in loaded network #15112 (regression in 1.20.0)
  - Additional objects no longer disappear at certain zoom levels #15104 (regression in 1.20.0)
  - Fixed invalid dotted contour around calibrators #15138 (regression in 1.20.0)
  - Fixed click detection to rerouter/vaporizer and stoppingPlace symbols #15280 (regression in 1.20.0)
  - Fixed coloring of selected Persons and containers #15254 (regression in 1.20.0)
  - Fixed crash when creating tranships with different speed #15339 (regression in 1.20.0)
  - Fixed crash related to invalid endOffset #15317 (regression in 1.20.0)
  - Fixed invalid coloring for lane change prohibition #15099 (regression in 1.20.0)
  - Fixed highlighting during POIs and parkingSpace movement #15509, #15512 (regression in 1.20.0)
  - Objects with enabled text rendering (i.e. ID) are always visible at any zoom #15519 (regression in 1.20.0)
  - Fixed crash when using "Replace junction by geometry point" and traffic demand is loaded #14863
  - In inspect mode, the junction contour no longer hides link indices #14948
  - Fixed invalid NEMA controller when changing type from static #15007
  - Fixed invalid junction contour #15002, #14488
  - Fixed crash when loading another network while the traffic light frame has an active traffic light #15004
  - Fixed uncontrolled pedestrian crossings after using 'Clean States' #15047
  - Undo-button becomes instantly active after undoable action #14770
  - Edge context menu function *apply edge template* now applies to the whole selection #14458
  - Rerouters and VSS without edges or lanes are no longer written #15151
  - Hotkey <kbd>BACKSPACE</kbd> now works for taking back a stopping place in person mode #14802
  - Fixed crash when replacing junction by geometry point #15233
  - edgeData attribute `writeAttributes` is now written correctly #15273
  - Fixed error creating POI over lanes #15042
  - Can now parse sumocfg with human readable times #15267
  - Fixed problem when setting stopOffsetException in multiple edges #15297
  - Fixed crash when replacing junction by geometry point in network with person trips #15286
  - Fixed containers creation on top of an existing plan #15344
  - Can now select/inspect/delete person stops clicking over sign #15350
  - Fixed crash recomputing network with volatile recomputing and loaded vehicles #15356
  - Can now create rides with only one edge #15361
  - Fixed clicking Person/container plans over TAZs #15363
  - Fixed crash trying to move persons over TAZ #15365
  - Fixed crash joining junctions with crossings #15328
  - Fixed loss of TAZ edges after recomputing with volatile options #15401
  - Stop attribute `parking` now takes effect when set in *Stop mode* #15439
  - Crossings are now preserved when converting a junction to a roundabout #15231
  - Hotkey ESC now aborts creation of edgeRelation #15228
  - Right click over geometry point now opens edge context menu #15322
  - Fixed invalid "Cursor position in view" values in contextual menu for E2 multilane detectors #15064
  - Fixed crash changing type inspecting multiple containers #14081
  - Persons and container may now use any kind of stopping place #12384
  - Target highlighting in person and container modes now works when mouse is over another person / container #14803
  - Fixed slow-down when loading many polygons #14600
  - Fixed junction merging with active grid #15483
  - Can now load laneAreaDetector defined with endPos #14683
  - Copy template now copies the changeLeft/changeRight attributes #15507
  - Contour of non-filled polygons is now reset after moving #15541
  - Fixed crash when attempting to create a joined NEMA controller #15547
  - Fixed lefthand drawing of additional elements #15566

- sumo-gui
  - Reloading now works if SUMO_HOME is not set #14830 (regression in 1.15.0)
  - Fixed glitch when drawing carriages on edges with custom length. #15075 (regression in 1.17.0)
  - Fixed crash when saving view settings to registry #14909 (regression in 1.19.0)
  - Fixed bad menu spacing and tiny icons when using display scaling on windows (i.e. for high-pixel-count displays) #14882
  - Fixed translation-related crashes where code relied on hard coded english menu entries. #14710
  - Fixed placement of chargingStation and ParkingArea symbol in lefthand networks #14744, #14959, #15110
  - Fixed invalid angle for infrastructure text label in lefthand networks #14743, #14955
  - Fixed invalid scaling of aircraft when zoomed out #14899
  - "Set breakpoint" can no longer cause a crash when no network is loaded #15003
  - Message window "time link" is now working for vehicle-person-collision warning #14931
  - Fixed crash on right-click in "color edge by inclination" mode #14856
  - Fixed invalid lateral placement of wide busStops and containerStops #15089
  - Fixed invalid rotation of articulated vehicles when parked #15168
  - Improved clickable message log in translated GUI #14759
  - Added warning if breakpoint file does not exist #3424
  - Fixed centering on riding person when vehicle exaggeration is active #15397
  - Fixed inconsistent rendering of walkingarea shape depending on zoom #15424

- meso
  - Fixed invalid segment properties when an edge does not allow passenger cars #15020
  - Fixed invalid laneData when using option **--meso-multi-queue** #15093

- TraCI
  - Fixed ignored calls to `vehicle.changeTarget` and `vehicle.setRoute` after calling `vehicle.moveToXY`. #15123 (regression in 1.13.0)
  - Fixed handling of large time input values #14793
  - Fixed crash when trying to call `traci.vehicle.dispatchTaxi` for an undeparted vehicle #15016
  - Fixed invalid error when constructing a new TraCILogic with libsumo #15164
  - traci.simulation.findIntermodalRoute can now be used to find taxi mode routes #15172
  - traci.vehicle.getNextTLS now works for parking vehicles #15181
  - Fixed crash when calling vehicle.getDrivingDistance2D in meso #15404
  - vehicle.getLeader retrieval now works beyond 3000m if subsequent edges have only 1 lane (i.e. for railways) #15418
  - subscribeContext when used without varIDs now uses the default attributes of the target domain. #15430
  - vehicle.getLanePosition is now working for a parked vehicle #15450
  - Setting stop parameter "expected" now works #15486
  - Setting speedFactor now works for walking stages added with appendStage and appendWalkingStage #15518, #15527

- tools
  - osmGet.py: Fixed error downloading data from servers that do not provide gzipped data. #15105 (regression in 1.20.0)
  - sumolib.net.readNet now works with old versions of lxml and pathlib.Path arguments #15422 (regression in 1.20.0)
  - generateParkingAreaRerouters.py : No longer fails if there are more than parkingAreas in the input file #14880
  - traceExporter.py: fixed inconsistent trj-output #14925
  - matsim_importPlans.py: now properly quotes all parameters to ensure that the output is valid XML #14988
  - mapDetectors.py: No longer writes invalid lane pos #15117
  - createScreenshotSequence.py: Now works with the same key frame settings in a row #15352

### Enhancements

- sumo
  - Improved speed of writing xml output by 60% #14994, #8905
  - Added time stamp to E3 warnings #14870
  - personInfo now writes actual stage depart times instead of desired depart #14886
  - added option **--max-num-persons** to delay person insertion above a given threshold. #14884
  - A warning is now given when starting more persons in a vehicle than it's personCapacity permits #14752
  - Persons and containers now support vType attribute `boardingFactor` which gets multiplied with the boarding- or loadingDuration of the vehicle. #14869
  - Loaded polygons can be used to influence [jupedsim agents](../Simulation/Pedestrians.md#model_jupedsim) #14325
  - PHEMlight5 parameters can now be configured with [generic parameters](../Simulation/GenericParameters.md) #14285
  - Electric vehicles now support [defining variable charge rate](../Models/Electric.md#defining_electric_vehicles) #14860
  - The new option **--emission-output.attributes** can now be used to customize the output #12850
  - Jupedsim pedestrian model now waits at pedestrian crossings #15012
  - EIDM model now has a fixed upper boundary to drivererror-intensity to avoid issues for vehicles with high acceleration. #15066
  - GLOSA device now uses speedFactor to set it's target speed when slowing down to improve interaction with carFollowModels #15067
  - Reduced redundant vClass warnings from taxi device #15090
  - Added extra penalty for turnarounds during routing, configurable with option **--weights.turnaround-penalty** #4966
  - Individual speedFactor is now adjusted when switching vehicle type (with calibrators, devices or TraCI) #15076
  - Added GLOSA options to increase or reduce safety. #15152
  - Added vType-attribute `jmStopSignWait` to customize required waiting time at stop sign #15163
  - Actuated traffic lights now support phase attributes `earlyTarget="DEFAULT"` and `finalTarget="DEFAULT"`. This simplifies combining default switching rules (gap based) with custom conditions #14669
  - chargingStation default power is now 22kW (instead of 0) #15144
  - Added warning for unusual distribution definitions #15146
  - fcd-output now contains the vtype for pedestrians #15210
  - Added option **--chargingstations-output.aggregated** to write output that is more compact #15240
  - vType attribute `jmAllwayStopWait` can now be used to customize required waiting time at allwayStop #15428
  - time-to-teleport.disconnected may now be higher than time-to-teleport #15494
  - Stop attribute `index` can now be used to encode stopping on a later edge of a looped route #15503
  - The battery model now records depletion events in tripinfo output #15529

- netedit
  - Junctions and edges now have the virtual attribute `isRoundabout`. This makes it easy to select and find all roundabouts in a network #14865
  - Mode for editing overhead wires now warns about experimental state #14974
  - Using check boxes in submenu now keeps the menu open #15009
  - Loading a single file without options now supports .sumocfg files #15015
  - Add new vClass icons #14646
  - Convert-to-roundabout function now sets roundabout edge properties based on incoming edges #15069
  - Hotkey <kbd>ESC</kbd> + <kbd>SHIFT</kbd> can be used to clear the selection regardless of editing mode #14481
  - Making person/container plan wider on mouse-over #15337
  - Now Showing junctions while creating person and container plans #15345
  - Added detectPersons to InductionLoop attributes #15515

- sumo-gui
  - Traffic light dialog for tracking phases can now scroll to see all links #3862
  - Different color schemes are now supported when calibrating colors to the data (recalibrate rainbow) #12483
  - Improved rendering speed on right-click #15035
  - Reduce width of lane parameter dialog (by adding linebreaks) #15051
  - POI attribute `width` can now be used to configure POI size (in m) #15444

- meso
  - vType attribute `jmTimeGapMinor` is now considered when running with option **--meso-junction-control** #15171
  - depart and arrival lanes are now part of tripinfo output #7680

- netconvert
  - OSM import now supports distances and speeds with units (i.e. feet, knots) #14885
  - OSM import now warns if ways, nodes or relations are out of order #14892
  - OSM import now handles trolleybus routes #14932
  - Shapefile import now respects option **--default.spreadtype** #14984
  - Added option **--geometry.max-angle.fix** for removing sharp angles within edge #15221
  - Added option **--default.connection.cont-pos** to change the default internal junction position (or disable internal junctions) #13642

- marouter
  - Loaded trip attributes (i.e. departLane and departSpeed) are now preserved #15049

- duarouter
  - Added extra penalty for turnarounds during routing, configurable with option **--weights.turnaround-penalty** #4966

- traci
  - The new sumo option **--keep-after-arrival TIME** keeps vehicle objects in memory for a configurable time after their arrival. This makes it possible to retrieve properties of their trip. #9891
  - Fixed missing leader/follower information in lanechange output after forced change. #14912
  - chargingStation attributes can now be modified #12772
  - Added functions `edge.getBidiEdge` and `lane.getBidiLane` #15186
  - Added functions `getMass` and `setMass` to the vehicle, person and vehicletype domains #15258
  - Added person stages now support all stopping places and not only busStops #15281
  - Meso simulation now supports functions `vehicle.getSegmentIndex` and `vehicle.getSegmentID` #14681
  - Meso simulation with option **--meso-lane-queue** now supports `vehicle.getLaneIndex` #15341

- tools
  - plotXMLAttributes.py: can now use special attribute `@FILE` to simplify plotting of multiple files where each file provides one value #14843
  - plotXMLAttributes.py: added option **--robust-parser** which handles files without linebreak after each element #15340
  - gtfs2pt.py: Now warns if no valid GTFS inside the network boundaries has been found #14876
  - addStops2Routes.py: Can now create waypoints by setting option **--speed**. #14895
  - traceExporter.py now supports options **-c** and **-C** for loading and saving configuration files #14934
  - generateRailSignalConstraints.py: Added missing constraint for parking vehicles with 'ended' value. #14609
  - generateRailSignalConstraints.py: Added option **--abort-unordered.keep-actual** which keeps stops after a detected overtaking as valid if they have started/ended values #15065
  - generateRailSignalConstraints.py: Added option **--all-inactive** for setting all constraints as inactive #15312
  - createVehTypeDistribution.py: now automatically writes `speedDev` when only `speedFactor` is defined by the user to avoid a wider distribution than may be expected #15025
  - mapDetectors.py: Option **--max-radius** can now be used to configure maximum mapping radius #15118
  - mapDetectors.py: Can now handle CSV with BOM #15116
  - net2geojson.py: can now optionally include numLanes and speed as properties #15109
  - distributeChargingStations.py: this is a new tool for adding chargingStations to a network with parkingAreas #14667

### Miscellaneous

- configuration file root elements are now application-specific #7700
- Unknown vehicle classes are now ignored by sumo to ensure upwards compatibility when adding classes in the future. Netconvert and duarouter support this behavior by setting option **--ignore-errors** #14993
- Saving config files now handles environment variables as absolute path #15022
- `sumolib.checkBinary` now finds sumo binaries installed via pip #14982
- SUMO game language switch is now working in the downloadable zip #13440
- Fixed broken images in game-cross scenario #15083
- DEFAULT_CONTAINERTYPE now uses vClass `container` #15092
- parkingArea default roadsideCapacity is 1 (instead of 0) if no space definitions are given #15264
- plotting tools can now handle Matplotlib versions suffix like ".post1" #15372
- Fixed invalid characters in documentation command examples #15441
- Fixed inconsistent argument name in libsumo function Vehicle.moveTo #15304
- A warning is now given when trying to use carFollowModel EIDM with actionSteps #15557

## Version 1.20.0 (07.05.2024)

### Bugfixes

- sumo
  - Fixed inconsistent edgeData and laneData emissions. #14209
  - Fixed crash with SSM device and incomplete routes. #14201
  - Fixed invalid handling of jumps after stopping twice in the same spot. #14324
  - Teleported vehicles are no longer moved onto restricted lanes. Issue #14168
  - Speeds imposed by variable speed signs (VSS) or TraCI now take precedence of vClass-restricted speeds (this was said to be fixed in 1.19 but didn't work) #13652
  - Fixed crash when using **--lateral-resolution** with **--no-internal-links** #14460
  - chargingstations-output no longer records charging when battery is full #14473
  - Fixed undefined behavior during opposite direction driving #14475
  - Fixed crash when loading NEMA controller with pedestrian crossings. #14474
  - NEMA controller now warns about missing green phase #14502
  - Fixed bug where person enters the wrong vehicle on looped public transport line #14526
  - Routes with jumps now support attribute `repeat` #14549
  - Fixed crash when a person plan contains walks or personTrips where origin equals destination #14558
  - Fixed invalid insertion after jump #14578
  - Fixed emergency braking in roundabout. #14587
  - traffic light detectors no longer assume having seen a vehicle on step before the simulation started #14590
  - Removed unneeded warning when a person uses a vehicular connection #14619
  - Fixed invalid departSpeed for IDM in subsecond simulation #14621
  - Fixed invalid traffic demand when defining poisson flows with rate below 0.001 #14664
  - Fixed crash when loading person stages without a person (now writes an error) #14654
  - Fixed xsd validation error for router interval with human-readable time #14728
  - HBEFA4 electric vehicles can now recuperate #14764
  - A warning is now given when loading a disconnected walk #14779
  - When simulating a disconnected walk, the walking direction is now correct after passing the disconnected part #14780
  - Fixed invalid pedestrian jam warning #14796
  - Taxi
    - Fixed problem with **--device.taxi.idle-algorithm taxistand** when the destination is unreachable. #14115
    - Taxi reservations from the same busStop are now grouped if the dispatcher permits it #14612
    - Fixed bug where simulation hangs #14821
    - Fixed bug where taxi exits the simulation prematurely #14819
    - Fixed invalid taxi pickup time estimation from busStop #14822
  - Railways
    - Fixed trains getting stuck on reversal due to routing failure. #14332 (also affects duarouter)
    - Inserting vehicle with depart="split" now works on short edges. #14359
    - fixed collision during portion working when train route continues after join. #14350
    - Rail signals now permit train joins where the front is joined to the rear part. #14349
    - Fixed invalid rail signal warnings for looped route with jumps #14554

- netedit
  - Fixed invalid warning when creating poiGeo #14425 (regression in 1.9.0)
  - Lane markings are rendered below the junction bubble again #14417 (regression in 1.12.0)
  - The unsupported attribute "lines" is no longer written for a personTrip #14463 (regression in 1.15.0)
  - Fixed crash on undo #14702 (regression in 1.15.0)
  - Fixed invalid "save" dialog after loading additionals from file. #14464 (regression in 1.16.0)
  - The size and position of the settings dialog are now stored across sessions. #14571 (regression in 1.16.0)
  - Fixed missing connections after adding edge #14391 (regression in 1.19.0)
  - Alt+Hotkeys for menus are working again #14396 (regression in 1.19.0)
  - Fixed superfluous scrollbars in combo boxes #14412 (regression in 1.19.0)
  - Fixed numerical errors in poisson flow rate #14648 (regression in 1.19.0)
  - Fixed crash when loading vTypeDistribution #14733 (regression in 1.19.0)
  - Fixed invalid default lane permissions when writing a `<laneClosingReroute>` #14348
  - Tool plot_trajectories.py is now usable. #14147
  - "copy type" now also copies vehicle class #14444
  - Fixed crash when trying to define ride between busStops #14462
  - Fixed use of python tools involving space in paths #14469
  - Fixed saving of python tool config involving space in paths #14506
  - Fixed invalid state of save-sumoconfig button after changing option #14581
  - Saving traffic light programs to a file now writes all attributes #14674
  - Custom connection permissions can now be reset #14723
  - Fixed bad signal plan after applying 'join junctions' to part of a joined traffic light #14797
  - Fixed person mode bug where it was impossible to define a new person on a short that already had a person on it #14801


- netcovert
  - Fixed crash when importing incomplete OSM data #14766 (regression in 1.15.0)
  - Signal state sequences (green-yellow-green) is no longer generated. #14295
  - Roundabouts defined explicitly in OSM now have correct right-of-way regardless of geometry. #13970
  - Fixed problems related to option **--dlr-navteq-output**. #14071
  - Option **--junctions.minimal-shape** now persists when re-processing the network. #14375
  - Fixed invalid permissions in OSM import of ferry routes. #14362
  - Fixed crash when importing Vissim Network with unusual geometry. #14413
  - Prevented writing an invalid network when aborting with an error #14470
  - NEMA junctions now stays consistent on recompute #14491
  - NEMA junctions now work correctly with option --tls.group-signals #14440
  - generated NEMA controller now also gives green to pedestrians #14501
  - Fixed crash when processing NEMA junctions with pedestrian crossings #14555
  - Fixed broken junction shapes in 3D network. #10645
  - Edge parameters are no longer lost when using option **--geometry.remove**. #14517
  - Fixed invalid route in ptline-output. #14534
  - bike lane default width is now applied to both directions in OSM import #14560
  - Fixed missing bus connection in OSM import. #14507
  - Fixed bug where attribute `allowed` and `disallowed` were not minimal #14632
  - Large circular network structures are no longer misclassified as roundabout. The size threshold can be configured with option **--roundabouts.guess.max-length** #14634
  - Motorway ramp building no longer fails when the default IDs for new junctions and edges are already in the network. #14658
  - Fixed invalid walking area shape #14688, #14731
  - Fixed the root causes for "Unequal lengths of bidi lane" warnings #14699
  - OSM: fixed bug when importing cycle lane #14419
  - Preventing oversized junction join #14769
  - Fixed bad node shape #14777
  - Increased available width on large walkingareas (avoids jamming on shared-space) #14800

- sumo-gui
  - Fixed wrong context menu when clicking on lane in mesosim #14457 (regression in 1.15.0)
  - Fixed positioning of guiShape "scooter". #13691
  - Fixed misleading visualization of single-car vehicle length in draw-rail-carriages mode. #14330
  - Fixed invalid default for edges minSize when loading incomplete gui settings file. #14384
  - Persons are no longer drawn outside the vehicle when drawn as triangle #14433
  - option **--write-license** from configfile is now respected #14494
  - Fixed visible grid in satellite background image tiles. #14573
  - Fixed bug where the legend name was unreadable on black background #14651
  - Fixed chargingStation power text label position/rotation #14740

- meso
  - Fixed bug where taxi fails to pick up person on the current segment. #14500
  - traci functions edge.setMaxSpeed and lane.setMaxSpeed now work correctly when increasing speed #14552,  #14566
  - Fixed invalid error when personTrips require walking before taxi use #14575
  - Fixed invalid error during intermodal routing #14575
  - Fixed bug where vehicles skip ahead after lane speed update #14593

- duarouter
  - Fixed xsd validation error when loading walk or stop with geo-coordinates #14426
  - Fixed invalid intermodal route on looped public transport (also affects routing in sumo) #14343

- od2trips
  - Fixed extremely high running time when loading large TAZ. #14784

- TraCI
  - Fixed error in `trafficlight.setProgramLogic` when loading actuated logic with default minDur and maxDur #14741 (regression in 1.12.0)
  - Fixed missing internal lane length in traci.vehicle.getNextTLS. #14246
  - `vehicle.setStopParameter` now supports "jump" #14441
  - `vehicle.setSpeed` no longer causes stop at wrong position #14459
  - Fixed result of `vehicle.getLeader` for junction leaders #14617
  - Fixed invalid behavior after removing a stop with `vehicle.replaceStop` #14696
  - Fixed invalid traci constant for traffic light type #14736
  - Stops are no longer lost when calling `vehicle.changeTarget` #14789
  - Fixed crash when calling `simulation.loadState` with active vehicle highlights #8511
  - Fixed computation of driving distance along a route #14760
  - Fix for wrong lane occupancy calculation when minGap of vehicles is changed #13024

- Tools
  - osmWebWizard no longer aborts with error if a configured mode has no infrastructure. #14361
  - xml output from edgeDataDiff can now be loaded in netedit and sumo-gui. #14387
  - tileGet.py is able to use mapQuest service again. #14202
  - checkStopOrder.py: Fixed faulty warnings when generating table for multiple locations #14562
  - osmGet.py: Fixed missing building shapes (also affects osmWebWizard.py) #14598
  - Fixed problem locating binary applications on windows. #14676

- Activitygen: Fixed wrong working hour fallback times. #14344

### Enhancements

- sumo
  - Added new vClasses: subway, scooter, aircraft, cable_car, wheelchair, drone, container #12335
  - Access elements support `pos="doors"` to change the algorithm for placing passengers that exit the vehicle. #14336
  - chargingStation now supports attribute "parkingArea". When set, vehicles will only charge after reaching that parkingArea. #13596
  - Persons and containers that continue in a train after [split/join](../Simulation/Railways.md#portion_working) no longer incur boarding or loading delay. #14360
  - Added new attribute `departPos="splitFront"` which causes a train with [`depart="split"`](../Simulation/Railways.md#portion_working) to be created at the front rather than the rear of the original train. #14358
  - vType attribute `mass` is now used within `carFollowModel="Rail"`. #13055
  - Option **--fcd-output.attributes** now supports the value 'arrivalDelay' #14447
  - Sumo now allows specifying departure and arrival positions in network or geo-coordinates #2182
  - carFollowModel "Rail" now permits loading custom model curves for traction and resistance #14258
  - speedFactorPremature can now make use of stop parameter "flexArrival" if a reference time other than the scheduled arrival is needed. #14503
  - Using jumps together with 'via' is now supported. #14585
  - Option **--weights.tls-penalty** now also applies to tls-controlled pedestrian crossings. #14653
  - Option **--vehroute-output.cost** now applies to routed persons #14655
  - The [battery device](../Models/Electric.md) now supports saving and loading state. #14624
  - Stages generated from `<personTrip>` now inherit params from the personTrip. #14513
  - Actuated traffic lights are now more flexible when controlling minor links (reduced warnings of type "... has no controlling detector" warnings) #14692
  - It is now possible to set the vehicle routing mode via `<param key="device.rerouting.mode" value="..."/>` either in the vType or the vehicle/trip/flow. Setting it to value of `8` lets a vehicle ignore rerouter-induced permission changes on insertion and rerouting. The default routing mode for all vehicles can be set with option **--device.rerouting.mode** (even for vehicles that do not have such a device). #13494, #14815
  - A personFlow with `depart="triggered"` can now be distributed over a flow of vehicles #14806
  - vTypes and parkingAreas now support attribute 'parkingBadges' to control access #14482
  - personInfo (in tripinfo-output) now include data that aggregates over all stages of the plan #14823
  - tranship to stopping place other than containerStop can now be defined #15399

- netedit
  - Now sidewalk and bikelane width can be edited in *create edge mode*. #9725
  - Added new netedit option --ignore-missing-inputs. #12395
  - Add color legend in person and container modes. #13139
  - Now netedit checks if repeated routes are valid before saving. #13503
  - Disable stopOffsetException row if stopOffset is 0. #14065
  - Improved rendering speed for large networks. #13894
  - Added red contour to moved elements. #14109
  - The maximum number of rows for a combo box can now be configured in the gui settings (persistent across sessions) #14412
  - Added option for selective hiding of short edges when zoomed out (enabled by default to increase frame rate) #14487
  - POIs and polygons now support "show-cursor position / geo-position" in the context menu #14812

- sumo-gui
  - Hotkey B now sets a breakpoint at the current time. Alt+B ahead of the current time. #10400
  - Train visualization param `locomotiveLength` now supports value *0*, to prevent rendering of a locomotive. #14351
  - The new train visualization param `carriageImages` accepts a comma-separated list of image files to enable distinct images for the different carriages. #14403
  - Reduced exaggerated size of long vehicles (i.e. trains) when zoomed out. Issue #14423
  - Reduced the number of bike markings being rendered to increase realism and reduce clutter. #14545
  - Airways now have their own default color #14813
  - Added more information to stop info in vehicle parameter dialog #15395

- netconvert
  - Edge widths are now imported from OSM. The new option **--ignore-widths** can be used to restore legacy behavior. #4392
  - Added option **-junctions.endpoint-shape** to compute the junction shape based on custom edge endpoints instead of the usual geometry heuristics. #14341
  - Option **--output.street-names** is now enabled by default if **--shapefile.name** is set. #14399
  - OSM import now support importing restricted turn lane information (i.e. turn:bus:lanes) #14476
  - More rail signals are imported from OSM and option **--osm.railsignals** can be used for fine grained control of signal interpretation. #14483
  - Rail signal direction is now imported from OSM #14512
  - Option **--keep-edges.postload** now applies to permission and speed based edge filters. This is useful when these values are updated with patches or public transport processing. #14528
  - Loaded ptLine period can now be patched by loading the same id in **ptline-files** #14586
  - OSM import now exports subways as vClass "subway" and aerialway as "cable_car" #14644
  - Now importing access="no" from OSM #14650
  - Improved now shape computation to allow more slanted stop lines #14778
  - OSM import now distinguishes barrier crossings from no-barrier rail crossings #14786

- polyconvert
  - Option **--osm.merge-relations** now handles "holes" #14599
  - Improved import of waterbodies and harbours #14597

- duarouter
  - Added support for loading ride with geo-coordinates #14427
  - When writing person stops, the stopping place name is now written as a comment. #14521
  - Added option **--weights.tls-penalty** to improve reliability of travel time. #14653

- TraCI / libsumo
  - person-stage attributes `travelTime` now reflects the spent time for the current stage. #11838
  - Function `vehicle.replaceStop(..., teleport=1)` is now usable without enabling teleports (by using a "jump" to move the vehicle) #14438, #14468
  - inductionloop.getIntervalOccupancy, getIntervalMeanSpeed and getIntervalVehicleNumber are now retrievable in meso #7492
  - [TocDevice](../ToC_Device.md) openGap parameters can now be set via `vehicle.setParameter` #14582
  - in mesosim, `lane.setMaxSpeed` now only affects a single queue when running with **--meso-lane-queue** #14589
  - Added functions `edge.getFromJunction`, `edge.getToJunction`, `junction.getIncomingEdges`, `junction.getOutgoingEdges` to query the network topology. #14490
  - The routing mode value `ROUTING_MODE_INGNORE_TRANSIENT_PERMISSIONS` can now be used to ignore temporary permission changes from rerouters. #14205
  - Added function `trafficlight.getSpentDuration` #14400
  - `trafficlight.getParameter(tlsID, "typeName")` now retrieves traffic light type #14737

- Tools
  - added [createScreenshotSequence.py](../Tools/Misc.md#createscreenshotsequencepy) to help with creating videos from a simulation with scripted view movements. #14060
  - tileGet.py supports downloading rendered tiles from OSM. #14241
  - added `sumolib.net.node.getMaxTLLinkIndex` #14373
  - gtfs2pt.py nows support human-readable times output using option **-H**. #11192
  - [matsim_importPlans.py](../Tools/Import/MATSim.md) now supports loading input with coordinates #14422
  - plot_trajectories.py now supports meso fcd when setting option **--meso**. #14592
  - sumolib.net now supports `getVersion` to retrieve the network version #14636
  - osmWebWizard now takes into account traffic lights for intermodal routing to avoid persons missing their ride #14653
  - osmWebWizard now runs with option **--tls.actuated.jam-threshold 30** to improve the capabilities (and efficiency) of traffic lights #14580
  - Added tools/visualization/plotWKT.py for plotting WKT files
  - ptlines2flows.py supports option **--join** to concatenate lines which serve opposite directions. This reduces conflict on single-track rail lines #5320
  - sumolib.shapes.polygon now supports more attributes. #5429
  - Added tool net/buildFullGraph.py to help with building point-to-point aerial mobility #14811
  - Added tool net/patchVClasses.py for downgrading new networks to be used with older SUMO versions and for manipulating permissions in general. #14798


### Miscellaneous

- [Numerical access restrictions](../Simulation/VehiclePermissions.md#custom_access_restrictions) for routing are now documented.  #14370
- Fixed inconsistent documentation for jumps #14316
- The "build" directory has been renamed to "build_config" to allow "build" to be used for build outputs.
- [Plexe](https://plexe.car2x.org/) now supports platoon-aware lane change logic #14809, #14395
- Added 6 new configuration files for the [MMPEVEM](../Models/MMPEVEM.md) model. #14499
- The battery device now uses param "rotatingMass" instead of "internalMomentOfInertia". The old value has been deprecated. The default value was changed to improve realism. #12513, #13422
- The network now contains outline shapes for pedestrian crossings #11668
- stop-output has slightly reordered attributes to easier see the busStop-id without horizontal scrolling #14542
- extractTest.py now works for netdiff.py tests #14725
- duarouter: adapted Gawron default values to make them consistent with duaIterate.py. #14772
