---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, glossaire, glossarie, bibtex,
              fichier bib, dictionnaire, définition, lexique
---

# Comment utiliser une base de données de définitions pour mes glossaires ?

L'extension <ctanpkg:bib2gls> fournit un exécutable nommé `bib2gls` (écrit 
en Java) qui extrait des entrées de glossaire placées dans un fichier BIB, 
sous cette forme :

```bibtex
@entry{xyloglotte,
   name = {xyloglotte},
   description = {langue de bois}
}
@entry{ambisenestre,
   name = {ambisenestre},
   description = {maladroit des deux mains (terme propre à la 
                  \gls{xyloglotte})}
}
@abbreviation{sncf,
   short = "sncf",
   long = {Société nationale des chemins de fer français}
}
@symbol{v,
   name = {$\vec{v}$},
   text = {\vec{v}},
   description = {un vecteur}
}
```

De cette façon, vous pouvez par exemple utiliser 
[JabRef](https://www.jabref.org/) pour gérer votre base de données, 
puis <ctanpkg:bib2gls> pour extraire les défintions utilisées 
dans votre document. 

Par exemple, le document suivant que nous allons nommer `test.tex` 
va appeler le fichier BIB ci-dessus que nous nommons `termes.bib`.

```{noedit}
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[colorlinks]{hyperref}
  \usepackage[record,   % utilisation de bib2gls
              postdot,  % ajout d'un point final après chaque description
             ]{glossaries-extra}
  \GlsXtrLoadResources[src ={termes}]

\begin{document}
\section{Parlons xyloglotte !}
La \gls{xyloglotte}, cette langue que vous pouvez utiliser même 
si vous êtes \gls{ambisenestre}.
\printunsrtglossary
\end{document}
```

Une fois ce document compilé avec LaTeX, vous exécutez la commande suivante :

```bash
bib2gls test
``` 

Puis vous compilez à nouveau votre document TEX afin d'obtenir
le glossaire.

La [documentation](texdoc:bib2gls) de <ctanpkg:bib2gls> est 
extrêmement détaillée (au point de paraître impressionnante).


:::{sources}
- [Documentation](texdoc:bib2gls) de <ctanpkg:bib2gls>
- [Sorting Glossaries with bib2gls](https://latex.net/sorting-glossaries-with-bib2gls/),
  sur [LaTeX.net](https://latex.net/)
:::