from typing import Any, Generic, TypeVar
from typing_extensions import Self

__tracebackhide__: bool

_V = TypeVar("_V", default=Any)

class ContainsMixin(Generic[_V]):
    def contains(self, *items: object) -> Self: ...
    def does_not_contain(self, *items: object) -> Self: ...
    def contains_only(self, *items: object) -> Self: ...
    def contains_sequence(self, *items: object) -> Self: ...
    def contains_duplicates(self) -> Self: ...
    def does_not_contain_duplicates(self) -> Self: ...
    def is_empty(self) -> Self: ...
    def is_not_empty(self) -> Self: ...
    def is_in(self, *items: _V) -> Self: ...
    def is_not_in(self, *items: _V) -> Self: ...
