/* Webcamoid, webcam capture application.
 * Copyright (C) 2016  Gonzalo Exequiel Pedone
 *
 * Webcamoid is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Webcamoid is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Webcamoid. If not, see <http://www.gnu.org/licenses/>.
 *
 * Web-Site: http://webcamoid.github.io/
 */

#ifndef COLORTAPELEMENT_H
#define COLORTAPELEMENT_H

#include <iak/akelement.h>

class ColorTapElementPrivate;

class ColorTapElement: public AkElement
{
    Q_OBJECT
    Q_PROPERTY(QString table
               READ table
               WRITE setTable
               RESET resetTable
               NOTIFY tableChanged)

    public:
        ColorTapElement();
        ~ColorTapElement();

        Q_INVOKABLE QString table() const;

    private:
        ColorTapElementPrivate *d;

    protected:
        QString controlInterfaceProvide(const QString &controlId) const;
        void controlInterfaceConfigure(QQmlContext *context,
                                       const QString &controlId) const;
        AkPacket iVideoStream(const AkVideoPacket &packet);

    signals:
        void tableChanged(const QString &table);

    public slots:
        void setTable(const QString &table);
        void resetTable();
};

#endif // COLORTAPELEMENT_H
